/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import msfgui.Base64;
import msfgui.InteractWindow;
import msfgui.MsfException;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.PopupMouseListener;
import msfgui.RpcConnection;
import msfgui.SearchDwldOptionsDialog;
import msfgui.TableHelper;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class MeterpFileBrowser
extends MsfFrame {
    protected Map session;
    protected Map sessionPopupMap;
    protected final RpcConnection rpcConn;
    protected ReentrantLock lock;
    protected Map files;
    protected List fileVector;
    protected Timer readTimer = null;
    protected final Icon folderIcon;
    protected final Icon fileIcon;
    protected JFileChooser fchooser;
    protected JPopupMenu popupMenu;
    protected final DefaultTableModel model;
    protected InteractWindow interactWin;
    private JButton deleteButton;
    private JButton dirButton;
    private JButton downloadButton;
    private JScrollPane jScrollPane1;
    private JTable mainTable;
    private JLabel pwdLabel;
    private JButton recSearchDownloadButton;
    private JButton refreshButton;
    private JButton upButton;
    private JButton uploadButton;

    public MeterpFileBrowser(RpcConnection rpcConn, Map session, Map sessionPopupMap) {
        super("Meterpreter remote file browsing");
        Icon tempIcon;
        this.rpcConn = rpcConn;
        this.session = session;
        this.interactWin = (InteractWindow)sessionPopupMap.get(session.get("uuid"));
        this.lock = this.interactWin.lock;
        this.files = new HashMap();
        this.fileVector = new Vector(100);
        this.initComponents();
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.mainTable.setModel(this.model);
        this.mainTable.setShowHorizontalLines(false);
        this.mainTable.setShowVerticalLines(false);
        this.fchooser = new JFileChooser();
        final FileSystemView view = FileSystemView.getFileSystemView();
        this.folderIcon = view.getSystemIcon(view.getDefaultDirectory());
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", ".txt");
            tempIcon = view.getSystemIcon(tempFile);
            tempFile.delete();
        }
        catch (IOException iox) {
            tempIcon = null;
            JOptionPane.showMessageDialog(null, "Cannot create temp file. Weird.");
        }
        this.fileIcon = tempIcon;
        tempFile.delete();
        this.mainTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (!MeterpFileBrowser.this.mainTable.getColumnName(col).equals("Name")) {
                    label.setIcon(null);
                    return label;
                }
                if (MeterpFileBrowser.this.files.get(value) != null && MeterpFileBrowser.this.files.get(value).equals("dir")) {
                    label.setIcon(MeterpFileBrowser.this.folderIcon);
                    return label;
                }
                try {
                    File tempFile = File.createTempFile("temp", value.toString());
                    label.setIcon(view.getSystemIcon(tempFile));
                    tempFile.delete();
                }
                catch (IOException iox) {
                    label.setIcon(MeterpFileBrowser.this.fileIcon);
                }
                return label;
            }
        });
        this.fchooser.setMultiSelectionEnabled(false);
        this.popupMenu = new JPopupMenu();
        JMenuItem men = new JMenuItem("Delete");
        men.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeterpFileBrowser.this.delete();
            }
        });
        this.popupMenu.add(men);
        men = new JMenuItem("Download");
        men.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MeterpFileBrowser.this.download();
            }
        });
        this.popupMenu.add(men);
        this.setupPopupMenu(rpcConn, session);
    }

    private Object executeCommand(String text) throws MsfException {
        return this.rpcConn.execute("session.meterpreter_write", this.session.get("id"), Base64.encode(text.getBytes()));
    }

    private void setupPopupMenu(RpcConnection rpcConn, Map session) {
        this.mainTable.addMouseListener(new PopupMouseListener(){

            public void doubleClicked(MouseEvent e) {
                int indx = MeterpFileBrowser.this.mainTable.getSelectedRow();
                if (indx == -1) {
                    return;
                }
                String clickedFile = MeterpFileBrowser.this.mainTable.getValueAt(indx, 0).toString();
                if (MeterpFileBrowser.this.files.get(clickedFile).equals("dir")) {
                    try {
                        MeterpFileBrowser.this.executeCommand("cd \"" + clickedFile + "\"\n");
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex);
                    }
                    MeterpFileBrowser.this.getFiles();
                } else {
                    MeterpFileBrowser.this.download();
                }
            }

            public void showPopup(MouseEvent e) {
                int indx = MeterpFileBrowser.this.mainTable.getSelectedRow();
                if (indx == -1) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    MeterpFileBrowser.this.popupMenu.show(MeterpFileBrowser.this.mainTable, e.getX(), e.getY());
                }
            }
        });
    }

    protected void delete() {
        int indx = this.mainTable.getSelectedRow();
        if (indx == -1) {
            return;
        }
        String clickedFile = this.mainTable.getValueAt(indx, 0).toString();
        try {
            if (this.files.get(clickedFile).equals("dir")) {
                this.executeCommand("rmdir \"" + clickedFile + "\"\n");
            } else {
                this.executeCommand("rm \"" + clickedFile + "\"\n");
            }
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.getFiles();
    }

    protected void getFiles() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        try {
            this.executeCommand("ls\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        if (this.readTimer != null && this.readTimer.isRunning()) {
            return;
        }
        this.readTimer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Map received = (Map)MeterpFileBrowser.this.rpcConn.execute("session.meterpreter_read", MeterpFileBrowser.this.session.get("id"));
                    if (!received.get("encoding").equals("base64")) {
                        JOptionPane.showMessageDialog(null, "uhoh. encoding changed. Time to update msfgui?");
                        return;
                    }
                    byte[] decodedBytes = Base64.decode(received.get("data").toString());
                    if (decodedBytes.length == 0) {
                        return;
                    }
                    String[] lines = new String(decodedBytes).split("\n");
                    String headerRow = null;
                    String headerNames = null;
                    for (String line : lines) {
                        if ((line = line.trim()).startsWith("Listing")) {
                            MeterpFileBrowser.this.pwdLabel.setText(line);
                        } else if (line.startsWith("Mode")) {
                            headerNames = line;
                        } else if (line.startsWith("-")) {
                            headerRow = line;
                            MeterpFileBrowser.this.model.setColumnIdentifiers(TableHelper.fill(headerNames, line));
                            while (MeterpFileBrowser.this.model.getRowCount() > 0) {
                                MeterpFileBrowser.this.model.removeRow(0);
                            }
                        }
                        if (line.length() == 0 || line.charAt(0) < '0' || line.charAt(0) > '9') continue;
                        String filename = line.substring(this.getEndOfWhitespaceBlock(line, 6));
                        MeterpFileBrowser.this.fileVector.add(filename);
                        int indx = this.getEndOfWhitespaceBlock(line, 2);
                        MeterpFileBrowser.this.files.put(filename, line.substring(indx, indx + 3));
                        MeterpFileBrowser.this.model.addRow(TableHelper.fill(line, headerRow));
                    }
                    MeterpFileBrowser.this.readTimer.stop();
                    TableHelper.fitColumnWidths(MeterpFileBrowser.this.model, MeterpFileBrowser.this.mainTable);
                    int nameColumn = MeterpFileBrowser.this.mainTable.getColumnCount() - 1;
                    for (int i = 0; i < MeterpFileBrowser.this.mainTable.getColumnCount(); ++i) {
                        if (!MeterpFileBrowser.this.mainTable.getColumnName(i).equals("Name")) continue;
                        nameColumn = i;
                    }
                    MeterpFileBrowser.this.mainTable.moveColumn(nameColumn, 0);
                    MeterpFileBrowser.this.readTimer.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex.getMessage().equals("unknown session")) {
                        MeterpFileBrowser.this.readTimer.stop();
                    }
                    JOptionPane.showMessageDialog(null, ex);
                }
            }

            private int getEndOfWhitespaceBlock(String line, int num) {
                int whiteSpaces = 0;
                int indx = 0;
                while (whiteSpaces < num) {
                    if (Character.isWhitespace(line.charAt(indx)) && !Character.isWhitespace(line.charAt(indx + 1))) {
                        ++whiteSpaces;
                    }
                    ++indx;
                }
                return indx;
            }
        });
        this.readTimer.start();
    }

    private void initComponents() {
        this.downloadButton = new JButton();
        this.uploadButton = new JButton();
        this.deleteButton = new JButton();
        this.dirButton = new JButton();
        this.refreshButton = new JButton();
        this.pwdLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.mainTable = new JTable();
        this.upButton = new JButton();
        this.recSearchDownloadButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                MeterpFileBrowser.this.formWindowClosed(evt);
            }

            public void windowOpened(WindowEvent evt) {
                MeterpFileBrowser.this.formWindowOpened(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(MeterpFileBrowser.class);
        this.downloadButton.setText(resourceMap.getString("downloadButton.text", new Object[0]));
        this.downloadButton.setName("downloadButton");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.downloadButtonActionPerformed(evt);
            }
        });
        this.uploadButton.setText(resourceMap.getString("uploadButton.text", new Object[0]));
        this.uploadButton.setName("uploadButton");
        this.uploadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.uploadButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText(resourceMap.getString("deleteButton.text", new Object[0]));
        this.deleteButton.setName("deleteButton");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.deleteButtonActionPerformed(evt);
            }
        });
        this.dirButton.setText(resourceMap.getString("dirButton.text", new Object[0]));
        this.dirButton.setName("dirButton");
        this.dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.dirButtonActionPerformed(evt);
            }
        });
        this.refreshButton.setText(resourceMap.getString("refreshButton.text", new Object[0]));
        this.refreshButton.setName("refreshButton");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.refreshButtonActionPerformed(evt);
            }
        });
        this.pwdLabel.setText(resourceMap.getString("pwdLabel.text", new Object[0]));
        this.pwdLabel.setName("pwdLabel");
        this.jScrollPane1.setName("jScrollPane1");
        this.mainTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.mainTable.setName("mainTable");
        this.jScrollPane1.setViewportView(this.mainTable);
        this.upButton.setText(resourceMap.getString("upButton.text", new Object[0]));
        this.upButton.setName("upButton");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.upButtonActionPerformed(evt);
            }
        });
        this.recSearchDownloadButton.setText(resourceMap.getString("recSearchDownloadButton.text", new Object[0]));
        this.recSearchDownloadButton.setName("recSearchDownloadButton");
        this.recSearchDownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterpFileBrowser.this.recSearchDownloadButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 731, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.recSearchDownloadButton).addGap(18, 18, 18).addComponent(this.dirButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uploadButton).addGap(18, 18, 18).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadButton)).addGroup(layout.createSequentialGroup().addComponent(this.pwdLabel).addGap(18, 18, 18).addComponent(this.upButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pwdLabel).addComponent(this.upButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 532, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadButton).addComponent(this.deleteButton).addComponent(this.uploadButton).addComponent(this.dirButton).addComponent(this.refreshButton).addComponent(this.recSearchDownloadButton)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.lock.unlock();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.lock.lock();
        try {
            this.executeCommand("cd \"C:\\\\\"\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.getFiles();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        this.download();
    }

    private void uploadButtonActionPerformed(ActionEvent evt) {
        this.fchooser.setDialogTitle("Select file to upload");
        this.fchooser.setFileSelectionMode(0);
        if (this.fchooser.showOpenDialog(this) != 0) {
            return;
        }
        try {
            this.executeCommand("lcd \"" + MsfguiApp.cleanBackslashes(this.fchooser.getSelectedFile().getParent()) + "\"\n");
            this.executeCommand("upload \"" + this.fchooser.getSelectedFile().getName() + "\"\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.getFiles();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void dirButtonActionPerformed(ActionEvent evt) {
        String newDir = JOptionPane.showInputDialog(this, "New directory name", "Choose Directory Name", 3);
        if (newDir == null) {
            return;
        }
        try {
            this.executeCommand("mkdir \"" + newDir + "\"\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.getFiles();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.getFiles();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        try {
            this.executeCommand("cd ..\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
        this.getFiles();
    }

    private void recSearchDownloadButtonActionPerformed(ActionEvent evt) {
        try {
            String currentDir = this.pwdLabel.getText().substring(this.pwdLabel.getText().indexOf(32) + 1);
            this.rpcConn.execute("session.meterpreter_script", this.session.get("id"), new SearchDwldOptionsDialog((Frame)this, currentDir).toString());
            this.setVisible(false);
            this.dispose();
            this.interactWin.setVisible(true);
        }
        catch (NullPointerException nex) {
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
    }

    private void download() {
        int indx = this.mainTable.getSelectedRow();
        if (indx == -1) {
            return;
        }
        Object o = this.mainTable.getValueAt(indx, 0);
        String clickedFile = o.toString();
        this.fchooser.setDialogTitle("Select destination folder");
        this.fchooser.setFileSelectionMode(1);
        if (this.fchooser.showSaveDialog(this) != 0) {
            return;
        }
        try {
            this.executeCommand("lcd \"" + MsfguiApp.cleanBackslashes(this.fchooser.getSelectedFile().toString()) + "\"\n");
            this.executeCommand("download \"" + clickedFile + "\"\n");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
        }
    }
}

