/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Date
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] weekNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private transient long time;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n + 1900, n2, n3, n4, n5, n6);
        gregorianCalendar.set(15, 0);
        gregorianCalendar.set(16, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    public long getTime() {
        return this.time;
    }

    public int getTimezoneOffset() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return -(calendar.get(15) + calendar.get(16)) / 60000;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public boolean after(Date date) {
        boolean bl = false;
        if (this.time > date.time) {
            bl = true;
        }
        return bl;
    }

    public boolean before(Date date) {
        boolean bl = false;
        if (this.time < date.time) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Date && this.time == ((Date)object).time) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Date date) {
        int n;
        if (this.time < date.time) {
            n = -1;
        } else {
            int n2 = 0;
            if (this.time == date.time) {
                n2 = 1;
            }
            n = 1 - n2;
        }
        return n;
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public int hashCode() {
        return (int)this.time ^ (int)(this.time >>> 32);
    }

    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        String string = "0" + calendar.get(5);
        String string2 = "0" + calendar.get(11);
        String string3 = "0" + calendar.get(12);
        String string4 = "0" + calendar.get(13);
        String string5 = "000" + calendar.get(1);
        return weekNames[calendar.get(7) - 1] + ' ' + monthNames[calendar.get(2)] + ' ' + string.substring(string.length() - 2) + ' ' + string2.substring(string2.length() - 2) + ':' + string3.substring(string3.length() - 2) + ':' + string4.substring(string4.length() - 2) + ' ' + calendar.getTimeZone().getDisplayName(calendar.getTimeZone().inDaylightTime(this), 0) + ' ' + string5.substring(string5.length() - 4);
    }

    public String toLocaleString() {
        return DateFormat.getInstance().format(this);
    }

    public String toGMTString() {
        DateFormat dateFormat = DateFormat.getInstance();
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(this);
    }

    private static final int parseTz(String string, char c) throws IllegalArgumentException {
        int n;
        try {
            n = Integer.parseInt(string.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        n = n < 24 ? (n *= 60) : n / 100 * 60 + n % 100;
        return c == '-' ? -n : n;
    }

    private static final int parseMonth(String string) {
        String[] stringArray = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        int n = 0;
        while (n < 12) {
            if (stringArray[n].startsWith(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static final boolean parseDayOfWeek(String string) {
        String[] stringArray = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        int n = 0;
        while (n < 7) {
            if (stringArray[n].startsWith(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static long parse(String string) {
        Object object;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        int n8 = 0;
        int n9 = string.length();
        int n10 = 0;
        while (n10 < n9) {
            char c = string.charAt(n10);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (c == '(') {
                ++n8;
            } else if (n8 == 0) {
                stringBuffer.append(c);
            } else if (c == ')') {
                --n8;
            }
            ++n10;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            int n11;
            int n12;
            object = stringTokenizer.nextToken();
            char c = ((String)object).charAt(0);
            if ((c == '+' || c == '-') && n >= 0) {
                n7 = Date.parseTz((String)object, c);
                bl = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                while (object != null && ((String)object).length() > 0) {
                    int n13;
                    n12 = ((String)object).length();
                    n11 = 0;
                    int n14 = 0;
                    while (true) {
                        if (n14 >= n12) {
                            n13 = -1;
                            break;
                        }
                        n13 = ((String)object).charAt(n14);
                        if (n13 < 48 || n13 > 57) {
                            n12 = n14;
                            break;
                        }
                        if (n11 > 999999999) {
                            throw new IllegalArgumentException((String)object);
                        }
                        n11 = 10 * n11 + (n13 - 48);
                        ++n14;
                    }
                    if (n13 == 58) {
                        if (n4 < 0) {
                            n4 = n11;
                        } else {
                            n5 = n11;
                        }
                    } else if (n11 >= 70 && (n13 == 32 || n13 == 44 || n13 == 47 || n13 < 0) || n11 < 70 && n3 >= 0 && n2 >= 0 && n < 0) {
                        if (n11 >= 100) {
                            n = n11;
                        } else {
                            n14 = 1900 + new Date().getYear();
                            int n15 = n14 - 80;
                            n = n15 / 100 * 100 + n11;
                            if (n < n15) {
                                n += 100;
                            }
                        }
                    } else if (n13 == 47) {
                        if (n2 < 0) {
                            n2 = n11 - 1;
                        } else {
                            n3 = n11;
                        }
                    } else if (n4 >= 0 && n5 < 0) {
                        n5 = n11;
                    } else if (n5 >= 0 && n6 < 0) {
                        n6 = n11;
                    } else if (n3 < 0) {
                        n3 = n11;
                    } else {
                        throw new IllegalArgumentException((String)object);
                    }
                    object = n13 < 0 || n12 + 1 >= ((String)object).length() ? null : ((String)object).substring(n12 + 1);
                }
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                if (((String)object).equals("AM")) {
                    if (n4 < 1 || n4 > 12) {
                        throw new IllegalArgumentException((String)object);
                    }
                    if (n4 != 12) continue;
                    n4 = 0;
                    continue;
                }
                if (((String)object).equals("PM")) {
                    if (n4 < 1 || n4 > 12) {
                        throw new IllegalArgumentException((String)object);
                    }
                    if (n4 >= 12) continue;
                    n4 += 12;
                    continue;
                }
                if (Date.parseDayOfWeek((String)object)) continue;
                if (((String)object).equals("UT") || ((String)object).equals("UTC") || ((String)object).equals("GMT")) {
                    bl = false;
                    continue;
                }
                if (((String)object).startsWith("UT") || ((String)object).startsWith("GMT")) {
                    n12 = 3;
                    if (((String)object).charAt(1) == 'T' && ((String)object).charAt(2) != 'C') {
                        n12 = 2;
                    }
                    if ((n11 = (int)((String)object).charAt(n12)) != 43 && n11 != 45) {
                        throw new IllegalArgumentException((String)object);
                    }
                    n7 = Date.parseTz(((String)object).substring(n12), (char)n11);
                    bl = false;
                    continue;
                }
                n10 = Date.parseMonth((String)object);
                if (n10 >= 0) {
                    n2 = n10;
                    continue;
                }
                if (((String)object).length() == 3 && ((String)object).charAt(2) == 'T') {
                    n12 = ((String)object).charAt(0);
                    if (n12 == 69) {
                        n7 = -300;
                    } else if (n12 == 67) {
                        n7 = -360;
                    } else if (n12 == 77) {
                        n7 = -420;
                    } else if (n12 == 80) {
                        n7 = -480;
                    } else {
                        throw new IllegalArgumentException((String)object);
                    }
                    if (((String)object).charAt(1) == 'D') {
                        n7 += 60;
                    } else if (((String)object).charAt(1) != 'S') {
                        throw new IllegalArgumentException((String)object);
                    }
                    bl = false;
                    continue;
                }
                throw new IllegalArgumentException((String)object);
            }
            throw new IllegalArgumentException((String)object);
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Missing field");
        }
        object = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        if (!bl) {
            ((Calendar)object).set(15, n7 * 60 * 1000);
            ((Calendar)object).set(16, 0);
        }
        return ((Calendar)object).getTimeInMillis();
    }

    public int getYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(1) - 1900;
    }

    public void setYear(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(1, 1900 + n);
        this.time = calendar.getTimeInMillis();
    }

    public int getMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(2);
    }

    public void setMonth(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(2, n);
        this.time = calendar.getTimeInMillis();
    }

    public int getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(5);
    }

    public void setDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(5, n);
        this.time = calendar.getTimeInMillis();
    }

    public int getDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(7) - 1;
    }

    public int getHours() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(11);
    }

    public void setHours(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(11, n);
        this.time = calendar.getTimeInMillis();
    }

    public int getMinutes() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(12);
    }

    public void setMinutes(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(12, n);
        this.time = calendar.getTimeInMillis();
    }

    public int getSeconds() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        return calendar.get(13);
    }

    public void setSeconds(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        calendar.set(13, n);
        this.time = calendar.getTimeInMillis();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.time = objectInputStream.readLong();
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.time);
    }

    public Date() {
        this.time = System.currentTimeMillis();
    }

    public Date(long l) {
        this.time = l;
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n + 1900, n2, n3, n4, n5, n6);
        this.time = gregorianCalendar.getTimeInMillis();
    }

    public Date(String string) {
        this.time = Date.parse(string);
    }
}

