/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.constant.SysProperties;
import org.h2.message.Message;

public class IntArray {
    private int[] data;
    private int size;
    private int hash;

    public IntArray() {
        this.data = new int[10];
    }

    public IntArray(int[] nArray) {
        this.data = nArray;
        this.size = nArray.length;
    }

    public void add(int n) {
        this.checkCapacity();
        this.data[this.size++] = n;
    }

    public int get(int n) {
        if (SysProperties.CHECK && n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
        }
        return this.data[n];
    }

    public void remove(int n) {
        if (SysProperties.CHECK && n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
        }
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        --this.size;
    }

    private void checkCapacity() {
        if (this.size >= this.data.length) {
            int[] nArray = new int[this.data.length * 2];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }
    }

    public void add(int n, int n2) {
        if (SysProperties.CHECK && n > this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
        }
        this.checkCapacity();
        if (n == this.size) {
            this.add(n2);
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
            this.data[n] = n2;
            ++this.size;
        }
    }

    public void set(int n, int n2) {
        if (SysProperties.CHECK && n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
        }
        this.data[n] = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        if (this.hashCode() != intArray.hashCode() || this.size != intArray.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == intArray.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = this.size + 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.data[i];
        }
        this.hash = n;
        return n;
    }

    public int size() {
        return this.size;
    }

    public void addValueSorted(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.data[n4];
            if (n5 == n) {
                return;
            }
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        this.add(n2, n);
    }

    public void removeValue(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            this.remove(i);
            return;
        }
        Message.throwInternalError();
    }

    public void removeLastValue(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.data[i] != n) continue;
            this.remove(i);
            return;
        }
        Message.throwInternalError();
    }

    public int findIndexSorted(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.data[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return -1;
    }

    public int findNextIndexSorted(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.data[n4];
            if (n5 >= n) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    public void sort() {
        for (int i = 1; i < this.size(); ++i) {
            int n;
            int n2 = this.get(i);
            for (n = i - 1; n >= 0 && this.get(n) > n2; --n) {
                this.set(n + 1, this.get(n));
            }
            this.set(n + 1, n2);
        }
    }

    public void toArray(int[] nArray) {
        System.arraycopy(this.data, 0, nArray, 0, this.size);
    }

    public void removeAllSorted(IntArray intArray) {
        int[] nArray = new int[this.data.length];
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            int n2 = this.data[i];
            if (intArray.findIndexSorted(n2) != -1) continue;
            nArray[n++] = n2;
        }
        this.data = nArray;
        this.size = n;
    }
}

