/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.Parser;
import org.h2.engine.MetaRecord;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int block;
    private int blockCount;
    private int storageId;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean lobFilesInDirectories;
    private ObjectArray schema;
    private HashSet objectIdSet;
    private HashMap tableMap;
    private boolean remove;

    private void showUsage() {
        this.out.println("Helps recovering a corrupted database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-dir <dir>]      The directory (default: .)\n" + " [-db <database>]  The database name\n" + " [-trace]          Print additional trace information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new Recover().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                bl = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string3);
            this.showUsage();
            return;
        }
        if (bl) {
            this.removePassword(string, string2);
        } else {
            this.process(string, string2);
        }
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string)));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(new FileInputStream(string));
    }

    private void removePassword(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.endsWith(".data.db")) continue;
            this.removePassword(string3);
        }
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    private void removePassword(String string) throws SQLException {
        if (string.endsWith(".h2.db")) {
            this.remove = true;
            this.dumpPageStore(string);
            return;
        }
        this.setDatabaseName(string.substring(string.length() - ".data.db".length()));
        FileStore fileStore = FileStore.open(null, string, "rw");
        long l = fileStore.length();
        int n = 48;
        int n2 = 128;
        int n3 = (int)(l / (long)n2);
        this.blockCount = 1;
        for (int i = 0; i < n3; i += this.blockCount) {
            Value[] valueArray;
            fileStore.seek((long)n + (long)i * (long)n2);
            byte[] byArray = new byte[n2];
            DataPage dataPage = DataPage.create((DataHandler)this, byArray);
            long l2 = fileStore.getFilePointer();
            fileStore.readFully(byArray, 0, n2);
            this.blockCount = dataPage.readInt();
            this.storageId = -1;
            this.recordLength = -1;
            this.valueId = -1;
            if (this.blockCount == 0) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount < 0) {
                this.blockCount = 1;
                continue;
            }
            try {
                dataPage.checkCapacity(this.blockCount * n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.blockCount = 1;
                continue;
            }
            if (this.blockCount > 1) {
                fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
            }
            try {
                dataPage.check(this.blockCount * n2);
            }
            catch (SQLException sQLException) {
                this.blockCount = 1;
                continue;
            }
            this.storageId = dataPage.readInt();
            if (this.storageId != 0) continue;
            this.recordLength = dataPage.readInt();
            if (this.recordLength <= 0) continue;
            try {
                valueArray = new Value[this.recordLength];
            }
            catch (Throwable throwable) {
                continue;
            }
            this.valueId = 0;
            while (this.valueId < this.recordLength) {
                try {
                    valueArray[this.valueId] = dataPage.readValue();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.valueId;
            }
            if (this.storageId != 0) continue;
            try {
                int n4;
                String string2 = valueArray[3].getString();
                if (!string2.startsWith("CREATE USER ") || (n4 = string2.indexOf("SALT")) < 0) continue;
                String string3 = string2.substring("CREATE USER ".length(), n4 - 1);
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                SHA256 sHA256 = new SHA256();
                byte[] byArray2 = sHA256.getKeyPasswordHash(string3, "".toCharArray());
                byte[] byArray3 = RandomUtils.getSecureBytes(8);
                byte[] byArray4 = sHA256.getHashWithSalt(byArray2, byArray3);
                boolean bl = string2.indexOf("ADMIN") >= 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE USER ");
                stringBuffer.append(Parser.quoteIdentifier(string3));
                stringBuffer.append(" SALT '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray3));
                stringBuffer.append("' HASH '");
                stringBuffer.append(ByteUtils.convertBytesToString(byArray4));
                stringBuffer.append("'");
                if (bl) {
                    stringBuffer.append(" ADMIN");
                }
                byte[] byArray5 = stringBuffer.toString().getBytes();
                int n5 = ByteUtils.indexOf(dataPage.getBytes(), "CREATE USER ".getBytes(), 0);
                System.arraycopy(byArray5, 0, dataPage.getBytes(), n5, byArray5.length);
                dataPage.fill(this.blockCount * n2);
                dataPage.updateChecksum();
                fileStore.seek(l2);
                fileStore.write(dataPage.getBytes(), 0, dataPage.length());
                if (!this.trace) break;
                this.out.println("User: " + string3);
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.out);
            }
        }
        this.closeSilently(fileStore);
    }

    public static void execute(String string, String string2) throws SQLException {
        new Recover().process(string, string2);
    }

    private void process(String string, String string2) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (string3.endsWith(".data.db")) {
                this.dumpData(string3);
                continue;
            }
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (string3.endsWith(".index.db")) {
                this.dumpIndex(string3);
                continue;
            }
            if (string3.endsWith(".log.db")) {
                this.dumpLog(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) throws SQLException {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(FileUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray, int n) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " block:" + this.block + " blockCount:" + this.blockCount + " storageId:" + this.storageId + " recordLength: " + this.recordLength + " valueId:" + this.valueId);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('?');
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n * 128; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuffer.append(' ');
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = FileUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                if (this.trace) {
                    this.traceError(string, throwable);
                }
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                FileUtils.delete(string2);
            }
            catch (SQLException sQLException) {
                this.traceError(string2, sQLException);
            }
        }
    }

    private void writeLogRecord(PrintWriter printWriter, DataPage dataPage) {
        this.recordLength = dataPage.readInt();
        if (this.recordLength <= 0) {
            this.writeDataError(printWriter, "recordLength<0", dataPage.getBytes(), this.blockCount);
            return;
        }
        try {
            Value[] valueArray = new Value[this.recordLength];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//     data: ");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                Value value;
                valueArray[this.valueId] = value = dataPage.readValue();
                if (this.valueId > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getSQL(value));
            }
            catch (Exception exception) {
                if (this.trace) {
                    this.traceError("log data", exception);
                }
                this.writeDataError(printWriter, "exception " + exception, dataPage.getBytes(), this.blockCount);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), this.blockCount);
            }
            ++this.valueId;
        }
        printWriter.println(stringBuffer.toString());
        printWriter.flush();
    }

    private String getSQL(Value value) {
        ValueLob valueLob;
        byte[] byArray;
        if (value instanceof ValueLob && (byArray = (valueLob = (ValueLob)value).getSmall()) == null) {
            String string = valueLob.getFileName();
            if (valueLob.getType() == 15) {
                return "READ_BLOB('" + string + ".txt')";
            }
            return "READ_CLOB('" + string + ".txt')";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
        this.lobFilesInDirectories = FileUtils.exists(this.databaseName + ".lobs.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(String string) {
        block22: {
            int n;
            DataPage dataPage;
            byte[] byArray;
            int n2;
            int n3;
            int n4;
            long l;
            FileStore fileStore;
            PrintWriter printWriter;
            block21: {
                printWriter = null;
                fileStore = null;
                this.setDatabaseName(string.substring(string.length() - ".log.db".length()));
                printWriter = this.getWriter(string, ".txt");
                fileStore = FileStore.open(null, string, "r");
                l = fileStore.length();
                printWriter.println("// length: " + l);
                n4 = 48;
                n3 = 16;
                n2 = (int)(l / (long)n3);
                byArray = new byte[n3];
                dataPage = DataPage.create((DataHandler)this, byArray);
                dataPage.fill(3 * n3);
                n = dataPage.length();
                dataPage.reset();
                if (l >= (long)(48 + n)) break block21;
                printWriter.println("// empty file");
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                return;
            }
            try {
                int n5;
                fileStore.seek(n4);
                fileStore.readFully(dataPage.getBytes(), 0, n);
                int n6 = dataPage.readInt();
                int n7 = dataPage.readInt();
                int n8 = dataPage.readInt();
                printWriter.println("// id:" + n6);
                printWriter.println("// firstUncommittedPos:" + n7);
                printWriter.println("// firstUnwrittenPos:" + n8);
                int n9 = (int)(l / (long)n3);
                printWriter.println("// max:" + n9);
                block14: while ((long)(n5 = (int)(fileStore.getFilePointer() / (long)n3)) * (long)n3 < l) {
                    byArray = new byte[n3];
                    fileStore.readFully(byArray, 0, n3);
                    dataPage = DataPage.create((DataHandler)this, byArray);
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 > 1) {
                        byte[] byArray2 = ByteUtils.newBytes(n2 * n3);
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                        try {
                            fileStore.readFully(byArray, n3, n2 * n3 - n3);
                        }
                        catch (SQLException sQLException) {
                            break;
                        }
                        dataPage = DataPage.create((DataHandler)this, byArray);
                        dataPage.check(n2 * n3);
                    }
                    dataPage.reset();
                    n2 = MathUtils.convertLongToInt(Math.abs(dataPage.readInt()));
                    if (n2 == 0) {
                        printWriter.println("// [" + n5 + "] blocks: " + n2 + " (end)");
                        break;
                    }
                    char c = (char)dataPage.readByte();
                    int n10 = dataPage.readInt();
                    if (c == 'P') {
                        String string2 = dataPage.readString();
                        printWriter.println("//   prepared session:" + n10 + " tx:" + string2);
                        continue;
                    }
                    if (c == 'C') {
                        printWriter.println("//   commit session:" + n10);
                        continue;
                    }
                    int n11 = dataPage.readInt();
                    int n12 = dataPage.readInt();
                    int n13 = dataPage.readInt();
                    if (c != 'T') {
                        dataPage.readDataPageNoSize();
                    }
                    switch (c) {
                        case 'S': {
                            char c2 = (char)dataPage.readByte();
                            int n14 = dataPage.readInt();
                            byte[] byArray3 = ByteUtils.newBytes(n14);
                            if (n14 > 0) {
                                dataPage.read(byArray3, 0, n14);
                            }
                            printWriter.println("//   summary session:" + n10 + " fileType:" + c2 + " sumLength:" + n14);
                            this.dumpSummary(printWriter, byArray3);
                            continue block14;
                        }
                        case 'T': {
                            printWriter.println("//   truncate session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            continue block14;
                        }
                        case 'I': {
                            printWriter.println("//   insert session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                        case 'D': {
                            printWriter.println("//   delete session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                            if (n11 < 0) continue block14;
                            this.writeLogRecord(printWriter, dataPage);
                            continue block14;
                        }
                    }
                    printWriter.println("//   type?:" + c + " session:" + n10 + " storage:" + n11 + " pos:" + n12 + " blockCount:" + n13);
                }
                printWriter.close();
            }
            catch (Throwable throwable) {
                try {
                    this.writeError(printWriter, throwable);
                    break block22;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtils.closeSilently(printWriter);
                    this.closeSilently(fileStore);
                }
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
    }

    private void dumpSummary(PrintWriter printWriter, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            printWriter.println("//     summary is empty");
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < n4 / 8; ++n3) {
                n2 = dataInputStream.read();
                if (n3 % 8 == 0) {
                    printWriter.print("//  ");
                }
                printWriter.print(" " + Long.toString(n3 * 8) + ":");
                for (n = 0; n < 8; ++n) {
                    printWriter.print((n2 & 1) == 1 ? "1" : "0");
                    n2 >>>= 1;
                }
                if (n3 % 8 != 7) continue;
                printWriter.println("");
            }
            printWriter.println("//");
            n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readInt();
                if (n == -1) continue;
                printWriter.println("//     pos:" + n2 * 64 + " storage:" + n);
            }
            while ((n2 = dataInputStream.readInt()) >= 0) {
                n = dataInputStream.readInt();
                printWriter.println("//     storage:" + n2 + " recordCount:" + n);
            }
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndex(String string) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            this.setDatabaseName(string.substring(string.length() - ".index.db".length()));
            printWriter = this.getWriter(string, ".txt");
            fileStore = FileStore.open(null, string, "r");
            long l = fileStore.length();
            int n = 48;
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (this.block < n3) {
                block21: {
                    fileStore.seek((long)n + (long)this.block * (long)n2);
                    byte[] byArray = new byte[n2];
                    DataPage dataPage = DataPage.create((DataHandler)this, byArray);
                    fileStore.readFully(byArray, 0, n2);
                    this.blockCount = dataPage.readInt();
                    this.storageId = -1;
                    this.recordLength = -1;
                    this.valueId = -1;
                    if (this.blockCount == 0) {
                        this.blockCount = 1;
                    } else if (this.blockCount < 0) {
                        this.writeDataError(printWriter, "blockCount<0", dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else if ((long)this.blockCount * (long)n2 >= 0x1FFFFFFFL) {
                        this.writeDataError(printWriter, "blockCount=" + this.blockCount, dataPage.getBytes(), 1);
                        this.blockCount = 1;
                    } else {
                        try {
                            dataPage.checkCapacity(this.blockCount * n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        if (this.blockCount > 1) {
                            fileStore.readFully(dataPage.getBytes(), n2, this.blockCount * n2 - n2);
                        }
                        try {
                            dataPage.check(this.blockCount * n2);
                        }
                        catch (SQLException sQLException) {
                            this.writeDataError(printWriter, "wrong checksum", dataPage.getBytes(), 1);
                            this.blockCount = 1;
                            break block21;
                        }
                        this.storageId = dataPage.readInt();
                        if (this.storageId < 0) {
                            this.writeDataError(printWriter, "storageId<0", dataPage.getBytes(), this.blockCount);
                        } else {
                            int n4 = this.block / 64;
                            if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, dataPage.getBytes(), this.blockCount);
                            } else {
                                nArray[n4] = this.storageId;
                            }
                            printWriter.println("// [" + this.block + "] page:" + n4 + " blocks:" + this.blockCount + " storage:" + this.storageId);
                        }
                    }
                }
                this.block += this.blockCount;
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
            }
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        FileStore fileStore = null;
        PrintWriter printWriter = null;
        try {
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            fileStore = FileStore.open(null, string, "r");
            long l = fileStore.length();
            byte[] byArray = new byte[128];
            DataPage dataPage = DataPage.create((DataHandler)this, byArray);
            fileStore.readFully(byArray, 0, byArray.length);
            dataPage.setPos(48);
            int n = dataPage.readInt();
            int n2 = dataPage.readByte();
            int n3 = dataPage.readByte();
            int n4 = dataPage.readInt();
            int n5 = dataPage.readInt();
            int n6 = dataPage.readInt();
            printWriter.println("-- pageSize " + n);
            printWriter.println("-- writeVersion: " + n2);
            printWriter.println("-- readVersion: " + n3);
            printWriter.println("-- systemTableRoot: " + n4);
            printWriter.println("-- freeListHead: " + n5);
            printWriter.println("-- logHead: " + n6);
            int n7 = (int)(l / (long)n);
            this.blockCount = 1;
            byArray = new byte[n];
            dataPage = DataPage.create((DataHandler)this, byArray);
            block14: for (int i = 1; i < n7; ++i) {
                fileStore.seek((long)i * (long)n);
                fileStore.readFully(byArray, 0, n);
                dataPage.reset();
                int n8 = dataPage.readInt();
                int n9 = dataPage.readByte();
                switch (n9) {
                    case 0: {
                        printWriter.println("-- page " + i + ": empty");
                        if (n8 == 0) continue block14;
                        printWriter.println("-- ERROR parent:" + n8);
                        continue block14;
                    }
                    default: {
                        boolean bl = (n9 & 0x10) != 0;
                        switch (n9 &= 0xFFFFFFEF) {
                            case 3: {
                                printWriter.println("-- page " + i + ": data overflow " + (bl ? "(last)" : ""));
                                continue block14;
                            }
                            case 2: {
                                printWriter.println("-- page " + i + ": data node " + (bl ? "(last)" : ""));
                                continue block14;
                            }
                            case 1: {
                                printWriter.println("-- page " + i + ": data leaf " + (bl ? "(last)" : ""));
                                this.dumpPageDataLeaf(fileStore, n, printWriter, dataPage, bl);
                                continue block14;
                            }
                            case 4: {
                                printWriter.println("-- page " + i + ": free list " + (bl ? "(last)" : ""));
                                continue block14;
                            }
                            case 5: {
                                printWriter.println("-- page " + i + ": log " + (bl ? "(last)" : ""));
                                continue block14;
                            }
                        }
                        printWriter.println("-- page " + i + ": ERROR unknown type " + n9);
                    }
                }
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(fileStore);
    }

    private void dumpPageDataLeaf(FileStore fileStore, int n, PrintWriter printWriter, DataPage dataPage, boolean bl) throws SQLException {
        int n2;
        int n3;
        int n4 = dataPage.readShortInt();
        int n5 = dataPage.readInt();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int n6 = 0;
        if (!bl) {
            n6 = dataPage.readInt();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = dataPage.readInt();
            nArray2[n3] = dataPage.readShortInt();
        }
        if (!bl) {
            byte[] byArray = new byte[n];
            DataPage dataPage2 = DataPage.create((DataHandler)this, byArray);
            dataPage.setPos(n);
            while (true) {
                int n7;
                fileStore.seek(n * n6);
                fileStore.readFully(dataPage2.getBytes(), 0, n);
                dataPage2.setPos(4);
                n2 = dataPage2.readByte();
                if (n2 == 19) {
                    n7 = dataPage2.readShortInt();
                    dataPage.write(dataPage2.getBytes(), 7, n7);
                    break;
                }
                n6 = dataPage2.readInt();
                n7 = n - 9;
                dataPage.write(dataPage2.getBytes(), 9, n7);
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = nArray[n3];
            n2 = nArray2[n3];
            printWriter.println("-- [" + n3 + "] tableId: " + n5 + " key:" + n8 + " off: " + n2);
            dataPage.setPos(n2);
            dataPage.readInt();
            if (!this.remove || n5 != 0) continue;
            printWriter.println("-- system table");
        }
    }

    private void dumpData(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".data.db".length()));
        this.dumpData(string, string, 48);
    }

    private void resetSchema() {
        this.schema = new ObjectArray();
        this.objectIdSet = new HashSet();
        this.tableMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpData(String string, String string2, int n) {
        PrintWriter printWriter = null;
        FileStore fileStore = null;
        try {
            printWriter = this.getWriter(string2, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            this.resetSchema();
            fileStore = FileStore.open(null, string, "r");
            long l = fileStore.length();
            int n2 = 128;
            int n3 = (int)(l / (long)n2);
            this.blockCount = 1;
            int[] nArray = new int[n3 / 64];
            this.block = 0;
            while (true) {
                block27: {
                    Object object;
                    StringBuffer stringBuffer;
                    Value[] valueArray;
                    Object object2;
                    block36: {
                        block28: {
                            block35: {
                                block34: {
                                    block32: {
                                        block33: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        if (this.block >= n3) break block28;
                                                        fileStore.seek((long)n + (long)this.block * (long)n2);
                                                        byte[] byArray = new byte[n2];
                                                        object2 = DataPage.create((DataHandler)this, byArray);
                                                        fileStore.readFully(byArray, 0, n2);
                                                        this.blockCount = ((DataPage)object2).readInt();
                                                        this.storageId = -1;
                                                        this.recordLength = -1;
                                                        this.valueId = -1;
                                                        if (this.blockCount != 0) break block29;
                                                        this.blockCount = 1;
                                                        break block27;
                                                    }
                                                    if (this.blockCount >= 0) break block30;
                                                    this.writeDataError(printWriter, "blockCount<0", ((DataPage)object2).getBytes(), 1);
                                                    this.blockCount = 1;
                                                    break block27;
                                                }
                                                if ((long)this.blockCount * (long)n2 < 0x1FFFFFFFL && this.blockCount * n2 >= 0) break block31;
                                                this.writeDataError(printWriter, "blockCount=" + this.blockCount, ((DataPage)object2).getBytes(), 1);
                                                this.blockCount = 1;
                                                break block27;
                                            }
                                            printWriter.println("-- block " + this.block + " - " + (this.block + this.blockCount - 1));
                                            try {
                                                ((DataPage)object2).checkCapacity(this.blockCount * n2);
                                            }
                                            catch (OutOfMemoryError outOfMemoryError) {
                                                this.writeDataError(printWriter, "out of memory", ((DataPage)object2).getBytes(), 1);
                                                this.blockCount = 1;
                                                break block27;
                                            }
                                            if (this.blockCount <= 1) break block32;
                                            if (this.blockCount * n2 >= 0) break block33;
                                            this.writeDataError(printWriter, "wrong blockCount", ((DataPage)object2).getBytes(), 1);
                                            this.blockCount = 1;
                                            break block27;
                                        }
                                        try {
                                            fileStore.readFully(((DataPage)object2).getBytes(), n2, this.blockCount * n2 - n2);
                                        }
                                        catch (Throwable throwable) {
                                            this.writeDataError(printWriter, "eof", ((DataPage)object2).getBytes(), 1);
                                            this.blockCount = 1;
                                            fileStore = FileStore.open(null, string, "r");
                                            break block27;
                                        }
                                    }
                                    try {
                                        ((DataPage)object2).check(this.blockCount * n2);
                                    }
                                    catch (SQLException sQLException) {
                                        this.writeDataError(printWriter, "wrong checksum", ((DataPage)object2).getBytes(), 1);
                                        this.blockCount = 1;
                                        break block27;
                                    }
                                    this.storageId = ((DataPage)object2).readInt();
                                    if (this.storageId >= 0) break block34;
                                    this.writeDataError(printWriter, "storageId<0", ((DataPage)object2).getBytes(), this.blockCount);
                                    break block27;
                                }
                                int n4 = this.block / 64;
                                if (nArray[n4] != 0 && nArray[n4] != this.storageId) {
                                    this.writeDataError(printWriter, "double allocation, previous=" + nArray[n4] + " now=" + this.storageId, ((DataPage)object2).getBytes(), this.blockCount);
                                } else {
                                    nArray[n4] = this.storageId;
                                }
                                this.recordLength = ((DataPage)object2).readInt();
                                if (this.recordLength > 0) break block35;
                                this.writeDataError(printWriter, "recordLength<0", ((DataPage)object2).getBytes(), this.blockCount);
                                break block27;
                            }
                            try {
                                valueArray = new Value[this.recordLength];
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                this.writeDataError(printWriter, "out of memory", ((DataPage)object2).getBytes(), this.blockCount);
                                break block27;
                            }
                            this.createTemporaryTable(printWriter);
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("INSERT INTO O_" + this.storageId + " VALUES(");
                            this.valueId = 0;
                            break block36;
                        }
                        MetaRecord.sort(this.schema);
                        for (int i = 0; i < this.schema.size(); ++i) {
                            object2 = (MetaRecord)this.schema.get(i);
                            printWriter.println(((MetaRecord)object2).getSQL() + ";");
                        }
                        Iterator iterator = this.tableMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            Integer n5 = (Integer)object2.getKey();
                            valueArray = (Value[])object2.getValue();
                            if (!this.objectIdSet.contains(n5)) continue;
                            printWriter.println("INSERT INTO " + (String)valueArray + " SELECT * FROM O_" + n5 + ";");
                        }
                        iterator = this.objectIdSet.iterator();
                        while (iterator.hasNext()) {
                            object2 = (Integer)((Object)iterator.next());
                            printWriter.println("DROP TABLE O_" + object2 + ";");
                        }
                        printWriter.println("DROP ALIAS READ_CLOB;");
                        printWriter.println("DROP ALIAS READ_BLOB;");
                        printWriter.close();
                        IOUtils.closeSilently(printWriter);
                        this.closeSilently(fileStore);
                        return;
                    }
                    while (this.valueId < this.recordLength) {
                        try {
                            object = ((DataPage)object2).readValue();
                            valueArray[this.valueId] = object;
                            if (this.valueId > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(this.getSQL((Value)object));
                        }
                        catch (Exception exception) {
                            this.writeDataError(printWriter, "exception " + exception, ((DataPage)object2).getBytes(), this.blockCount);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.writeDataError(printWriter, "out of memory", ((DataPage)object2).getBytes(), this.blockCount);
                        }
                        ++this.valueId;
                    }
                    stringBuffer.append(");");
                    printWriter.println(stringBuffer.toString());
                    printWriter.flush();
                    if (this.storageId == 0) {
                        try {
                            object = new SimpleRow(valueArray);
                            MetaRecord metaRecord = new MetaRecord((SearchRow)object);
                            this.schema.add(metaRecord);
                            if (metaRecord.getObjectType() == 0) {
                                String string3 = valueArray[3].getString();
                                String string4 = this.extractTableOrViewName(string3);
                                this.tableMap.put(ObjectUtils.getInteger(metaRecord.getId()), string4);
                            }
                        }
                        catch (Throwable throwable) {
                            this.writeError(printWriter, throwable);
                        }
                    }
                }
                this.block += this.blockCount;
            }
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(fileStore);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(fileStore);
            return;
        }
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(ObjectUtils.getInteger(this.storageId))) {
            this.objectIdSet.add(ObjectUtils.getInteger(this.storageId));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE TABLE O_" + this.storageId + "(");
            for (int i = 0; i < this.recordLength; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("C");
                stringBuffer.append(i);
                stringBuffer.append(" VARCHAR");
            }
            stringBuffer.append(");");
            printWriter.println(stringBuffer.toString());
            printWriter.flush();
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    public String getDatabasePath() {
        return this.databaseName;
    }

    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        return FileStore.open(this, string, "rw");
    }

    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public void freeUpDiskSpace() {
    }

    public void handleInvalidChecksum() throws SQLException {
        throw new SQLException("Invalid Checksum");
    }

    public int compareTypeSave(Value value, Value value2) {
        throw Message.throwInternalError();
    }

    public int getMaxLengthInplaceLob() {
        throw Message.throwInternalError();
    }

    public int allocateObjectId(boolean bl, boolean bl2) {
        throw Message.throwInternalError();
    }

    public String createTempFile() {
        throw Message.throwInternalError();
    }

    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    public Trace getTrace() {
        return null;
    }
}

