/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;

public class UTFInputStreamReader
extends InputStreamReader {
    public static UTFInputStreamReader create(InputStream input, String defaultEncoding) throws IOException {
        int unread;
        byte[] bom = new byte[4];
        String encoding = defaultEncoding;
        PushbackInputStream pushbackStream = new PushbackInputStream(input, 4);
        int n = pushbackStream.read(bom, 0, 4);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            unread = n - 2;
        } else {
            unread = n;
        }
        if (unread > 0) {
            pushbackStream.unread(bom, n - unread, unread);
        } else if (unread < -1) {
            pushbackStream.unread(bom, 0, 0);
        }
        if (encoding == null) {
            return new UTFInputStreamReader(pushbackStream);
        }
        return new UTFInputStreamReader((InputStream)pushbackStream, encoding);
    }

    private UTFInputStreamReader(InputStream in) {
        super(in);
    }

    private UTFInputStreamReader(InputStream in, String cs) throws UnsupportedEncodingException {
        super(in, cs);
    }
}

