/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetSearchDialog
extends ExtendedDialog {
    private int CLASSIFICATION_NAME_MATCH = 300;
    private int CLASSIFICATION_GROUP_MATCH = 200;
    private int CLASSIFICATION_TAGS_MATCH = 100;
    private JTextField edSearchText;
    private JList lsResult;
    private JCheckBox ckOnlyApplicable;
    private JCheckBox ckSearchInTags;
    private final EnumSet<TaggingPreset.PresetType> typesInSelection = EnumSet.noneOf(TaggingPreset.PresetType.class);
    private final List<PresetClasification> classifications = new ArrayList<PresetClasification>();
    private ResultListModel lsResultModel = new ResultListModel();

    public TaggingPresetSearchDialog(Component parent) {
        super(parent, I18n.tr("Presets"), new String[]{I18n.tr("Select"), I18n.tr("Cancel")});
        this.getTypesInSelection();
        for (TaggingPreset preset : TaggingPresetPreference.taggingPresets) {
            if (preset instanceof TaggingPresetSeparator || preset instanceof TaggingPresetMenu) continue;
            this.classifications.add(new PresetClasification(preset));
        }
        this.build();
        this.filterPresets("");
    }

    private void build() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        this.edSearchText = new JTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        TaggingPresetSearchDialog.this.selectPreset(0);
                        break;
                    }
                    case 35: {
                        TaggingPresetSearchDialog.this.selectPreset(TaggingPresetSearchDialog.this.lsResultModel.getSize());
                    }
                }
            }
        });
        content.add((Component)this.edSearchText, "North");
        this.lsResult = new JList();
        this.lsResult.setModel(this.lsResultModel);
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.lsResult.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    TaggingPresetSearchDialog.this.buttonAction(0, null);
                }
            }
        });
        content.add((Component)new JScrollPane(this.lsResult), "Center");
        JPanel pnChecks = new JPanel();
        pnChecks.setLayout(new BoxLayout(pnChecks, 1));
        this.ckOnlyApplicable = new JCheckBox();
        this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection"));
        pnChecks.add(this.ckOnlyApplicable);
        if (this.typesInSelection.isEmpty()) {
            this.ckOnlyApplicable.setSelected(false);
            this.ckOnlyApplicable.setEnabled(false);
        } else {
            this.ckOnlyApplicable.setSelected(true);
            this.ckOnlyApplicable.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
                }
            });
        }
        this.ckSearchInTags = new JCheckBox();
        this.ckSearchInTags.setText(I18n.tr("Search in tags"));
        this.ckSearchInTags.setSelected(Main.pref.getBoolean("taggingpreset.dialog.search-in-tags", true));
        this.ckSearchInTags.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TaggingPresetSearchDialog.this.filterPresets(TaggingPresetSearchDialog.this.edSearchText.getText());
            }
        });
        pnChecks.add(this.ckSearchInTags);
        content.add((Component)pnChecks, "South");
        content.setPreferredSize(new Dimension(400, 300));
        this.setContent(content);
    }

    private void selectPreset(int newIndex) {
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex > this.lsResultModel.getSize() - 1) {
            newIndex = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(newIndex);
        this.lsResult.ensureIndexIsVisible(newIndex);
    }

    private void filterPresets(String text) {
        String[] nameWords;
        String[] groupWords;
        if ((text = text.toLowerCase()).contains("/")) {
            groupWords = text.substring(0, text.lastIndexOf(47)).split("[\\s/]");
            nameWords = text.substring(text.indexOf(47) + 1).split("\\s");
        } else {
            groupWords = null;
            nameWords = text.split("\\s");
        }
        boolean onlyApplicable = this.ckOnlyApplicable.isSelected();
        boolean inTags = this.ckSearchInTags.isSelected();
        ArrayList<PresetClasification> result = new ArrayList<PresetClasification>();
        for (PresetClasification presetClasification : this.classifications) {
            TaggingPreset preset = presetClasification.preset;
            presetClasification.classification = 0;
            if (onlyApplicable && preset.types != null) {
                boolean found = false;
                for (TaggingPreset.PresetType type : preset.types) {
                    if (!this.typesInSelection.contains((Object)type)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (groupWords != null && presetClasification.isMatchingGroup(groupWords) == 0) continue;
            int matchName = presetClasification.isMatchingName(nameWords);
            if (matchName == 0) {
                int tagsMatch;
                int groupMatch;
                if (groupWords == null && (groupMatch = presetClasification.isMatchingGroup(nameWords)) > 0) {
                    presetClasification.classification = this.CLASSIFICATION_GROUP_MATCH + groupMatch;
                }
                if (presetClasification.classification == 0 && inTags && (tagsMatch = presetClasification.isMatchingTags(nameWords)) > 0) {
                    presetClasification.classification = this.CLASSIFICATION_TAGS_MATCH + tagsMatch;
                }
            } else {
                presetClasification.classification = this.CLASSIFICATION_NAME_MATCH + matchName;
            }
            if (presetClasification.classification <= 0) continue;
            result.add(presetClasification);
        }
        Collections.sort(result);
        this.lsResultModel.setPresets(result);
        if (!this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(!result.isEmpty());
        }
    }

    private void getTypesInSelection() {
        for (OsmPrimitive primitive : Main.main.getCurrentDataSet().getSelected()) {
            if (primitive instanceof Node) {
                this.typesInSelection.add(TaggingPreset.PresetType.NODE);
                continue;
            }
            if (primitive instanceof Way) {
                this.typesInSelection.add(TaggingPreset.PresetType.WAY);
                if (!((Way)primitive).isClosed()) continue;
                this.typesInSelection.add(TaggingPreset.PresetType.CLOSEDWAY);
                continue;
            }
            if (!(primitive instanceof Relation)) continue;
            this.typesInSelection.add(TaggingPreset.PresetType.RELATION);
        }
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0) {
            int selectPreset = this.lsResult.getSelectedIndex();
            if (selectPreset == -1) {
                selectPreset = 0;
            }
            this.lsResultModel.getPresets().get((int)selectPreset).preset.actionPerformed(null);
        }
        Main.pref.put("taggingpreset.dialog.search-in-tags", this.ckSearchInTags.isSelected());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PresetClasification
    implements Comparable<PresetClasification> {
        public final TaggingPreset preset;
        public int classification;
        private final Collection<String> groups = new HashSet<String>();
        private final Collection<String> names = new HashSet<String>();
        private final Collection<String> tags = new HashSet<String>();

        PresetClasification(TaggingPreset preset) {
            this.preset = preset;
            TaggingPresetMenu group = preset.group;
            while (group != null) {
                for (String word : group.getLocaleName().toLowerCase().split("\\s")) {
                    this.groups.add(word);
                }
                group = group.group;
            }
            for (String word : preset.getLocaleName().toLowerCase().split("\\s")) {
                this.names.add(word);
            }
            for (TaggingPreset.Item item : preset.data) {
                if (item instanceof TaggingPreset.Check) {
                    this.tags.add(((TaggingPreset.Check)item).key.toLowerCase());
                    continue;
                }
                if (item instanceof TaggingPreset.Combo) {
                    this.tags.add(((TaggingPreset.Combo)item).key);
                    continue;
                }
                if (item instanceof TaggingPreset.Key) {
                    this.tags.add(((TaggingPreset.Key)item).key);
                    this.tags.add(((TaggingPreset.Key)item).value);
                    continue;
                }
                if (item instanceof TaggingPreset.Text) {
                    this.tags.add(((TaggingPreset.Text)item).key);
                    continue;
                }
                if (!(item instanceof TaggingPreset.Roles)) continue;
                for (TaggingPreset.Role role : ((TaggingPreset.Roles)item).roles) {
                    this.tags.add(role.key);
                }
            }
        }

        private int isMatching(Collection<String> values, String[] searchString) {
            int sum = 0;
            for (String word : searchString) {
                boolean found = false;
                boolean foundFirst = false;
                for (String value : values) {
                    int index = value.indexOf(word);
                    if (index == 0) {
                        foundFirst = true;
                        break;
                    }
                    if (index <= 0) continue;
                    found = true;
                }
                if (foundFirst) {
                    sum += 2;
                    continue;
                }
                if (found) {
                    ++sum;
                    continue;
                }
                return 0;
            }
            return sum;
        }

        int isMatchingGroup(String[] words) {
            return this.isMatching(this.groups, words);
        }

        int isMatchingName(String[] words) {
            return this.isMatching(this.names, words);
        }

        int isMatchingTags(String[] words) {
            return this.isMatching(this.tags, words);
        }

        @Override
        public int compareTo(PresetClasification o) {
            int result = o.classification - this.classification;
            if (result == 0) {
                return this.preset.getName().compareTo(o.preset.getName());
            }
            return result;
        }

        public String toString() {
            return this.classification + " " + this.preset.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultListModel
    extends AbstractListModel {
        private List<PresetClasification> presets = new ArrayList<PresetClasification>();

        private ResultListModel() {
        }

        public void setPresets(List<PresetClasification> presets) {
            this.presets = presets;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        public List<PresetClasification> getPresets() {
            return this.presets;
        }

        @Override
        public Object getElementAt(int index) {
            return this.presets.get((int)index).preset;
        }

        @Override
        public int getSize() {
            return this.presets.size();
        }
    }

    private static class ResultListCellRenderer
    extends DefaultListCellRenderer {
        private ResultListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TaggingPreset tp = (TaggingPreset)value;
            result.setText(tp.getName());
            result.setIcon((Icon)tp.getValue("SmallIcon"));
            return result;
        }
    }
}

