/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

class SaveLayerInfoCellRenderer
implements TableCellRenderer {
    private JLabel lblRenderer = new JLabel();
    private JCheckBox cbRenderer = new JCheckBox();

    protected Component prepareLayerNameRenderer(SaveLayerInfo info) {
        this.lblRenderer.setIcon(info.getLayer().getIcon());
        this.lblRenderer.setText(info.getName());
        this.lblRenderer.setToolTipText(info.getLayer().getToolTipText());
        return this.lblRenderer;
    }

    protected Component prepareUploadRequiredRenderer(SaveLayerInfo info) {
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setHorizontalAlignment(0);
        String text = info.getLayer().requiresUploadToServer() ? I18n.tr("Yes") : I18n.tr("No");
        this.lblRenderer.setText(text);
        if (info.getLayer().requiresUploadToServer()) {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has modifications which should be uploaded to the server.", info.getName()));
        } else {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has no modifications to be uploaded.", info.getName()));
        }
        return this.lblRenderer;
    }

    protected Component prepareSaveToFileRequired(SaveLayerInfo info) {
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setHorizontalAlignment(0);
        String text = info.getLayer().requiresSaveToFile() ? I18n.tr("Yes") : I18n.tr("No");
        this.lblRenderer.setText(text);
        if (info.getLayer().requiresSaveToFile()) {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has modifications which should be saved to its associated file ''{1}''.", info.getName(), info.getFile().toString()));
        } else {
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' has no modifications to be saved.", info.getName()));
        }
        return this.lblRenderer;
    }

    protected boolean canWrite(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return false;
        }
        if (f.exists() && f.canWrite()) {
            return true;
        }
        return !f.exists() && f.getParentFile() != null && f.getParentFile().canWrite();
    }

    protected Component prepareFileNameRenderer(SaveLayerInfo info) {
        this.lblRenderer.setIcon(null);
        if (info.getFile() == null) {
            if (!info.isDoSaveToFile()) {
                this.lblRenderer.setText(I18n.tr("No file associated with this layer"));
            } else {
                this.lblRenderer.setBackground(new Color(255, 197, 197));
                this.lblRenderer.setText(I18n.tr("Please select a file"));
            }
            this.lblRenderer.setFont(this.lblRenderer.getFont().deriveFont(2));
            this.lblRenderer.setToolTipText(I18n.tr("Layer ''{0}'' is not backed by a file", info.getName()));
        } else {
            String text = info.getFile().getName();
            String parent = info.getFile().getParent();
            if (parent != null) {
                text = parent.length() <= 10 ? info.getFile().getPath() : parent.substring(0, 10) + "..." + File.separator + text;
            }
            this.lblRenderer.setText(text);
            this.lblRenderer.setToolTipText(info.getFile().getAbsolutePath());
            if (info.isDoSaveToFile() && !this.canWrite(info.getFile())) {
                this.lblRenderer.setBackground(new Color(255, 197, 197));
                this.lblRenderer.setToolTipText(I18n.tr("File ''{0}'' is not writable. Please enter another file name.", info.getFile().getPath()));
            }
        }
        return this.lblRenderer;
    }

    protected Component prepareUploadRenderer(SaveLayerInfo info) {
        this.cbRenderer.setSelected(info.isDoUploadToServer());
        this.lblRenderer.setToolTipText(I18n.tr("Select to upload layer ''{0}'' to the server ''{1}''", info.getName(), OsmApi.getOsmApi().getBaseUrl()));
        return this.cbRenderer;
    }

    protected Component prepareSaveToFileRenderer(SaveLayerInfo info) {
        this.cbRenderer.setSelected(info.isDoSaveToFile());
        this.lblRenderer.setToolTipText(I18n.tr("Select to upload layer ''{0}'' to the server ''{1}''", info.getName(), OsmApi.getOsmApi().getBaseUrl()));
        return this.cbRenderer;
    }

    protected void resetRenderers() {
        this.lblRenderer.setOpaque(true);
        this.lblRenderer.setBackground(UIManager.getColor("Table.background"));
        this.lblRenderer.setIcon(null);
        this.lblRenderer.setText("");
        this.lblRenderer.setFont(UIManager.getFont("Table.font"));
        this.lblRenderer.setHorizontalAlignment(2);
        this.cbRenderer.setSelected(false);
        this.cbRenderer.setOpaque(true);
        this.cbRenderer.setBackground(UIManager.getColor("Table.background"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.resetRenderers();
        SaveLayerInfo info = (SaveLayerInfo)value;
        switch (column) {
            case 0: {
                return this.prepareLayerNameRenderer(info);
            }
            case 1: {
                return this.prepareUploadRequiredRenderer(info);
            }
            case 2: {
                return this.prepareSaveToFileRequired(info);
            }
            case 3: {
                return this.prepareFileNameRenderer(info);
            }
            case 4: {
                return this.prepareUploadRenderer(info);
            }
            case 5: {
                return this.prepareSaveToFileRenderer(info);
            }
        }
        return null;
    }
}

