/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAreasAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;

    public JoinAreasAction() {
        super(I18n.tr("Join overlapping Areas"), "joinareas", I18n.tr("Joins areas that overlap each other"), Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tool: {0}", I18n.tr("Join overlapping Areas")), 74, 3, 1), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Multipolygon> areas;
        LinkedList<Way> ways = new LinkedList<Way>(Main.main.getCurrentDataSet().getSelectedWays());
        if (ways.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one closed way that should be joined."));
            return;
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way way : ways) {
            if (!way.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("\"{0}\" is not closed and therefore cannot be joined.", way.getName()));
                return;
            }
            allNodes.addAll(way.getNodes());
        }
        Area dataSourceArea = Main.main.getCurrentDataSet().getDataSourceArea();
        if (dataSourceArea != null) {
            for (Node node : allNodes) {
                if (dataSourceArea.contains(node.getCoor())) continue;
                int option = JOptionPane.showConfirmDialog(Main.parent, I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", ways.size()) + "\n" + I18n.tr("This can lead to nodes being deleted accidentally.") + "\n" + I18n.tr("Are you really sure to continue?"), I18n.tr("Please abort if you are not sure"), 0, 2);
                if (option == 0) break;
                return;
            }
        }
        if ((areas = this.collectMultipolygons(ways)) == null) {
            return;
        }
        if (!this.testJoin(areas)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No intersection found. Nothing was changed."));
            return;
        }
        if (!this.resolveTagConflicts(areas)) {
            return;
        }
        try {
            JoinAreasResult result = this.joinAreas(areas);
            if (result.hasChanges) {
                Main.map.mapView.repaint();
                DataSet ds = Main.main.getCurrentDataSet();
                ds.fireSelectionChanged();
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No intersection found. Nothing was changed."));
            }
        }
        catch (UserCancelException exception) {
            this.makeCommitsOneAction(I18n.tr("Reverting changes"));
            Main.main.undoRedo.undo();
            Main.main.undoRedo.redoCommands.clear();
        }
    }

    private boolean testJoin(List<Multipolygon> areas) {
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            allStartingWays.add(area.outerWay);
            allStartingWays.addAll(area.innerWays);
        }
        ArrayList<Node> nodes = this.addIntersections(allStartingWays, true);
        return nodes.size() > 0;
    }

    private JoinAreasResult joinAreas(List<Multipolygon> areas) throws UserCancelException {
        ArrayList<Way> splitWays;
        ArrayList<Node> nodes;
        JoinAreasResult result = new JoinAreasResult();
        result.hasChanges = false;
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        ArrayList<Way> innerStartingWays = new ArrayList<Way>();
        ArrayList<Way> outerStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            outerStartingWays.add(area.outerWay);
            innerStartingWays.addAll(area.innerWays);
        }
        allStartingWays.addAll(innerStartingWays);
        allStartingWays.addAll(outerStartingWays);
        boolean removedDuplicates = false;
        if (removedDuplicates |= this.removeDuplicateNodes(allStartingWays)) {
            result.hasChanges = true;
            this.commitCommands(I18n.marktr("Removed duplicate nodes"));
        }
        if ((nodes = this.addIntersections(allStartingWays, false)).size() == 0) {
            return result;
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> relations = new ArrayList<RelationRole>();
        for (Way way : allStartingWays) {
            relations.addAll(this.removeFromAllRelations(way));
        }
        boolean warnAboutRelations = relations.size() > 0 && allStartingWays.size() > 1;
        ArrayList<WayInPolygon> preparedWays = new ArrayList<WayInPolygon>();
        for (Way way : outerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes);
            preparedWays.addAll(this.markWayInsideSide(splitWays, false));
        }
        for (Way way : innerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes);
            preparedWays.addAll(this.markWayInsideSide(splitWays, true));
        }
        ArrayList<Way> discardedWays = new ArrayList<Way>();
        List<AssembledPolygon> bounadries = JoinAreasAction.findBoundaryPolygons(preparedWays, discardedWays);
        List<AssembledMultipolygon> preparedPolygons = this.findPolygons(bounadries);
        ArrayList<Multipolygon> polygons = new ArrayList<Multipolygon>();
        for (AssembledMultipolygon assembledMultipolygon : preparedPolygons) {
            polygons.add(this.joinPolygon(assembledMultipolygon));
        }
        if (discardedWays.size() > 0) {
            this.cmds.add(DeleteCommand.delete(Main.map.mapView.getEditLayer(), discardedWays, true));
        }
        this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        for (Multipolygon multipolygon : polygons) {
            this.addOwnMultigonRelation(multipolygon.innerWays, multipolygon.outerWay, relations);
            this.fixRelations(relations, multipolygon.outerWay);
        }
        this.commitCommands(I18n.marktr("Fix relations"));
        for (Multipolygon multipolygon : polygons) {
            this.stripTags(multipolygon.innerWays);
        }
        this.makeCommitsOneAction(I18n.marktr("Joined overlapping areas"));
        if (warnAboutRelations) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some of the ways were part of relations that have been modified. Please verify no errors have been introduced."));
        }
        result.hasChanges = true;
        result.mergeSuccessful = true;
        result.polygons = polygons;
        return result;
    }

    private boolean resolveTagConflicts(List<Multipolygon> polygons) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (Multipolygon pol : polygons) {
            ways.add(pol.outerWay);
            ways.addAll(pol.innerWays);
        }
        if (ways.size() < 2) {
            return true;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        TagCollection completeWayTags = new TagCollection(wayTags);
        TagConflictResolutionUtil.combineTigerTags(completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(completeWayTags, ways);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues());
        dialog.setTargetPrimitive((OsmPrimitive)ways.get(0));
        Collection<Relation> parentRelations = CombineWayAction.getParentRelations(ways);
        parentRelations = this.filterOwnMultipolygonRelations(parentRelations, polygons);
        dialog.getRelationMemberConflictResolverModel().populate(parentRelations, ways);
        dialog.prepareDefaultDecisions();
        if (!completeWayTags.isApplicableToPrimitive() || !parentRelations.isEmpty()) {
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return false;
            }
        }
        for (Way way : ways) {
            dialog.setTargetPrimitive(way);
            this.cmds.addAll(dialog.buildResolutionCommands());
        }
        this.commitCommands(I18n.marktr("Fix tag conflicts"));
        return true;
    }

    private boolean removeDuplicateNodes(List<Way> ways) {
        TreeMap<Node, Node> nodeMap = new TreeMap<Node, Node>(new NodePositionComparator());
        int totalNodesRemoved = 0;
        for (Way way : ways) {
            if (way.getNodes().size() < 2) continue;
            int nodesRemoved = 0;
            ArrayList<Node> newNodes = new ArrayList<Node>();
            Node prevNode = null;
            for (Node node : way.getNodes()) {
                if (!nodeMap.containsKey(node)) {
                    nodeMap.put(node, node);
                    if (prevNode != node) {
                        newNodes.add(node);
                    } else {
                        ++nodesRemoved;
                    }
                } else {
                    Node representator = (Node)nodeMap.get(node);
                    if (representator != node) {
                        ++nodesRemoved;
                    }
                    if (prevNode != representator) {
                        newNodes.add(representator);
                    }
                }
                prevNode = node;
            }
            if (nodesRemoved <= 0) continue;
            if (newNodes.size() == 1) {
                newNodes.add((Node)newNodes.get(0));
            }
            Way newWay = new Way(way);
            newWay.setNodes(newNodes);
            this.cmds.add(new ChangeCommand(way, newWay));
            totalNodesRemoved += nodesRemoved;
        }
        return totalNodesRemoved > 0;
    }

    private ArrayList<Node> addIntersections(List<Way> ways, boolean test) {
        LinkedHashSet<Node> intersectionNodes;
        boolean[] changedWays;
        ArrayList[] newNodes;
        block22: {
            newNodes = new ArrayList[ways.size()];
            changedWays = new boolean[ways.size()];
            intersectionNodes = new LinkedHashSet<Node>();
            for (int pos = 0; pos < ways.size(); ++pos) {
                newNodes[pos] = new ArrayList<Node>(ways.get(pos).getNodes());
                changedWays[pos] = false;
            }
            NodePositionComparator coordsComparator = new NodePositionComparator();
            int seg1Way = 0;
            int seg1Pos = -1;
            block1: while (true) {
                if (++seg1Pos > newNodes[seg1Way].size() - 2) {
                    seg1Pos = 0;
                    if (++seg1Way == ways.size()) break block22;
                }
                int seg2Way = seg1Way;
                int seg2Pos = seg1Pos + 1;
                while (true) {
                    if (++seg2Pos > newNodes[seg2Way].size() - 2) {
                        seg2Pos = 0;
                        if (++seg2Way == ways.size()) continue block1;
                    }
                    Node seg1Node1 = (Node)newNodes[seg1Way].get(seg1Pos);
                    Node seg1Node2 = (Node)newNodes[seg1Way].get(seg1Pos + 1);
                    Node seg2Node1 = (Node)newNodes[seg2Way].get(seg2Pos);
                    Node seg2Node2 = (Node)newNodes[seg2Way].get(seg2Pos + 1);
                    int commonCount = 0;
                    if (seg1Node1 == seg2Node1 || seg1Node1 == seg2Node2) {
                        ++commonCount;
                        if (seg1Way != seg2Way || seg1Pos != 0 || seg2Pos != newNodes[seg2Way].size() - 2) {
                            intersectionNodes.add(seg1Node1);
                        }
                    }
                    if (seg1Node2 == seg2Node1 || seg1Node2 == seg2Node2) {
                        ++commonCount;
                        intersectionNodes.add(seg1Node2);
                    }
                    if (commonCount == 0) {
                        Node newNode;
                        LatLon intersection = JoinAreasAction.getLineLineIntersection(seg1Node1.getEastNorth().east(), seg1Node1.getEastNorth().north(), seg1Node2.getEastNorth().east(), seg1Node2.getEastNorth().north(), seg2Node1.getEastNorth().east(), seg2Node1.getEastNorth().north(), seg2Node2.getEastNorth().east(), seg2Node2.getEastNorth().north());
                        if (intersection == null) continue;
                        if (test) {
                            intersectionNodes.add(seg2Node1);
                            return new ArrayList<Node>(intersectionNodes);
                        }
                        Node intNode = newNode = new Node(intersection);
                        boolean insertInSeg1 = false;
                        boolean insertInSeg2 = false;
                        if (coordsComparator.compare(newNode, seg1Node1) == 0) {
                            intNode = seg1Node1;
                        } else if (coordsComparator.compare(newNode, seg1Node2) == 0) {
                            intNode = seg1Node2;
                        } else {
                            insertInSeg1 = true;
                        }
                        if (coordsComparator.compare(newNode, seg2Node1) == 0) {
                            intNode = seg2Node1;
                        } else if (coordsComparator.compare(newNode, seg2Node2) == 0) {
                            intNode = seg2Node2;
                        } else {
                            insertInSeg2 = true;
                        }
                        if (insertInSeg1) {
                            newNodes[seg1Way].add(seg1Pos + 1, intNode);
                            changedWays[seg1Way] = true;
                            if (seg2Way == seg1Way) {
                                ++seg2Pos;
                            }
                        }
                        if (insertInSeg2) {
                            newNodes[seg2Way].add(seg2Pos + 1, intNode);
                            changedWays[seg2Way] = true;
                            ++seg2Pos;
                        }
                        intersectionNodes.add(intNode);
                        if (intNode != newNode) continue;
                        this.cmds.add(new AddCommand(intNode));
                        continue;
                    }
                    if (test && intersectionNodes.size() > 0) break block1;
                }
                break;
            }
            return new ArrayList<Node>(intersectionNodes);
        }
        for (int pos = 0; pos < ways.size(); ++pos) {
            if (!changedWays[pos]) continue;
            Way way = ways.get(pos);
            Way newWay = new Way(way);
            newWay.setNodes(newNodes[pos]);
            this.cmds.add(new ChangeCommand(way, newWay));
        }
        return new ArrayList<Node>(intersectionNodes);
    }

    private static LatLon getLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a1 = y2 - y1;
        double b1 = x1 - x2;
        double c1 = x2 * y1 - x1 * y2;
        double a2 = y4 - y3;
        double b2 = x3 - x4;
        double c2 = x4 * y3 - x3 * y4;
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return Main.proj.eastNorth2latlon(new EastNorth((b1 * c2 - b2 * c1) / det, (a2 * c1 - a1 * c2) / det));
    }

    private void commitCommands(String description) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand c = new SequenceCommand(I18n.tr(description), this.cmds);
                Main.main.undoRedo.add(c);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    private ArrayList<WayInPolygon> markWayInsideSide(List<Way> parts, boolean isInner) {
        boolean wayClockwise;
        ArrayList<WayInPolygon> result = new ArrayList<WayInPolygon>();
        HashMap<Way, Way> nextWayMap = new HashMap<Way, Way>();
        HashMap<Way, Way> prevWayMap = new HashMap<Way, Way>();
        for (int pos = 0; pos < parts.size(); ++pos) {
            if (!parts.get(pos).lastNode().equals(parts.get((pos + 1) % parts.size()).firstNode())) {
                throw new RuntimeException("Way not circular");
            }
            nextWayMap.put(parts.get(pos), parts.get((pos + 1) % parts.size()));
            prevWayMap.put(parts.get(pos), parts.get((pos + parts.size() - 1) % parts.size()));
        }
        Way topWay = null;
        OsmPrimitive topNode = null;
        int topIndex = 0;
        double minY = Double.POSITIVE_INFINITY;
        for (Way way : parts) {
            for (int pos = 0; pos < way.getNodesCount(); ++pos) {
                Node node = way.getNode(pos);
                if (!(node.getEastNorth().getY() < minY)) continue;
                minY = node.getEastNorth().getY();
                topWay = way;
                topNode = node;
                topIndex = pos;
            }
        }
        if (topNode.equals(topWay.firstNode()) || topNode.equals(topWay.lastNode())) {
            OsmPrimitive headNode = null;
            Node prevNode = null;
            wayClockwise = false;
            headNode = topNode;
            prevNode = new Node(new EastNorth(((Node)headNode).getEastNorth().getX(), ((Node)headNode).getEastNorth().getY() - 100000.0));
            topWay = null;
            wayClockwise = false;
            Node bestWayNextNode = null;
            for (Way way : parts) {
                Node nextNode;
                if (way.firstNode().equals(headNode)) {
                    nextNode = way.getNode(1);
                    if (topWay == null || !JoinAreasAction.isToTheRightSideOfLine(prevNode, (Node)headNode, bestWayNextNode, nextNode)) {
                        topWay = way;
                        wayClockwise = true;
                        bestWayNextNode = nextNode;
                    }
                }
                if (!way.lastNode().equals(headNode)) continue;
                nextNode = way.getNode(way.getNodesCount() - 2);
                if (topWay != null && JoinAreasAction.isToTheRightSideOfLine(prevNode, (Node)headNode, bestWayNextNode, nextNode)) continue;
                topWay = way;
                wayClockwise = false;
                bestWayNextNode = nextNode;
            }
        } else {
            Node prev = topWay.getNode(topIndex - 1);
            Node next = topWay.getNode(topIndex + 1);
            wayClockwise = JoinAreasAction.angleIsClockwise(prev, (Node)topNode, next);
        }
        Way curWay = topWay;
        boolean curWayInsideToTheRight = wayClockwise ^ isInner;
        while (true) {
            WayInPolygon resultWay = new WayInPolygon(curWay, curWayInsideToTheRight);
            result.add(resultWay);
            Way nextWay = (Way)nextWayMap.get(curWay);
            Node prevNode = curWay.getNode(curWay.getNodesCount() - 2);
            Node headNode = curWay.lastNode();
            Node nextNode = nextWay.getNode(1);
            if (nextWay == topWay) break;
            int intersectionCount = 0;
            for (Way wayA : parts) {
                boolean wayBToTheRight;
                if (wayA == curWay || !wayA.lastNode().equals(headNode)) continue;
                Way wayB = (Way)nextWayMap.get(wayA);
                Node wayANode = wayA.getNode(wayA.getNodesCount() - 2);
                Node wayBNode = wayB.getNode(1);
                boolean wayAToTheRight = JoinAreasAction.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayANode);
                if (wayAToTheRight == (wayBToTheRight = JoinAreasAction.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayBNode))) continue;
                ++intersectionCount;
            }
            if (intersectionCount % 2 == 1) {
                curWayInsideToTheRight = !curWayInsideToTheRight;
            }
            curWay = nextWay;
        }
        return result;
    }

    private ArrayList<Way> splitWayOnNodes(Way way, Collection<Node> nodes) {
        ArrayList<Way> result = new ArrayList<Way>();
        List<List<Node>> chunks = this.buildNodeChunks(way, nodes);
        if (chunks.size() > 1) {
            SplitWayAction.SplitWayResult split = SplitWayAction.splitWay(Main.map.mapView.getEditLayer(), way, chunks, Collections.emptyList());
            this.cmds.add(split.getCommand());
            this.commitCommands(I18n.marktr("Split ways into fragments"));
            result.add(split.getOriginalWay());
            result.addAll(split.getNewWays());
        } else {
            result.add(way);
        }
        return result;
    }

    private List<List<Node>> buildNodeChunks(Way way, Collection<Node> splitNodes) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        ArrayList<Node> curList = new ArrayList<Node>();
        for (Node node : way.getNodes()) {
            curList.add(node);
            if (curList.size() <= 1 || !splitNodes.contains(node)) continue;
            result.add(curList);
            curList = new ArrayList();
            curList.add(node);
        }
        if (curList.size() > 1) {
            result.add(curList);
        }
        return result;
    }

    private List<AssembledMultipolygon> findPolygons(Collection<AssembledPolygon> boundaries) {
        List<PolygonLevel> list = this.findOuterWaysImpl(0, boundaries);
        ArrayList<AssembledMultipolygon> result = new ArrayList<AssembledMultipolygon>();
        for (PolygonLevel pol : list) {
            if (pol.level % 2 != 0) continue;
            result.add(pol.pol);
        }
        return result;
    }

    private List<PolygonLevel> findOuterWaysImpl(int level, Collection<AssembledPolygon> boundaryWays) {
        ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
        for (AssembledPolygon outerWay : boundaryWays) {
            boolean outerGood = true;
            ArrayList<AssembledPolygon> innerCandidates = new ArrayList<AssembledPolygon>();
            for (AssembledPolygon innerWay : boundaryWays) {
                if (innerWay == outerWay) continue;
                if (JoinAreasAction.wayInsideWay(outerWay, innerWay)) {
                    outerGood = false;
                    break;
                }
                if (!JoinAreasAction.wayInsideWay(innerWay, outerWay)) continue;
                innerCandidates.add(innerWay);
            }
            if (!outerGood) continue;
            AssembledMultipolygon pol = new AssembledMultipolygon(outerWay);
            PolygonLevel polLev = new PolygonLevel(pol, level);
            if (innerCandidates.size() > 0) {
                List<PolygonLevel> innerList = this.findOuterWaysImpl(level + 1, innerCandidates);
                result.addAll(innerList);
                for (PolygonLevel pl : innerList) {
                    if (pl.level != level + 1) continue;
                    pol.innerWays.add(pl.pol.outerWay);
                }
            }
            result.add(polLev);
        }
        return result;
    }

    public static List<AssembledPolygon> findBoundaryPolygons(Collection<WayInPolygon> multigonWays, List<Way> discardedResult) {
        ArrayList<WayInPolygon> boundary;
        ArrayList<WayInPolygon> discardedWays = new ArrayList<WayInPolygon>();
        HashSet<WayInPolygon> processedWays = new HashSet<WayInPolygon>();
        WayTraverser traverser = new WayTraverser(multigonWays);
        for (WayInPolygon startWay : multigonWays) {
            if (processedWays.contains(startWay)) continue;
            traverser.startNewWay(startWay);
            boundary = new ArrayList<WayInPolygon>();
            WayInPolygon lastWay = startWay;
            while (true) {
                boolean wayInsideToTheRight;
                boundary.add(lastWay);
                WayInPolygon bestWay = traverser.advanceNextLeftmostWay();
                boolean bl = wayInsideToTheRight = bestWay == null ? false : traverser.isLastWayInsideToTheRight();
                if (bestWay == null || processedWays.contains(bestWay) || !wayInsideToTheRight) {
                    lastWay = null;
                    break;
                }
                if (boundary.contains(bestWay)) {
                    lastWay = bestWay;
                    break;
                }
                lastWay = bestWay;
            }
            if (lastWay != null) {
                processedWays.addAll(boundary);
                while (boundary.get(0) != lastWay) {
                    discardedWays.add((WayInPolygon)boundary.get(0));
                    boundary.remove(0);
                }
                continue;
            }
            discardedWays.addAll(boundary);
            processedWays.addAll(boundary);
        }
        traverser.removeWays(discardedWays);
        List<AssembledPolygon> result = new ArrayList<AssembledPolygon>();
        while (traverser.hasWays()) {
            WayInPolygon startWay;
            startWay = traverser.startNewWay();
            boundary = new ArrayList();
            WayInPolygon curWay = startWay;
            do {
                boundary.add(curWay);
                curWay = traverser.advanceNextRightmostWay();
                if (curWay != null && traverser.isLastWayInsideToTheRight()) continue;
                throw new RuntimeException("Join areas internal error.");
            } while (curWay != startWay);
            traverser.removeWays(boundary);
            result.add(new AssembledPolygon(boundary));
        }
        for (WayInPolygon way : discardedWays) {
            discardedResult.add(way.way);
        }
        result = JoinAreasAction.fixTouchingPolygons(result);
        return result;
    }

    public static List<AssembledPolygon> fixTouchingPolygons(List<AssembledPolygon> polygons) {
        ArrayList<AssembledPolygon> newPolygons = new ArrayList<AssembledPolygon>();
        for (AssembledPolygon innerPart : polygons) {
            WayTraverser traverser = new WayTraverser(innerPart.ways);
            while (traverser.hasWays()) {
                WayInPolygon startWay = traverser.startNewWay();
                ArrayList<WayInPolygon> boundary = new ArrayList<WayInPolygon>();
                WayInPolygon curWay = startWay;
                Node startNode = traverser.getLastWayStartNode();
                boundary.add(curWay);
                while (startNode != traverser.getLastWayEndNode()) {
                    curWay = traverser.advanceNextLeftmostWay();
                    boundary.add(curWay);
                    if (curWay != null && traverser.isLastWayInsideToTheRight()) continue;
                    throw new RuntimeException("Join areas internal error.");
                }
                traverser.removeWays(boundary);
                newPolygons.add(new AssembledPolygon(boundary));
            }
        }
        return newPolygons;
    }

    public static boolean isToTheRightSideOfLine(Node lineP1, Node lineP2, Node lineP3, Node testPoint) {
        boolean pathBendToRight = JoinAreasAction.angleIsClockwise(lineP1, lineP2, lineP3);
        boolean rightOfSeg1 = JoinAreasAction.angleIsClockwise(lineP1, lineP2, testPoint);
        boolean rightOfSeg2 = JoinAreasAction.angleIsClockwise(lineP2, lineP3, testPoint);
        if (pathBendToRight) {
            return rightOfSeg1 && rightOfSeg2;
        }
        return rightOfSeg1 || rightOfSeg2;
    }

    public static boolean angleIsClockwise(Node commonNode, Node firstNode, Node secondNode) {
        double dy1 = firstNode.getEastNorth().getY() - commonNode.getEastNorth().getY();
        double dy2 = secondNode.getEastNorth().getY() - commonNode.getEastNorth().getY();
        double dx1 = firstNode.getEastNorth().getX() - commonNode.getEastNorth().getX();
        double dx2 = secondNode.getEastNorth().getX() - commonNode.getEastNorth().getX();
        return dy1 * dx2 - dx1 * dy2 > 0.0;
    }

    public static boolean wayInsideWay(AssembledPolygon inside, AssembledPolygon outside) {
        HashSet<Node> outsideNodes = new HashSet<Node>(outside.getNodes());
        for (Node insideNode : inside.getNodes()) {
            if (outsideNodes.contains(insideNode)) continue;
            return JoinAreasAction.nodeInsidePolygon(insideNode, outside.getNodes());
        }
        return false;
    }

    public static boolean nodeInsidePolygon(Node point, List<Node> polygonNodes) {
        if (polygonNodes.size() < 3) {
            return false;
        }
        boolean inside = false;
        Node oldPoint = polygonNodes.get(polygonNodes.size() - 1);
        for (Node newPoint : polygonNodes) {
            Node p2;
            Node p1;
            if (newPoint.equals(oldPoint)) continue;
            if (newPoint.getEastNorth().getY() > oldPoint.getEastNorth().getY()) {
                p1 = oldPoint;
                p2 = newPoint;
            } else {
                p1 = newPoint;
                p2 = oldPoint;
            }
            if (newPoint.getEastNorth().getY() < point.getEastNorth().getY() == point.getEastNorth().getY() <= oldPoint.getEastNorth().getY() && (point.getEastNorth().getX() - p1.getEastNorth().getX()) * (p2.getEastNorth().getY() - p1.getEastNorth().getY()) < (p2.getEastNorth().getX() - p1.getEastNorth().getX()) * (point.getEastNorth().getY() - p1.getEastNorth().getY())) {
                inside = !inside;
            }
            oldPoint = newPoint;
        }
        return inside;
    }

    private Multipolygon joinPolygon(AssembledMultipolygon polygon) throws UserCancelException {
        Multipolygon result = new Multipolygon(this.joinWays(polygon.outerWay.ways));
        for (AssembledPolygon pol : polygon.innerWays) {
            result.innerWays.add(this.joinWays(pol.ways));
        }
        return result;
    }

    private Way joinWays(List<WayInPolygon> ways) throws UserCancelException {
        Way joinedWay;
        boolean allReverse = true;
        for (WayInPolygon way : ways) {
            allReverse &= !way.insideToTheRight;
        }
        if (allReverse) {
            for (WayInPolygon way : ways) {
                way.insideToTheRight = !way.insideToTheRight;
            }
        }
        if ((joinedWay = this.joinOrientedWays(ways)) == null || !joinedWay.isClosed()) {
            throw new RuntimeException("Join areas internal error.");
        }
        return joinedWay;
    }

    private Way joinOrientedWays(List<WayInPolygon> ways) throws UserCancelException {
        if (ways.size() < 2) {
            return ways.get((int)0).way;
        }
        ArrayList<Way> actionWays = new ArrayList<Way>(ways.size());
        for (WayInPolygon way : ways) {
            actionWays.add(way.way);
            if (way.insideToTheRight) continue;
            ReverseWayAction.ReverseWayResult res = ReverseWayAction.reverseWay(way.way);
            Main.main.undoRedo.add(res.getReverseCommand());
            ++this.cmdsCount;
        }
        Pair<Way, Command> result = CombineWayAction.combineWaysWorker(actionWays);
        Main.main.undoRedo.add((Command)result.b);
        ++this.cmdsCount;
        return (Way)result.a;
    }

    private List<Multipolygon> collectMultipolygons(List<Way> selectedWays) {
        ArrayList<Multipolygon> result = new ArrayList<Multipolygon>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        ArrayList<Way> innerWays = new ArrayList<Way>();
        LinkedHashSet<Way> processedOuterWays = new LinkedHashSet<Way>();
        LinkedHashSet<Way> processedInnerWays = new LinkedHashSet<Way>();
        for (Relation r : CombineWayAction.getParentRelations(selectedWays)) {
            if (r.isDeleted() || r.get("type") == null || !r.get("type").equalsIgnoreCase("multipolygon")) continue;
            boolean hasKnownOuter = false;
            outerWays.clear();
            innerWays.clear();
            for (RelationMember rm : r.getMembers()) {
                if (rm.getRole().equalsIgnoreCase("outer")) {
                    outerWays.add(rm.getWay());
                    hasKnownOuter |= selectedWays.contains(rm.getWay());
                    continue;
                }
                if (!rm.getRole().equalsIgnoreCase("inner")) continue;
                innerWays.add(rm.getWay());
            }
            if (!hasKnownOuter) continue;
            if (outerWays.size() > 1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Sorry. Cannot handle multipolygon relations with multiple outer ways."));
                return null;
            }
            Way outerWay = (Way)outerWays.get(0);
            innerWays.retainAll(selectedWays);
            if (processedOuterWays.contains(outerWay)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Sorry. Cannot handle way that is outer in multiple multipolygon relations."));
                return null;
            }
            if (processedInnerWays.contains(outerWay)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations."));
                return null;
            }
            for (Way way : innerWays) {
                if (processedOuterWays.contains(way)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations."));
                    return null;
                }
                if (!processedInnerWays.contains(way)) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Sorry. Cannot handle way that is inner in multiple multipolygon relations."));
                return null;
            }
            processedOuterWays.add(outerWay);
            processedInnerWays.addAll(innerWays);
            Multipolygon pol = new Multipolygon(outerWay);
            pol.innerWays.addAll(innerWays);
            pol.relation = r;
            result.add(pol);
        }
        for (Way way : selectedWays) {
            if (processedOuterWays.contains(way) || processedInnerWays.contains(way)) continue;
            result.add(new Multipolygon(way));
        }
        return result;
    }

    private List<Relation> filterOwnMultipolygonRelations(Collection<Relation> relations, List<Multipolygon> polygons) {
        ArrayList<Relation> relationsToRemove = new ArrayList<Relation>();
        for (Multipolygon m : polygons) {
            if (m.relation == null) continue;
            relationsToRemove.add(m.relation);
        }
        ArrayList<Relation> result = new ArrayList<Relation>();
        result.addAll(relations);
        result.removeAll(relationsToRemove);
        return result;
    }

    private void addOwnMultigonRelation(Collection<Way> inner, Way outer, ArrayList<RelationRole> rels) {
        if (inner.size() == 0) {
            return;
        }
        Relation newRel = new Relation();
        newRel.put("type", "multipolygon");
        for (Way w : inner) {
            newRel.addMember(new RelationMember("inner", w));
        }
        this.cmds.add(new AddCommand(newRel));
        rels.add(new RelationRole(newRel, "outer"));
    }

    private ArrayList<RelationRole> removeFromAllRelations(OsmPrimitive osm) {
        ArrayList<RelationRole> result = new ArrayList<RelationRole>();
        block0: for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (r.isDeleted()) continue;
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember() != osm) continue;
                Relation newRel = new Relation(r);
                List<RelationMember> members = newRel.getMembers();
                members.remove(rm);
                newRel.setMembers(members);
                this.cmds.add(new ChangeCommand(r, newRel));
                RelationRole saverel = new RelationRole(r, rm.getRole());
                if (result.contains(saverel)) continue block0;
                result.add(saverel);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return result;
    }

    private void fixRelations(ArrayList<RelationRole> rels, Way outer) {
        ArrayList<RelationRole> multiouters = new ArrayList<RelationRole>();
        for (RelationRole r : rels) {
            if (r.rel.get("type") != null && r.rel.get("type").equalsIgnoreCase("multipolygon") && r.role.equalsIgnoreCase("outer")) {
                multiouters.add(r);
                continue;
            }
            Relation newRel = new Relation(r.rel);
            newRel.addMember(new RelationMember(r.role, outer));
            this.cmds.add(new ChangeCommand(r.rel, newRel));
        }
        Relation newRel = null;
        switch (multiouters.size()) {
            case 0: {
                return;
            }
            case 1: {
                newRel = new Relation(((RelationRole)multiouters.get((int)0)).rel);
                newRel.addMember(new RelationMember(((RelationRole)multiouters.get((int)0)).role, outer));
                this.cmds.add(new ChangeCommand(((RelationRole)multiouters.get((int)0)).rel, newRel));
                return;
            }
        }
        newRel = new Relation();
        for (RelationRole r : multiouters) {
            for (RelationMember rm : r.rel.getMembers()) {
                if (newRel.getMembers().contains(rm)) continue;
                newRel.addMember(rm);
            }
            for (String key : r.rel.keySet()) {
                newRel.put(key, r.rel.get(key));
            }
            this.cmds.add(new DeleteCommand(r.rel));
        }
        newRel.addMember(new RelationMember("outer", outer));
        this.cmds.add(new AddCommand(newRel));
    }

    private void stripTags(Collection<Way> ways) {
        for (Way w : ways) {
            this.stripTags(w);
        }
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    private void stripTags(Way x) {
        if (x.getKeys() == null) {
            return;
        }
        Way y = new Way(x);
        for (String key : x.keySet()) {
            y.remove(key);
        }
        this.cmds.add(new ChangeCommand(x, y));
    }

    private void makeCommitsOneAction(String message) {
        int i;
        UndoRedoHandler ur = Main.main.undoRedo;
        this.cmds.clear();
        for (i = Math.max(ur.commands.size() - this.cmdsCount, 0); i < ur.commands.size(); ++i) {
            this.cmds.add(ur.commands.get(i));
        }
        for (i = 0; i < this.cmds.size(); ++i) {
            ur.undo();
        }
        this.commitCommands(message == null ? I18n.marktr("Join Areas Function") : message);
        this.cmdsCount = 0;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    static class PolygonLevel {
        public final int level;
        public final AssembledMultipolygon pol;

        public PolygonLevel(AssembledMultipolygon _pol, int _level) {
            this.pol = _pol;
            this.level = _level;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodePositionComparator
    implements Comparator<Node> {
        private NodePositionComparator() {
        }

        @Override
        public int compare(Node n1, Node n2) {
            double dLat = n1.getCoor().lat() - n2.getCoor().lat();
            double dLon = n1.getCoor().lon() - n2.getCoor().lon();
            if (dLat > 0.0) {
                return 1;
            }
            if (dLat < 0.0) {
                return -1;
            }
            if (dLon == 0.0) {
                return 0;
            }
            return dLon > 0.0 ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WayTraverser {
        private Set<WayInPolygon> availableWays;
        private WayInPolygon lastWay;
        private boolean lastWayReverse;

        public WayTraverser(Collection<WayInPolygon> ways) {
            this.availableWays = new HashSet<WayInPolygon>(ways);
            this.lastWay = null;
        }

        public void removeWays(Collection<WayInPolygon> ways) {
            this.availableWays.removeAll(ways);
        }

        public boolean hasWays() {
            return this.availableWays.size() > 0;
        }

        public WayInPolygon startNewWay(WayInPolygon way) {
            this.lastWay = way;
            this.lastWayReverse = !this.lastWay.insideToTheRight;
            return this.lastWay;
        }

        public WayInPolygon startNewWay() {
            if (this.availableWays.size() == 0) {
                this.lastWay = null;
            } else {
                this.lastWay = this.availableWays.iterator().next();
                this.lastWayReverse = !this.lastWay.insideToTheRight;
            }
            return this.lastWay;
        }

        public WayInPolygon advanceNextLeftmostWay() {
            return this.advanceNextWay(false);
        }

        public WayInPolygon advanceNextRightmostWay() {
            return this.advanceNextWay(true);
        }

        private WayInPolygon advanceNextWay(boolean rightmost) {
            Node headNode = !this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
            Node prevNode = !this.lastWayReverse ? this.lastWay.way.getNode(this.lastWay.way.getNodesCount() - 2) : this.lastWay.way.getNode(1);
            WayInPolygon bestWay = null;
            Node bestWayNextNode = null;
            boolean bestWayReverse = false;
            for (WayInPolygon way : this.availableWays) {
                Node nextNode;
                if (way.way.firstNode().equals(headNode) && !(nextNode = way.way.getNode(1)).equals(prevNode) && (bestWay == null || JoinAreasAction.isToTheRightSideOfLine(prevNode, headNode, bestWayNextNode, nextNode) == rightmost)) {
                    bestWay = way;
                    bestWayReverse = false;
                    bestWayNextNode = nextNode;
                }
                if (!way.way.lastNode().equals(headNode) || (nextNode = way.way.getNode(way.way.getNodesCount() - 2)).equals(prevNode) || bestWay != null && JoinAreasAction.isToTheRightSideOfLine(prevNode, headNode, bestWayNextNode, nextNode) != rightmost) continue;
                bestWay = way;
                bestWayReverse = true;
                bestWayNextNode = nextNode;
            }
            this.lastWay = bestWay;
            this.lastWayReverse = bestWayReverse;
            return this.lastWay;
        }

        public boolean isLastWayInsideToTheRight() {
            return this.lastWayReverse != this.lastWay.insideToTheRight;
        }

        public Node getLastWayStartNode() {
            return this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
        }

        public Node getLastWayEndNode() {
            return this.lastWayReverse ? this.lastWay.way.firstNode() : this.lastWay.way.lastNode();
        }
    }

    public static class AssembledMultipolygon {
        public AssembledPolygon outerWay;
        public List<AssembledPolygon> innerWays;

        public AssembledMultipolygon(AssembledPolygon way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<AssembledPolygon>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssembledPolygon {
        public List<WayInPolygon> ways;

        public AssembledPolygon(List<WayInPolygon> boundary) {
            this.ways = boundary;
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (WayInPolygon way : this.ways) {
                int pos;
                if (way.insideToTheRight) {
                    for (pos = 0; pos < way.way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.way.getNode(pos));
                }
            }
            return nodes;
        }
    }

    private static class WayInPolygon {
        public final Way way;
        public boolean insideToTheRight;

        public WayInPolygon(Way _way, boolean _insideRight) {
            this.way = _way;
            this.insideToTheRight = _insideRight;
        }

        public int hashCode() {
            return this.way.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof WayInPolygon)) {
                return false;
            }
            WayInPolygon otherMember = (WayInPolygon)other;
            return otherMember.way.equals(this.way) && otherMember.insideToTheRight == this.insideToTheRight;
        }
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        public RelationRole(Relation rel, String role) {
            this.rel = rel;
            this.role = role;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelationRole)) {
                return false;
            }
            RelationRole otherMember = (RelationRole)other;
            return otherMember.role.equals(this.role) && otherMember.rel.equals(this.rel);
        }
    }

    public static class Multipolygon {
        public Way outerWay;
        public List<Way> innerWays;
        public Relation relation;

        public Multipolygon(Way way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<Way>();
        }
    }

    public static class JoinAreasResult {
        public boolean mergeSuccessful;
        public boolean hasChanges;
        public boolean hasRelationProblems;
        public List<Multipolygon> polygons;
    }
}

