/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.util.StringLiteralReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LanguageReference
extends StringLiteralReference {
    public LanguageReference(PsiLiteralExpression value) {
        super(value);
    }

    @Nullable
    public PsiElement resolve() {
        return InjectedLanguage.findLanguageById(this.getValue()) != null ? this.myValue : null;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] ids = InjectedLanguage.getAvailableLanguageIDs();
        Object[] objectArray = ContainerUtil.map2Array((Object[])ids, LookupElement.class, (Function)new Function<String, LookupElement>(){

            public LookupElement fun(String s) {
                Language l = InjectedLanguage.findLanguageById(s);
                assert (l != null);
                FileType ft = l.getAssociatedFileType();
                if (ft != null) {
                    return LookupElementBuilder.create((String)s).setIcon(ft.getIcon()).setTypeText(ft.getDescription());
                }
                return LookupElementBuilder.create((String)s).setIcon((Icon)new EmptyIcon(16));
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/java/LanguageReference.getVariants must not return null");
        }
        return objectArray;
    }
}

