/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.ShiftTabAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AdvancedSettingsUI
implements Configurable {
    private final Configuration myConfiguration;
    private JPanel myRoot;
    private JRadioButton myNoInstrumentation;
    private JRadioButton myAssertInstrumentation;
    private JRadioButton myExceptionInstrumentation;
    private JPanel myLanguageAnnotationPanel;
    private JPanel myPatternAnnotationPanel;
    private JPanel mySubstAnnotationPanel;
    private JCheckBox myAnalyzeReferencesCheckBox;
    private JCheckBox myUseDataflowAnalysisIfCheckBox;
    private JCheckBox myIncludeUncomputableOperandsAsCheckBox;
    private final ReferenceEditorWithBrowseButton myAnnotationField;
    private final ReferenceEditorWithBrowseButton myPatternField;
    private final ReferenceEditorWithBrowseButton mySubstField;

    public AdvancedSettingsUI(final @NotNull Project project, Configuration configuration) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/AdvancedSettingsUI.<init> must not be null");
        }
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.myAnnotationField = new ReferenceEditorWithBrowseButton(null, project, (Function)new Function<String, Document>(){

            public Document fun(String s) {
                return PsiUtilEx.createDocument(s, project);
            }
        }, this.myConfiguration.getLanguageAnnotationClass());
        this.myAnnotationField.addActionListener((ActionListener)new BrowseClassListener(project, this.myAnnotationField));
        this.myAnnotationField.setEnabled(!project.isDefault());
        ShiftTabAction.attachTo(this.myAnnotationField.getEditorTextField());
        AdvancedSettingsUI.addField(this.myLanguageAnnotationPanel, this.myAnnotationField);
        this.myPatternField = new ReferenceEditorWithBrowseButton(null, project, (Function)new Function<String, Document>(){

            public Document fun(String s) {
                return PsiUtilEx.createDocument(s, project);
            }
        }, this.myConfiguration.getPatternAnnotationClass());
        this.myPatternField.addActionListener((ActionListener)new BrowseClassListener(project, this.myPatternField));
        this.myPatternField.setEnabled(!project.isDefault());
        ShiftTabAction.attachTo(this.myPatternField.getEditorTextField());
        AdvancedSettingsUI.addField(this.myPatternAnnotationPanel, this.myPatternField);
        this.mySubstField = new ReferenceEditorWithBrowseButton(null, project, (Function)new Function<String, Document>(){

            public Document fun(String s) {
                return PsiUtilEx.createDocument(s, project);
            }
        }, this.myConfiguration.getPatternAnnotationClass());
        this.mySubstField.addActionListener((ActionListener)new BrowseClassListener(project, this.mySubstField));
        this.mySubstField.setEnabled(!project.isDefault());
        ShiftTabAction.attachTo(this.mySubstField.getEditorTextField());
        AdvancedSettingsUI.addField(this.mySubstAnnotationPanel, this.mySubstField);
    }

    private static void addField(JPanel panel, ReferenceEditorWithBrowseButton field) {
        Component component;
        panel.add((Component)field, "Center");
        Component[] components = panel.getParent().getComponents();
        int index = Arrays.asList(components).indexOf(panel);
        if (index > 0 && (component = components[index - 1]) instanceof JLabel) {
            ((JLabel)component).setLabelFor((Component)field);
        }
    }

    public JComponent createComponent() {
        return this.myRoot;
    }

    public boolean isModified() {
        if (this.getInstrumentation() != this.myConfiguration.getInstrumentation()) {
            return true;
        }
        if (!this.myAnnotationField.getText().equals(this.myConfiguration.getLanguageAnnotationClass())) {
            return true;
        }
        if (!this.myPatternField.getText().equals(this.myConfiguration.getPatternAnnotationClass())) {
            return true;
        }
        if (!this.mySubstField.getText().equals(this.myConfiguration.getSubstAnnotationClass())) {
            return true;
        }
        if (this.myConfiguration.isResolveReferences() != this.myAnalyzeReferencesCheckBox.isSelected()) {
            return true;
        }
        if (this.myConfiguration.isUseDfaIfAvailable() != this.myUseDataflowAnalysisIfCheckBox.isSelected()) {
            return true;
        }
        return this.myConfiguration.isIncludeUncomputablesAsLiterals() != this.myIncludeUncomputableOperandsAsCheckBox.isSelected();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Configuration.InstrumentationType getInstrumentation() {
        Configuration.InstrumentationType instrumentationType;
        if (this.myNoInstrumentation.isSelected()) {
            Configuration.InstrumentationType instrumentationType2 = Configuration.InstrumentationType.NONE;
            instrumentationType = instrumentationType2;
            if (instrumentationType2 != null) return instrumentationType;
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/AdvancedSettingsUI.getInstrumentation must not return null");
        }
        if (this.myAssertInstrumentation.isSelected()) {
            Configuration.InstrumentationType instrumentationType3 = Configuration.InstrumentationType.ASSERT;
            instrumentationType = instrumentationType3;
            if (instrumentationType3 == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/AdvancedSettingsUI.getInstrumentation must not return null");
            return instrumentationType;
        }
        if (this.myExceptionInstrumentation.isSelected()) {
            Configuration.InstrumentationType instrumentationType4 = Configuration.InstrumentationType.EXCEPTION;
            instrumentationType = instrumentationType4;
            if (instrumentationType4 == null) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/AdvancedSettingsUI.getInstrumentation must not return null");
            return instrumentationType;
        }
        assert (false);
        instrumentationType = null;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/AdvancedSettingsUI.getInstrumentation must not return null");
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setInstrumentationType(this.getInstrumentation());
        this.myConfiguration.setLanguageAnnotation(this.myAnnotationField.getText());
        this.myConfiguration.setPatternAnnotation(this.myPatternField.getText());
        this.myConfiguration.setSubstAnnotation(this.mySubstField.getText());
        this.myConfiguration.setResolveReferences(this.myAnalyzeReferencesCheckBox.isSelected());
        this.myConfiguration.setUseDfaIfAvailable(this.myUseDataflowAnalysisIfCheckBox.isSelected());
        this.myConfiguration.setIncludeUncomputablesAsLiterals(this.myIncludeUncomputableOperandsAsCheckBox.isSelected());
    }

    public void reset() {
        this.myAnnotationField.setText(this.myConfiguration.getLanguageAnnotationClass());
        this.myPatternField.setText(this.myConfiguration.getPatternAnnotationClass());
        this.mySubstField.setText(this.myConfiguration.getSubstAnnotationClass());
        this.myNoInstrumentation.setSelected(this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.NONE);
        this.myAssertInstrumentation.setSelected(this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.ASSERT);
        this.myExceptionInstrumentation.setSelected(this.myConfiguration.getInstrumentation() == Configuration.InstrumentationType.EXCEPTION);
        this.myAnalyzeReferencesCheckBox.setSelected(this.myConfiguration.isResolveReferences());
        this.myUseDataflowAnalysisIfCheckBox.setSelected(this.myConfiguration.isUseDfaIfAvailable());
        this.myIncludeUncomputableOperandsAsCheckBox.setSelected(this.myConfiguration.isIncludeUncomputablesAsLiterals());
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Advanced";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.injection.advanced";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRoot = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Annotation Classes", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Language annotation class");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguageAnnotationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Pattern annotation class");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPatternAnnotationPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Substitution annotation class");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySubstAnnotationPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Runtime Pattern Validation", 0, 0, null, null));
        this.myNoInstrumentation = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("No runtime instrumentation");
        jRadioButton3.setMnemonic('N');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAssertInstrumentation = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Instrument with assertions");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExceptionInstrumentation = jRadioButton = new JRadioButton();
        jRadioButton.setText("Instrument with IllegalArgumentException");
        jRadioButton.setMnemonic('W');
        jRadioButton.setDisplayedMnemonicIndex(11);
        jPanel7.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(null, "General Hints", 0, 0, null, null));
        this.myAnalyzeReferencesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Analyze references");
        jCheckBox3.setMnemonic('A');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIncludeUncomputableOperandsAsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Include uncomputable operands as literals");
        jPanel8.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseDataflowAnalysisIfCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use dataflow analysis (slow) ");
        jCheckBox.setMnemonic('U');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setSelected(false);
        jPanel8.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class BrowseClassListener
    implements ActionListener {
        private final Project myProject;
        private final ReferenceEditorWithBrowseButton myField;

        private BrowseClassListener(Project project, ReferenceEditorWithBrowseButton annotationField) {
            this.myProject = project;
            this.myField = annotationField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myField.getText(), scope);
            TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser("Select Annotation Class", scope, new TreeClassChooser.ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.isAnnotationType();
                }
            }, aClass);
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelectedClass();
            if (psiClass != null) {
                this.myField.setText(psiClass.getQualifiedName());
            }
        }
    }
}

