/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesGroupIdConverter;

public class MavenGroupIdSmartCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(final CompletionParameters parameters, final CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.SMART) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                GenericDomValueReference reference = MavenGroupIdSmartCompletionContributor.this.getReference(parameters);
                if (reference == null) {
                    return;
                }
                Collection<String> variants = ((MavenArtifactCoordinatesGroupIdConverter)reference.getConverter()).getSmartVariants((ConvertContext)reference.getConvertContext());
                for (String variant : variants) {
                    if (StringUtil.isEmptyOrSpaces((String)variant)) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)variant));
                }
            }
        });
    }

    @Nullable
    private GenericDomValueReference getReference(CompletionParameters parameters) {
        PsiReference[] references;
        if (!(parameters.getPosition() instanceof XmlToken)) {
            return null;
        }
        for (PsiReference psiReference : references = MavenGroupIdSmartCompletionContributor.getReferences(parameters)) {
            Converter converter;
            if (!(psiReference instanceof GenericDomValueReference) || !((converter = ((GenericDomValueReference)psiReference).getConverter()) instanceof MavenArtifactCoordinatesGroupIdConverter)) continue;
            return (GenericDomValueReference)psiReference;
        }
        return null;
    }

    private static PsiReference[] getReferences(CompletionParameters parameters) {
        PsiElement psiElement = parameters.getPosition().getParent();
        return psiElement instanceof XmlText ? psiElement.getParent().getReferences() : psiElement.getReferences();
    }
}

