/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.io.File;
import java.util.List;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class RecordOnlyMergerFactory
extends ChangeListsMergerFactory {
    private final boolean myUndo;

    public RecordOnlyMergerFactory(List<CommittedChangeList> changeListsList, boolean isUndo) {
        super(changeListsList);
        this.myUndo = isUndo;
    }

    @Override
    public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
        return new Merger(vcs, this.myChangeListsList, target, handler, currentBranchUrl, branchName){

            @Override
            protected SVNRevisionRange createRange() {
                if (RecordOnlyMergerFactory.this.myUndo) {
                    return new SVNRevisionRange(SVNRevision.create((long)this.myLatestProcessed.getNumber()), SVNRevision.create((long)(this.myLatestProcessed.getNumber() - 1L)));
                }
                return super.createRange();
            }

            @Override
            protected boolean isRecordOnly() {
                return true;
            }
        };
    }
}

