/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.Alarm;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public abstract class BaseButtonBehavior {
    private JComponent myComponent;
    private boolean myHovered;
    private boolean myPressedByMouse;
    private boolean mySelected;
    private TimedDeadzone myMouseDeadzone;

    public BaseButtonBehavior(JComponent component) {
        this(component, TimedDeadzone.DEFAULT);
    }

    public BaseButtonBehavior(JComponent component, TimedDeadzone.Length mouseDeadzoneTime) {
        this.myComponent = component;
        this.myMouseDeadzone = new TimedDeadzone(mouseDeadzoneTime, Alarm.ThreadToUse.SWING_THREAD);
        this.myComponent.addMouseListener(new MyMouseListener());
        this.myComponent.addMouseMotionListener(new MyMouseMotionListener());
    }

    public final boolean isHovered() {
        return this.myHovered;
    }

    private void setHovered(boolean hovered) {
        this.myHovered = hovered;
        this.myComponent.repaint();
    }

    public final boolean isPressedByMouse() {
        return this.myPressedByMouse;
    }

    private void setPressedByMouse(boolean pressedByMouse) {
        this.myPressedByMouse = pressedByMouse;
        this.myComponent.repaint();
    }

    public final boolean isSelected() {
        return this.mySelected;
    }

    private void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    private boolean isPressed() {
        return this.isSelected() || this.isPressedByMouse();
    }

    public void setMouseDeadzone(TimedDeadzone.Length deadZone) {
        this.myMouseDeadzone.setLength(deadZone);
    }

    protected void repaintComponent() {
        this.myComponent.repaint();
    }

    protected abstract void execute(MouseEvent var1);

    protected void pass(MouseEvent e) {
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.enter();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.reEnter();
            BaseButtonBehavior.this.setHovered(true);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BaseButtonBehavior.this.myMouseDeadzone.clear();
            BaseButtonBehavior.this.setHovered(false);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.passIfNeeded(e)) {
                return;
            }
            BaseButtonBehavior.this.setPressedByMouse(true);
            BaseButtonBehavior.this.repaintComponent();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.passIfNeeded(e)) {
                return;
            }
            BaseButtonBehavior.this.setPressedByMouse(false);
            Point point = e.getPoint();
            if (point.x < 0 || point.x > BaseButtonBehavior.this.myComponent.getWidth()) {
                return;
            }
            if (point.y < 0 || point.y > BaseButtonBehavior.this.myComponent.getHeight()) {
                return;
            }
            BaseButtonBehavior.this.repaintComponent();
            BaseButtonBehavior.this.execute(e);
        }

        private boolean passIfNeeded(MouseEvent e) {
            boolean actionClick;
            boolean bl = actionClick = UIUtil.isActionClick((MouseEvent)e, (int)502) || UIUtil.isActionClick((MouseEvent)e, (int)501);
            if (!actionClick || BaseButtonBehavior.this.myMouseDeadzone.isWithin()) {
                BaseButtonBehavior.this.pass(e);
                return true;
            }
            return false;
        }
    }
}

