/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class ShapeTransform {
    protected GeneralPath myPath = new GeneralPath();
    private Rectangle myShapeRect;
    protected int myXTranform;
    protected int myYTranform;
    private boolean mySwap;

    public ShapeTransform(Rectangle shapeRect, int xTransform, int yTranform, boolean swap) {
        this.myShapeRect = shapeRect;
        this.myXTranform = xTransform;
        this.myYTranform = yTranform;
        this.mySwap = swap;
    }

    public ShapeTransform(int XTranform, int YTranform) {
        this.myXTranform = XTranform;
        this.myYTranform = YTranform;
    }

    public final Rectangle getShapeRect() {
        return this.myShapeRect;
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getMaxX();

    public abstract int getMaxY();

    public final int deltaX(int deltaX) {
        return deltaX * this.myXTranform;
    }

    public final int deltaY(int deltaY) {
        return deltaY * this.myYTranform;
    }

    public final <T> T transformX1(T o1, T o2) {
        return (this.mySwap ? this.myYTranform : this.myXTranform) == 1 ? o1 : o2;
    }

    public final <T> T transformX2(T o1, T o2) {
        return (this.mySwap ? this.myYTranform : this.myXTranform) == 1 ? o2 : o1;
    }

    public final <T> T transformY1(T o1, T o2) {
        return (this.mySwap ? this.myXTranform : this.myYTranform) == 1 ? o1 : o2;
    }

    public final <T> T transformY2(T o1, T o2) {
        return (this.mySwap ? this.myXTranform : this.myYTranform) == 1 ? o2 : o1;
    }

    public abstract Insets transformInsets(Insets var1);

    public abstract Line2D.Float transformLine(int var1, int var2, int var3, int var4);

    public abstract ShapeTransform createTransform(Rectangle var1);

    public abstract ShapeTransform copy();

    public final int getWidth() {
        return Math.abs(this.getMaxX() - this.getX());
    }

    public final int getHeight() {
        return Math.abs(this.getMaxY() - this.getY());
    }

    public final ShapeTransform moveTo(int x, int y) {
        if (this.mySwap) {
            this.myPath.moveTo(y, x);
        } else {
            this.myPath.moveTo(x, y);
        }
        return this;
    }

    public final ShapeTransform quadTo(int x1, int y1, int x2, int y2) {
        if (this.mySwap) {
            this.myPath.quadTo(y1, x1, y2, x2);
        } else {
            this.myPath.quadTo(x1, y1, x2, y2);
        }
        return this;
    }

    public final ShapeTransform lineTo(int x, int y) {
        if (this.mySwap) {
            this.myPath.lineTo(y, x);
        } else {
            this.myPath.lineTo(x, y);
        }
        return this;
    }

    public final GeneralPath getShape() {
        return this.myPath;
    }

    public final ShapeTransform reset() {
        return this.reset(null);
    }

    public final ShapeTransform reset(Rectangle shapeRec) {
        this.myPath = new GeneralPath();
        if (shapeRec != null) {
            this.myShapeRect = shapeRec;
        }
        return this;
    }

    public final ShapeTransform closePath() {
        this.myPath.closePath();
        return this;
    }

    public final ShapeTransform doRect(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return this;
        }
        return this.moveTo(x, y).lineTo(x + this.deltaX(width), y).lineTo(x + this.deltaX(width), y + this.deltaY(height)).lineTo(x, y + this.deltaY(height)).closePath();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new FlowLayout(1));
        frame.getContentPane().add((Component)content, "Center");
        content.add(new Painter("TOP", new Top()));
        content.add(new Painter("LEFT", new Left()));
        content.add(new Painter("BOTTOM", new Bottom()));
        content.add(new Painter("RIGHT", new Right()));
        frame.setBounds(300, 300, 300, 300);
        frame.show();
    }

    private static class Painter
    extends JLabel {
        private final ShapeTransform myT;

        private Painter(String text, ShapeTransform transform) {
            this.setText(text);
            this.setFont(this.getFont().deriveFont(30.0f));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.myT = transform;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.red);
            Graphics2D g2d = (Graphics2D)g;
            int arc1 = 4;
            int arc2 = 6;
            Rectangle r = new Rectangle(arc1, arc1, this.getWidth() - arc1 - 1, this.getHeight() - arc1 - 1);
            this.myT.reset(r);
            this.myT.moveTo(this.myT.getX() - this.myT.deltaX(arc1), this.myT.getMaxY());
            this.myT.quadTo(this.myT.getX(), this.myT.getMaxY(), this.myT.getX(), this.myT.getMaxY() - this.myT.deltaY(arc1));
            this.myT.lineTo(this.myT.getX(), this.myT.getY() + this.myT.deltaY(arc2));
            this.myT.quadTo(this.myT.getX(), this.myT.getY(), this.myT.getX() + this.myT.deltaX(arc2), this.myT.getY());
            this.myT.lineTo(this.myT.getMaxX() - this.myT.deltaX(arc2), this.myT.getY());
            this.myT.quadTo(this.myT.getMaxX(), this.myT.getY(), this.myT.getMaxX(), this.myT.getY() + this.myT.deltaY(arc2));
            this.myT.lineTo(this.myT.getMaxX(), this.myT.getMaxY());
            g2d.draw(this.myT.getShape());
            int innerRecSize = 18;
            Rectangle innerRec = new Rectangle(this.getWidth() / 2 - 9, this.getHeight() / 2 - 9, 18, 18);
            ShapeTransform inner = this.myT.createTransform(innerRec);
            inner.moveTo(inner.getX(), inner.getMaxY());
            inner.lineTo(inner.getX(), inner.getY());
            inner.lineTo(inner.getMaxX(), inner.getY());
            inner.lineTo(inner.getMaxX(), inner.getMaxY());
            g2d.draw(inner.getShape());
        }
    }

    public static class Right
    extends ShapeTransform {
        public Right(Rectangle shapeRect, GeneralPath path) {
            super(shapeRect, 1, -1, true);
            this.myPath = path;
        }

        public Right(Rectangle rec) {
            this(rec, new GeneralPath());
        }

        public Right() {
            this(null);
        }

        @Override
        public int getX() {
            return this.getShapeRect().y;
        }

        @Override
        public int getY() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxY() {
            return this.getShapeRect().x;
        }

        @Override
        public ShapeTransform copy() {
            return new Right((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.right, insets.top, insets.left, insets.bottom);
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Right(innerRec);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(y1, x1, y2, x2);
        }
    }

    public static class Bottom
    extends ShapeTransform {
        public Bottom(Rectangle shapeRect, GeneralPath path) {
            super(shapeRect, 1, -1, false);
            this.myPath = path;
        }

        public Bottom(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Bottom() {
            this(null);
        }

        @Override
        public int getX() {
            return this.getShapeRect().x;
        }

        @Override
        public int getY() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxY() {
            return this.getShapeRect().y;
        }

        @Override
        public ShapeTransform copy() {
            return new Bottom((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Bottom(innerRec);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.bottom, insets.right, insets.top, insets.left);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(x2, Math.abs(y2), x1, Math.abs(y1));
        }
    }

    public static class Left
    extends ShapeTransform {
        public Left() {
            this(null);
        }

        public Left(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Left(Rectangle shapeRect, GeneralPath path) {
            super(shapeRect, 1, 1, true);
            this.myPath = path;
        }

        @Override
        public int getX() {
            return this.getShapeRect().y;
        }

        @Override
        public int getY() {
            return this.getShapeRect().x;
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxY() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Left(innerRec);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(y1, x1, y2, x2);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.left, insets.top, insets.right, insets.bottom);
        }

        @Override
        public ShapeTransform copy() {
            return new Left((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }
    }

    public static class Top
    extends ShapeTransform {
        public Top() {
            this(null);
        }

        public Top(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Top(Rectangle shapeRect, GeneralPath path) {
            super(shapeRect, 1, 1, false);
            this.myPath = path;
        }

        @Override
        public int getX() {
            return this.getShapeRect().x;
        }

        @Override
        public int getY() {
            return this.getShapeRect().y;
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxY() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Top(innerRec);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(x1, y1, x2, y2);
        }

        @Override
        public ShapeTransform copy() {
            return new Top((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }
    }
}

