/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.redundantCast.RedundantCastUtil");

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(PsiElement where) {
        MyCollectingVisitor visitor = new MyCollectingVisitor();
        where.acceptChildren(visitor);
        ArrayList<PsiTypeCastExpression> arrayList = new ArrayList<PsiTypeCastExpression>(visitor.myFoundCasts);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/RedundantCastUtil.getRedundantCastsInside must not return null");
        }
        return arrayList;
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        MyIsRedundantVisitor visitor = new MyIsRedundantVisitor(false);
        parent.accept(visitor);
        return visitor.isRedundant;
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        while (arg instanceof PsiParenthesizedExpression) {
            arg = ((PsiParenthesizedExpression)arg).getExpression();
        }
        return arg;
    }

    private static boolean isCastRedundantInRefExpression(final PsiReferenceExpression refExpression, final PsiExpression castOperand) {
        final PsiElement resolved = refExpression.resolve();
        final Ref result = new Ref((Object)Boolean.FALSE);
        refExpression.getManager().performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiReferenceExpression copy;
                    PsiExpression qualifier;
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance(refExpression.getProject()).getElementFactory();
                    PsiExpression copyExpression = elementFactory.createExpressionFromText(refExpression.getText(), refExpression);
                    if (copyExpression instanceof PsiReferenceExpression && (qualifier = (copy = (PsiReferenceExpression)copyExpression).getQualifierExpression()) != null) {
                        qualifier.replace(castOperand);
                        result.set((Object)(copy.resolve() == resolved ? 1 : 0));
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
        });
        return (Boolean)result.get();
    }

    public static boolean isTypeCastSemantical(PsiTypeCastExpression typeCast) {
        PsiExpression operand = typeCast.getOperand();
        if (operand == null) {
            return false;
        }
        PsiType opType = operand.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                return !opType.equals(castType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType(opType);
            if (unboxedOpType != null && !unboxedOpType.equals(castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && ((PsiClassType)castType).hasParameters() && opType instanceof PsiClassType && ((PsiClassType)opType).isRaw()) {
            return true;
        }
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression.getLOperand();
            PsiExpression otherOperand = expression.getROperand();
            if (PsiTreeUtil.isAncestor(otherOperand, typeCast, false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (firstOperand != null && otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand)) {
                return true;
            }
        }
        return false;
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand, PsiExpression otherOperand, PsiExpression toCast) {
        boolean isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNull(operand.getType()) || TypeConversionUtil.isPrimitiveAndNotNull(otherOperand.getType());
        boolean isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNull(toCast.getType()) || TypeConversionUtil.isPrimitiveAndNotNull(otherOperand.getType());
        return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
    }

    private static class MyIsRedundantVisitor
    extends JavaRecursiveElementVisitor {
        private boolean isRedundant = false;
        private final boolean myRecursive;

        private MyIsRedundantVisitor(boolean recursive) {
            this.myRecursive = recursive;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.myRecursive) {
                super.visitElement(element);
            }
        }

        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/RedundantCastUtil$MyIsRedundantVisitor.addToResults must not be null");
            }
            if (!RedundantCastUtil.isTypeCastSemantical(typeCast)) {
                this.isRedundant = true;
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.processPossibleTypeCast(expression.getRExpression(), expression.getLExpression().getType());
            super.visitAssignmentExpression(expression);
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            this.processPossibleTypeCast(variable.getInitializer(), variable.getType());
            super.visitVariable(variable);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            if (method != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        @Override
        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiExpression rExpr = RedundantCastUtil.deparenthesizeExpression(expression.getLOperand());
            PsiExpression lExpr = RedundantCastUtil.deparenthesizeExpression(expression.getROperand());
            if (rExpr != null && lExpr != null) {
                IElementType binaryToken = expression.getOperationSign().getTokenType();
                this.processBinaryExpressionOperand(lExpr, rExpr, binaryToken);
                this.processBinaryExpressionOperand(rExpr, lExpr, binaryToken);
            }
            super.visitBinaryExpression(expression);
        }

        private void processBinaryExpressionOperand(PsiExpression operand, PsiExpression otherOperand, IElementType binaryToken) {
            PsiTypeCastExpression typeCast;
            PsiExpression toCast;
            if (operand instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand).getOperand()) != null && TypeConversionUtil.isBinaryOperatorApplicable(binaryToken, toCast, otherOperand, false)) {
                this.addToResults(typeCast);
            }
        }

        private void processPossibleTypeCast(PsiExpression rExpr, @Nullable PsiType lType) {
            PsiType operandType;
            PsiExpression castOperand;
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression && (castOperand = ((PsiTypeCastExpression)rExpr).getOperand()) != null && (operandType = castOperand.getType()) != null && lType != null && TypeConversionUtil.isAssignable(lType, operandType, false)) {
                this.addToResults((PsiTypeCastExpression)rExpr);
            }
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.processCall(expression);
            this.checkForVirtual(expression);
            super.visitMethodCallExpression(expression);
        }

        private void checkForVirtual(PsiMethodCallExpression methodCall) {
            PsiReferenceExpression methodExpr = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiParenthesizedExpression)) {
                return;
            }
            PsiExpression operand = ((PsiParenthesizedExpression)qualifier).getExpression();
            if (!(operand instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)operand;
            PsiExpression castOperand = typeCast.getOperand();
            if (castOperand == null) {
                return;
            }
            PsiType type = castOperand.getType();
            if (type == null) {
                return;
            }
            if (type instanceof PsiPrimitiveType) {
                return;
            }
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return;
            }
            if (targetMethod.hasModifierProperty("static")) {
                return;
            }
            try {
                PsiType oldReturnType;
                PsiManager manager = methodExpr.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                PsiMethodCallExpression newCall = (PsiMethodCallExpression)factory.createExpressionFromText(methodCall.getText(), methodCall);
                PsiExpression newQualifier = newCall.getMethodExpression().getQualifierExpression();
                PsiExpression newOperand = ((PsiTypeCastExpression)((PsiParenthesizedExpression)newQualifier).getExpression()).getOperand();
                newQualifier.replace(newOperand);
                JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                if (!newResult.isValidResult()) {
                    return;
                }
                PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                PsiType newReturnType = newResult.getSubstitutor().substitute(newTargetMethod.getReturnType());
                if (Comparing.equal((Object)newReturnType, (Object)(oldReturnType = resolveResult.getSubstitutor().substitute(targetMethod.getReturnType())))) {
                    if (newTargetMethod.equals(targetMethod)) {
                        this.addToResults(typeCast);
                    } else if (newTargetMethod.getSignature(newResult.getSubstitutor()).equals(targetMethod.getSignature(resolveResult.getSubstitutor())) && (!newTargetMethod.isDeprecated() || targetMethod.isDeprecated()) && MyIsRedundantVisitor.areThrownExceptionsCompatible(targetMethod, newTargetMethod)) {
                        this.addToResults(typeCast);
                    }
                }
                qualifier = ((PsiTypeCastExpression)((PsiParenthesizedExpression)qualifier).getExpression()).getOperand();
            }
            catch (IncorrectOperationException e) {
                // empty catch block
            }
        }

        private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
            PsiClassType[] newThrowsTypes;
            PsiClassType[] oldThrowsTypes = targetMethod.getThrowsList().getReferencedTypes();
            for (PsiClassType throwsType : newThrowsTypes = newTargetMethod.getThrowsList().getReferencedTypes()) {
                if (MyIsRedundantVisitor.isExceptionThrown(throwsType, oldThrowsTypes)) continue;
                return false;
            }
            return true;
        }

        private static boolean isExceptionThrown(PsiClassType exceptionType, PsiClassType[] thrownTypes) {
            for (PsiClassType type : thrownTypes) {
                if (!type.equals(exceptionType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            this.processCall(expression);
            super.visitNewExpression(expression);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        private void processCall(PsiCallExpression expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            PsiMethod oldMethod = expression.resolveMethod();
            if (oldMethod == null) {
                return;
            }
            PsiParameter[] parameters = oldMethod.getParameterList().getParameters();
            try {
                for (int i = 0; i < args.length; ++i) {
                    PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                    if (!(arg instanceof PsiTypeCastExpression)) continue;
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)arg;
                    if (i == args.length - 1 && args.length == parameters.length && parameters[i].isVarArgs()) continue;
                    PsiCallExpression newCall = (PsiCallExpression)expression.copy();
                    PsiExpressionList argList = newCall.getArgumentList();
                    LOG.assertTrue(argList != null);
                    PsiExpression[] newArgs = argList.getExpressions();
                    PsiTypeCastExpression castExpression = (PsiTypeCastExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                    PsiExpression castOperand = castExpression.getOperand();
                    if (castOperand == null) {
                        return;
                    }
                    castExpression.replace(castOperand);
                    JavaResolveResult newResult = newCall.resolveMethodGenerics();
                    if (!oldMethod.equals(newResult.getElement()) || !newResult.isValidResult() || !Comparing.equal((Object)newCall.getType(), (Object)expression.getType())) continue;
                    this.addToResults(cast);
                }
            }
            catch (IncorrectOperationException e) {
                return;
            }
            for (PsiExpression arg : args) {
                if (arg instanceof PsiTypeCastExpression) {
                    PsiExpression castOperand = ((PsiTypeCastExpression)arg).getOperand();
                    if (castOperand == null) continue;
                    castOperand.accept(this);
                    continue;
                }
                arg.accept(this);
            }
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
            PsiExpression operand = typeCast.getOperand();
            if (operand == null) {
                return;
            }
            PsiExpression expr = RedundantCastUtil.deparenthesizeExpression(operand);
            if (expr instanceof PsiTypeCastExpression) {
                PsiTypeElement typeElement = ((PsiTypeCastExpression)expr).getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                if (!(castType instanceof PsiPrimitiveType)) {
                    this.addToResults((PsiTypeCastExpression)expr);
                }
            } else {
                PsiElement parent = typeCast.getParent();
                if (parent instanceof PsiConditionalExpression && !PsiUtil.isLanguageLevel5OrHigher(typeCast) && !Comparing.equal((Object)operand.getType(), (Object)((PsiConditionalExpression)parent).getType())) {
                    return;
                }
                this.processAlreadyHasTypeCast(typeCast);
            }
        }

        private void processAlreadyHasTypeCast(PsiTypeCastExpression typeCast) {
            PsiElement parent = typeCast.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList) {
                return;
            }
            if (RedundantCastUtil.isTypeCastSemantical(typeCast)) {
                return;
            }
            PsiTypeElement typeElement = typeCast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castTo = typeElement.getType();
            PsiType opType = typeCast.getOperand().getType();
            if (opType == null) {
                return;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (opType instanceof PsiClassType) {
                    PsiReferenceExpression refExpression = (PsiReferenceExpression)parent;
                    PsiElement element = refExpression.resolve();
                    if (!(element instanceof PsiMember)) {
                        return;
                    }
                    PsiClass accessClass = ((PsiClassType)opType).resolve();
                    if (accessClass == null) {
                        return;
                    }
                    if (!JavaPsiFacade.getInstance(parent.getProject()).getResolveHelper().isAccessible((PsiMember)element, typeCast, accessClass)) {
                        return;
                    }
                    if (!RedundantCastUtil.isCastRedundantInRefExpression(refExpression, typeCast.getOperand())) {
                        return;
                    }
                }
            }
            if (MyIsRedundantVisitor.someWhereAtTheLeftSideOfAssignment(parent)) {
                if (TypeConversionUtil.isAssignable(opType, castTo, false)) {
                    this.addToResults(typeCast);
                }
            } else if (TypeConversionUtil.isAssignable(castTo, opType, false)) {
                this.addToResults(typeCast);
            }
        }

        private static boolean someWhereAtTheLeftSideOfAssignment(PsiElement element) {
            PsiAssignmentExpression assignment = PsiTreeUtil.getParentOfType(element, PsiAssignmentExpression.class, false, PsiMember.class);
            if (assignment == null) {
                return false;
            }
            PsiExpression lExpression = assignment.getLExpression();
            return PsiTreeUtil.isAncestor(lExpression, element, false);
        }
    }

    private static class MyCollectingVisitor
    extends MyIsRedundantVisitor {
        private final Set<PsiTypeCastExpression> myFoundCasts = new HashSet<PsiTypeCastExpression>();

        private MyCollectingVisitor() {
            super(true);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visitClass(PsiClass aClass) {
        }

        @Override
        public void visitMethod(PsiMethod method) {
        }

        @Override
        public void visitField(PsiField field) {
        }

        @Override
        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/RedundantCastUtil$MyCollectingVisitor.addToResults must not be null");
            }
            if (!RedundantCastUtil.isTypeCastSemantical(typeCast)) {
                this.myFoundCasts.add(typeCast);
            }
        }
    }
}

