/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystem {
    protected VirtualFileSystem() {
    }

    @NonNls
    @NotNull
    public abstract String getProtocol();

    @Nullable
    public abstract VirtualFile findFileByPath(@NotNull @NonNls String var1);

    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileSystem.extractPresentableUrl must not be null");
        }
        return path.replace('/', File.separatorChar);
    }

    public abstract void refresh(boolean var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByPath(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    @Deprecated
    public void forceRefreshFile(boolean asynchronous, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileSystem.forceRefreshFile must not be null");
        }
        file.refresh(asynchronous, false);
    }

    protected abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    protected abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    protected abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    protected abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    protected abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    public abstract boolean isReadOnly();
}

