/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;

public class VcsException
extends Exception {
    public static final VcsException[] EMPTY_ARRAY = new VcsException[0];
    private VirtualFile myVirtualFile;
    private Collection<String> myMessages;
    private boolean isWarning = false;

    public VcsException(String message) {
        super(message);
        this.initMessage(message);
    }

    private void initMessage(String message) {
        String shownMessage = message == null ? VcsBundle.message("exception.text.unknown.error", new Object[0]) : message;
        this.myMessages = Collections.singleton(shownMessage);
    }

    public VcsException(Throwable throwable) {
        this(throwable.getMessage() != null ? throwable.getMessage() : throwable.getLocalizedMessage(), throwable);
    }

    public VcsException(String message, Throwable cause) {
        super(message, cause);
        this.initMessage(message);
    }

    public VcsException(Collection<String> messages) {
        this.myMessages = messages;
    }

    public void setVirtualFile(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public String[] getMessages() {
        return ArrayUtil.toStringArray(this.myMessages);
    }

    public VcsException setIsWarning(boolean warning) {
        this.isWarning = warning;
        return this;
    }

    public boolean isWarning() {
        return this.isWarning;
    }
}

