/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFileOperation;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;

public class CompositeOperaton
extends CvsOperation {
    private final List<CvsOperation> mySubOperations = new ArrayList<CvsOperation>();
    private CvsOperation myCurrentOperation;

    public void addOperation(CvsOperation operation) {
        this.mySubOperations.add(operation);
    }

    protected void addOperation(int i, CvsOperation operation) {
        this.mySubOperations.add(i, operation);
    }

    @Override
    public void appendSelfCvsRootProvider(@NotNull Collection<CvsRootProvider> roots) throws CannotFindCvsRootException {
        if (roots == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/cvsoperations/common/CompositeOperaton.appendSelfCvsRootProvider must not be null");
        }
        for (CvsOperation operation : this.mySubOperations) {
            operation.appendSelfCvsRootProvider(roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CvsExecutionEnvironment executionEnvironment) throws VcsException, CommandAbortedException {
        CvsEntriesManager.getInstance().lockSynchronizationActions();
        try {
            Iterator<CvsOperation> i$ = this.getSubOperations().iterator();
            while (i$.hasNext()) {
                CvsOperation cvsOperation;
                this.myCurrentOperation = cvsOperation = i$.next();
                this.myCurrentOperation.execute(executionEnvironment);
            }
        }
        finally {
            CvsEntriesManager.getInstance().unlockSynchronizationActions();
        }
    }

    @Override
    public void executeFinishActions() {
        super.executeFinishActions();
        for (CvsOperation cvsOperation : this.getSubOperations()) {
            cvsOperation.executeFinishActions();
        }
    }

    @Override
    public String getLastProcessedCvsRoot() {
        if (this.myCurrentOperation == null) {
            return null;
        }
        return this.myCurrentOperation.getLastProcessedCvsRoot();
    }

    protected boolean containsSubOperation(AddFileOperation op) {
        return this.mySubOperations.contains(op);
    }

    protected List<CvsOperation> getSubOperations() {
        return this.mySubOperations;
    }

    @Override
    public boolean runInReadThread() {
        for (CvsOperation op : this.mySubOperations) {
            if (!op.runInReadThread()) continue;
            return true;
        }
        return false;
    }

    protected int getSubOperationsCount() {
        return this.mySubOperations.size();
    }
}

