/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.BooleanLiteralEqualityPredicate;
import org.jetbrains.annotations.NotNull;

public class RemoveBooleanEqualityIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        return IntentionPowerPackBundle.message("remove.boolean.equality.intention.name", sign.getText());
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        BooleanLiteralEqualityPredicate booleanLiteralEqualityPredicate = new BooleanLiteralEqualityPredicate();
        if (booleanLiteralEqualityPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/bool/RemoveBooleanEqualityIntention.getElementPredicate must not return null");
        }
        return booleanLiteralEqualityPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        assert (exp != null);
        PsiJavaToken sign = exp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        boolean isEquals = JavaTokenType.EQEQ.equals(tokenType);
        PsiExpression lhs = exp.getLOperand();
        String lhsText = lhs.getText();
        PsiExpression rhs = exp.getROperand();
        assert (rhs != null);
        String rhsText = rhs.getText();
        if ("true".equals(lhsText)) {
            if (isEquals) {
                RemoveBooleanEqualityIntention.replaceExpression(rhsText, (PsiExpression)exp);
            } else {
                RemoveBooleanEqualityIntention.replaceExpressionWithNegatedExpression(rhs, (PsiExpression)exp);
            }
        } else if ("false".equals(lhsText)) {
            if (isEquals) {
                RemoveBooleanEqualityIntention.replaceExpressionWithNegatedExpression(rhs, (PsiExpression)exp);
            } else {
                RemoveBooleanEqualityIntention.replaceExpression(rhsText, (PsiExpression)exp);
            }
        } else if ("true".equals(rhsText)) {
            if (isEquals) {
                RemoveBooleanEqualityIntention.replaceExpression(lhsText, (PsiExpression)exp);
            } else {
                RemoveBooleanEqualityIntention.replaceExpressionWithNegatedExpression(lhs, (PsiExpression)exp);
            }
        } else if (isEquals) {
            RemoveBooleanEqualityIntention.replaceExpressionWithNegatedExpression(lhs, (PsiExpression)exp);
        } else {
            RemoveBooleanEqualityIntention.replaceExpression(lhsText, (PsiExpression)exp);
        }
    }
}

