/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.misc.PsiElementSetSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntGenericReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntRefIdReference
extends AntGenericReference {
    public AntRefIdReference(AntElement antElement, String str, TextRange textRange, XmlAttribute attribute) {
        super(antElement, str, textRange, attribute);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntStructuredElement element = this.getElement();
        if (element instanceof AntStructuredElement) {
            this.getAttribute().setValue(newElementName);
        }
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntRefIdReference.bindToElement must not be null");
        }
        if (element instanceof AntStructuredElement) {
            PsiNamedElement psiNamedElement = (PsiNamedElement)element;
            return this.handleElementRename(psiNamedElement.getName());
        }
        throw new IncorrectOperationException("Can bind only to ant structured elements.");
    }

    @Override
    public AntStructuredElement getElement() {
        return (AntStructuredElement)super.getElement();
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("cannot.resolve.refid", this.getCanonicalRepresentationText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement resolveInner() {
        String id = this.getCanonicalRepresentationText();
        Set<PsiElement> elementsDepthStack = PsiElementSetSpinAllocator.alloc();
        try {
            AntStructuredElement elem = this.getElement();
            AntFile contextFile = AntConfigurationBase.getInstance(elem.getProject()).getEffectiveContextFile(elem.getAntFile());
            AntElement antElement = AntRefIdReference.resolve(id, contextFile.getAntProject(), elementsDepthStack);
            return antElement;
        }
        finally {
            PsiElementSetSpinAllocator.dispose(elementsDepthStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object[] getVariants() {
        Set<PsiElement> variants = PsiElementSetSpinAllocator.alloc();
        try {
            Object[] objectArray;
            Set<PsiElement> elementsDepthStack = PsiElementSetSpinAllocator.alloc();
            try {
                AntRefIdReference.getVariants(this.getElement().getAntProject(), variants, elementsDepthStack);
                objectArray = ArrayUtil.toObjectArray(variants);
            }
            catch (Throwable throwable) {
                PsiElementSetSpinAllocator.dispose(elementsDepthStack);
                throw throwable;
            }
            PsiElementSetSpinAllocator.dispose(elementsDepthStack);
            if (objectArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntRefIdReference.getVariants must not return null");
            }
            return objectArray;
        }
        finally {
            PsiElementSetSpinAllocator.dispose(variants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static AntElement resolve(String id, AntProject project, Set<PsiElement> elementsDepthStack) {
        if (elementsDepthStack.contains(project)) {
            return null;
        }
        elementsDepthStack.add(project);
        try {
            AntElement refId = project.getElementByRefId(id);
            if (refId == null) {
                AntFile file;
                AntFile[] arr$ = project.getImportedFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (refId = AntRefIdReference.resolve(id, (file = arr$[i$]).getAntProject(), elementsDepthStack)) == null; ++i$) {
                }
            }
            AntElement antElement = refId;
            return antElement;
        }
        finally {
            elementsDepthStack.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getVariants(AntProject project, Set<PsiElement> variants, Set<PsiElement> elementsDepthStack) {
        if (elementsDepthStack.contains(project)) {
            return;
        }
        elementsDepthStack.add(project);
        try {
            for (String id : project.getRefIds()) {
                AntElement refElement = project.getElementByRefId(id);
                if (refElement == null) continue;
                variants.add(refElement);
            }
            for (AntFile file : project.getImportedFiles()) {
                AntRefIdReference.getVariants(file.getAntProject(), variants, elementsDepthStack);
            }
        }
        finally {
            elementsDepthStack.remove(project);
        }
    }
}

