/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.changes;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.psi.AntDefTask;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntMacroDef;
import com.intellij.lang.ant.psi.AntPresetDef;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntScriptDef;
import com.intellij.lang.ant.psi.AntTypeDef;
import com.intellij.lang.ant.psi.impl.AntOuterProjectElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.xml.XmlChangeVisitor;
import com.intellij.pom.xml.events.XmlAttributeSet;
import com.intellij.pom.xml.events.XmlDocumentChanged;
import com.intellij.pom.xml.events.XmlElementChanged;
import com.intellij.pom.xml.events.XmlTagChildAdd;
import com.intellij.pom.xml.events.XmlTagChildChanged;
import com.intellij.pom.xml.events.XmlTagChildRemoved;
import com.intellij.pom.xml.events.XmlTagNameChanged;
import com.intellij.pom.xml.events.XmlTextChanged;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Set;

public class AntChangeVisitor
implements XmlChangeVisitor {
    private static final Set<AntBuildFile> myDirtyFiles = new HashSet<AntBuildFile>();
    private static final Alarm myAlarm = new Alarm();

    public void visitXmlAttributeSet(XmlAttributeSet xmlAttributeSet) {
        XmlTag tag = xmlAttributeSet.getTag();
        if ("basedir".equals(xmlAttributeSet.getName())) {
            AntChangeVisitor.getAntFile((XmlElement)tag).clearCaches();
        } else {
            AntChangeVisitor.clearParentCaches((XmlElement)tag);
        }
    }

    public void visitDocumentChanged(XmlDocumentChanged xmlDocumentChanged) {
        XmlDocument doc = xmlDocumentChanged.getDocument();
        AntFile antFile = AntChangeVisitor.getAntFile((XmlElement)doc);
        if (antFile != null) {
            antFile.clearCaches();
        }
    }

    public void visitXmlElementChanged(XmlElementChanged xmlElementChanged) {
        AntChangeVisitor.clearParentCaches(xmlElementChanged.getElement());
    }

    public void visitXmlTagChildAdd(XmlTagChildAdd xmlTagChildAdd) {
        AntChangeVisitor.clearParentCaches((XmlElement)xmlTagChildAdd.getChild());
    }

    public void visitXmlTagChildChanged(XmlTagChildChanged xmlTagChildChanged) {
        AntChangeVisitor.clearParentCaches((XmlElement)xmlTagChildChanged.getChild());
    }

    public void visitXmlTagChildRemoved(XmlTagChildRemoved xmlTagChildRemoved) {
        XmlTag tag = xmlTagChildRemoved.getTag();
        AntFile antFile = AntChangeVisitor.getAntFile((XmlElement)tag);
        if (antFile != null) {
            antFile.clearCachesWithTypeDefinitions();
        } else {
            AntChangeVisitor.clearParentCaches((XmlElement)tag);
        }
    }

    public void visitXmlTagNameChanged(XmlTagNameChanged xmlTagNameChanged) {
        AntChangeVisitor.clearParentCaches((XmlElement)xmlTagNameChanged.getTag());
    }

    public void visitXmlTextChanged(XmlTextChanged xmlTextChanged) {
        AntChangeVisitor.clearParentCaches((XmlElement)xmlTextChanged.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearParentCaches(XmlElement el) {
        TextRange textRange = el.getTextRange();
        AntFile file = AntChangeVisitor.getAntFile(el);
        if (file == null) {
            return;
        }
        AntElement element = file.lightFindElementAt(textRange.getStartOffset());
        boolean shouldInvalidateProperties = element instanceof AntProperty;
        if (element instanceof AntDefTask) {
            if (element.isValid()) {
                element.clearCaches();
            } else {
                ((AntDefTask)element).clearClassesCache();
            }
        }
        if (element != null) {
            while (!((element = element.getAntParent()) == null || element instanceof AntFile || element.isValid() && element.getTextLength() > textRange.getLength() && !(element instanceof AntOuterProjectElement))) {
            }
        }
        if (element == null) {
            element = file;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            AntTypeDef typeDef;
            AntScriptDef scriptdef;
            AntPresetDef presetdef;
            AntMacroDef macrodef;
            element.clearCaches();
            if (shouldInvalidateProperties) {
                file.invalidateProperties();
            }
            if ((macrodef = (AntMacroDef)PsiTreeUtil.getParentOfType((PsiElement)element, AntMacroDef.class, (boolean)false)) != null) {
                macrodef.clearCaches();
            }
            if ((presetdef = (AntPresetDef)PsiTreeUtil.getParentOfType((PsiElement)element, AntPresetDef.class, (boolean)false)) != null) {
                presetdef.clearCaches();
            }
            if ((scriptdef = (AntScriptDef)PsiTreeUtil.getParentOfType((PsiElement)element, AntScriptDef.class, (boolean)false)) != null) {
                scriptdef.clearCaches();
            }
            if ((typeDef = (AntTypeDef)PsiTreeUtil.getParentOfType((PsiElement)element, AntTypeDef.class, (boolean)false)) != null) {
                typeDef.clearCaches();
            }
        }
        AntChangeVisitor.updateBuildFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBuildFile(final AntFile file) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AntChangeVisitor.updateBuildFile(file);
                }
            });
        } else {
            final Project project = file.getProject();
            if (project.isDisposed()) {
                return;
            }
            VirtualFile vFile = file.getVirtualFile();
            for (AntBuildFile buildFile : AntConfiguration.getInstance(project).getBuildFiles()) {
                if (!Comparing.equal((Object)vFile, (Object)buildFile.getVirtualFile())) continue;
                Set<AntBuildFile> set = myDirtyFiles;
                synchronized (set) {
                    myDirtyFiles.add(buildFile);
                }
                myAlarm.cancelAllRequests();
                myAlarm.addRequest(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AntBuildFile[] files = null;
                        Set set = myDirtyFiles;
                        synchronized (set) {
                            if (myDirtyFiles.size() > 0) {
                                files = myDirtyFiles.toArray(new AntBuildFile[myDirtyFiles.size()]);
                                myDirtyFiles.clear();
                            }
                        }
                        if (files != null) {
                            for (AntBuildFile dirtyFile : files) {
                                Project proj = dirtyFile.getProject();
                                if (proj.isDisposed()) continue;
                                AntConfiguration.getInstance(project).updateBuildFile(dirtyFile);
                            }
                        }
                    }
                }, 300);
                break;
            }
        }
    }

    private static AntFile getAntFile(XmlElement el) {
        return AntSupport.getAntFile(el.getContainingFile());
    }
}

