/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;

public class AntLanguageExtension
implements LanguageFilter {
    public boolean isRelevantForFile(PsiFile psi) {
        return psi instanceof XmlFile && AntLanguageExtension.isAntFile((XmlFile)psi);
    }

    public static boolean isAntFile(XmlFile xmlFile) {
        XmlTag tag;
        XmlDocument document = xmlFile.getDocument();
        if (document != null && (tag = document.getRootTag()) != null && "project".equals(tag.getName()) && tag.getContext() instanceof XmlDocument) {
            if (tag.getAttributeValue("default") != null) {
                return true;
            }
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (vFile != null && ForcedAntFileAttribute.isAntFile(vFile)) {
                return true;
            }
        }
        return false;
    }

    public Language getLanguage() {
        return AntSupport.getLanguage();
    }
}

