/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class SupertypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    protected SupertypeConstraint(PsiType type, PsiType defaultType) {
        super(type);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type, PsiManager manager, GlobalSearchScope scope) {
        return TypesUtil.isAssignableByMethodCallConversion(type, this.getType(), manager, scope);
    }

    @Override
    public PsiType getDefaultType() {
        return this.myDefaultType;
    }

    public static SupertypeConstraint create(PsiType type, PsiType defaultType) {
        return new SupertypeConstraint(type, defaultType);
    }

    public static SupertypeConstraint create(String fqName, String defaultFqName, PsiElement context) {
        return new SupertypeConstraint((PsiType)TypesUtil.createType(fqName, context), (PsiType)TypesUtil.createType(defaultFqName, context));
    }

    public static SupertypeConstraint create(PsiType type) {
        return new SupertypeConstraint(type, type);
    }

    public static SupertypeConstraint create(String fqName, PsiElement context) {
        PsiClassType type = TypesUtil.createType(fqName, context);
        return new SupertypeConstraint((PsiType)type, (PsiType)type);
    }
}

