/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineMover;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineRange;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class StatementMover
extends LineMover {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.StatementMover");

    public StatementMover(boolean down) {
        super(down);
    }

    @Override
    protected boolean checkAvailable(Editor editor, PsiFile file) {
        int endOffset;
        boolean available = super.checkAvailable(editor, file);
        if (!available) {
            return false;
        }
        LineRange range = this.toMove;
        if (editor == null) {
            return false;
        }
        Document document = editor.getDocument();
        if ((range = StatementMover.expandLineRangeToCoverPsiElements(range, editor, file)) == null) {
            return false;
        }
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement[] statements = GroovyRefactoringUtil.findStatementsInRange(file, startOffset, endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)), false);
        if (statements.length == 0) {
            return false;
        }
        for (PsiElement statement : statements) {
            GrMembersDeclaration declaration;
            if (!(statement instanceof GrMembersDeclaration) || (declaration = (GrMembersDeclaration)statement).getMembers().length <= 0) continue;
            return false;
        }
        range = this.toMove = new LineRange(statements[0], statements[statements.length - 1], document);
        this.updateComplementaryRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)range.firstElement, (PsiElement)range.lastElement);
        Class[] classes = new Class[]{GrMethod.class, GrTypeDefinition.class, PsiComment.class, GroovyFile.class};
        PsiElement guard = PsiTreeUtil.getParentOfType((PsiElement)commonParent, (Class[])classes);
        if (!this.calcInsertOffset(file, editor, range)) {
            return false;
        }
        int insertOffset = this.isDown ? StatementMover.getLineStartSafeOffset(document, this.toMove2.endLine) - 1 : document.getLineStartOffset(this.toMove2.startLine);
        PsiElement newGuard = file.getViewProvider().findElementAt(insertOffset);
        if ((newGuard = PsiTreeUtil.getParentOfType((PsiElement)newGuard, (Class[])classes)) != null && newGuard != guard && StatementMover.isInside(insertOffset, newGuard) != PsiTreeUtil.isAncestor((PsiElement)newGuard, (PsiElement)range.lastElement, (boolean)false)) {
            PsiElement candidate;
            if (!PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)newGuard, (boolean)false)) {
                return false;
            }
            while ((candidate = PsiTreeUtil.getParentOfType((PsiElement)newGuard, (Class[])classes)) != null && candidate != guard && PsiTreeUtil.isAncestor((PsiElement)guard, (PsiElement)candidate, (boolean)false)) {
                newGuard = candidate;
            }
            this.toMove2 = new LineRange(newGuard, newGuard, document);
        }
        return true;
    }

    @Nullable
    private static LineRange expandLineRangeToCoverPsiElements(LineRange range, Editor editor, PsiFile file) {
        int endLine;
        Document document;
        Pair<PsiElement, PsiElement> psiRange = StatementMover.getElementRange(editor, file, range);
        if (psiRange == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        if (parent instanceof LeafPsiElement && parent.getParent() instanceof GrLiteralImpl) {
            return null;
        }
        Pair<PsiElement, PsiElement> elementRange = StatementMover.getElementRange(parent, (PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
        if (elementRange == null) {
            return null;
        }
        int endOffset = ((PsiElement)elementRange.getSecond()).getTextRange().getEndOffset();
        if (endOffset > (document = editor.getDocument()).getTextLength()) {
            LOG.assertTrue(!PsiDocumentManager.getInstance((Project)file.getProject()).isUncommited(document));
            LOG.assertTrue(PsiDocumentManagerImpl.checkConsistency((PsiFile)file, (Document)document));
        }
        if (endOffset == document.getTextLength()) {
            endLine = document.getLineCount();
        } else {
            endLine = editor.offsetToLogicalPosition((int)endOffset).line + 1;
            endLine = Math.min(endLine, document.getLineCount());
        }
        int startLine = Math.min(range.startLine, editor.offsetToLogicalPosition((int)((PsiElement)elementRange.getFirst()).getTextOffset()).line);
        endLine = Math.max(endLine, range.endLine);
        return new LineRange(startLine, endLine);
    }

    private static boolean isInside(int offset, PsiElement guard) {
        PsiElement lBrace;
        GrTypeDefinitionBody body;
        if (guard == null) {
            return false;
        }
        TextRange inside = null;
        if (guard instanceof GrMethod) {
            GrOpenBlock block = ((GrMethod)guard).getBlock();
            if (block != null) {
                inside = block.getTextRange();
            }
        } else if (guard instanceof GrClosableBlock) {
            inside = guard.getTextRange();
        } else if (guard instanceof GrTypeDefinition && (body = ((GrTypeDefinition)guard).getBody()) != null && (lBrace = body.getLBrace()) != null) {
            inside = new TextRange(lBrace.getTextOffset(), body.getTextRange().getEndOffset());
        }
        return inside != null && inside.contains(offset);
    }

    private boolean calcInsertOffset(PsiFile file, Editor editor, LineRange range) {
        int startLine;
        int line = this.isDown ? range.endLine + 1 : range.startLine - 1;
        int n = startLine = this.isDown ? range.endLine : range.startLine - 1;
        if (line < 0 || startLine < 0) {
            return false;
        }
        do {
            int offset;
            if ((offset = editor.logicalPositionToOffset(new LogicalPosition(line, 0))) == file.getTextLength()) {
                return true;
            }
            for (PsiElement element = StatementMover.firstNonWhiteElement(offset, file, true, true); element != null && !(element instanceof PsiFile); element = element.getParent()) {
                if (element.getTextRange().grown(-1).shiftRight(1).contains(offset)) continue;
                boolean found = false;
                if ((element instanceof GrTopStatement || element instanceof PsiComment) && StatementMover.statementCanBePlacedAlong(element)) {
                    found = true;
                } else if (element.getNode() != null && element.getNode().getElementType() == GroovyTokenTypes.mRCURLY) {
                    found = true;
                }
                if (!found) continue;
                this.toMove = range;
                int endLine = line;
                if (startLine > endLine) {
                    int tmp = endLine;
                    endLine = startLine;
                    startLine = tmp;
                }
                this.toMove2 = this.isDown ? new LineRange(startLine, endLine) : new LineRange(startLine, endLine + 1);
                return true;
            }
        } while ((line += this.isDown ? 1 : -1) != 0 && line < editor.getDocument().getLineCount());
        return false;
    }

    private static boolean statementCanBePlacedAlong(PsiElement element) {
        if (element instanceof GrBlockStatement) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof GrCodeBlock) {
            return true;
        }
        if (parent instanceof GroovyFile) {
            return true;
        }
        if (parent instanceof GrIfStatement && (element == ((GrIfStatement)parent).getThenBranch() || element == ((GrIfStatement)parent).getElseBranch())) {
            return true;
        }
        if (parent instanceof GrWhileStatement && element == ((GrWhileStatement)parent).getBody()) {
            return true;
        }
        return parent instanceof GrForStatement && element == ((GrForStatement)parent).getBody();
    }
}

