/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SyntaxHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;

public class DefaultHighlighter {
    @NonNls
    static final String LINE_COMMENT_ID = "Line comment";
    @NonNls
    static final String BLOCK_COMMENT_ID = "Block comment";
    @NonNls
    static final String DOC_COMMENT_ID = "Groovydoc comment";
    @NonNls
    static final String DOC_COMMENT_TAG_ID = "Groovydoc tag";
    @NonNls
    static final String KEYWORD_ID = "Keyword";
    @NonNls
    static final String NUMBER_ID = "Number";
    @NonNls
    static final String GSTRING_ID = "GString";
    @NonNls
    static final String STRING_ID = "String";
    @NonNls
    static final String REGEXP_ID = "Regular expression";
    @NonNls
    static final String BRACES_ID = "Braces";
    @NonNls
    static final String OPERATION_SIGN_ID = "Operation sign";
    @NonNls
    static final String BAD_CHARACTER_ID = "Bad character";
    @NonNls
    static final String WRONG_STRING_ID = "Wrong string literal";
    @NonNls
    static final String ANNOTATION_ID = "Annotation";
    @NonNls
    static final String INSTANCE_FIELD_ID = "Instance field";
    @NonNls
    static final String STATIC_FIELD_ID = "Static field";
    @NonNls
    static final String METHOD_CALL_ID = "Method call";
    @NonNls
    static final String STATIC_METHOD_ACCESS_ID = "Static method access";
    @NonNls
    static final String UNRESOLVED_ACCESS_ID = "Unresolved reference access";
    public static TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Line comment", (TextAttributes)SyntaxHighlighterColors.LINE_COMMENT.getDefaultAttributes());
    public static TextAttributesKey ANNOTATION = TextAttributesKey.createTextAttributesKey((String)"Annotation", (TextAttributes)HighlightInfoType.ANNOTATION_NAME.getAttributesKey().getDefaultAttributes());
    public static TextAttributesKey INSTANCE_FIELD = TextAttributesKey.createTextAttributesKey((String)"Instance field", (TextAttributes)HighlightInfoType.INSTANCE_FIELD.getAttributesKey().getDefaultAttributes());
    public static TextAttributesKey METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"Method call", (TextAttributes)HighlightInfoType.METHOD_CALL.getAttributesKey().getDefaultAttributes());
    public static TextAttributesKey STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"Static field", (TextAttributes)HighlightInfoType.STATIC_FIELD.getAttributesKey().getDefaultAttributes());
    public static TextAttributesKey STATIC_METHOD_ACCESS = TextAttributesKey.createTextAttributesKey((String)"Static method access", (TextAttributes)HighlightInfoType.STATIC_METHOD.getAttributesKey().getDefaultAttributes());
    public static TextAttributesKey BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Block comment", (TextAttributes)SyntaxHighlighterColors.JAVA_BLOCK_COMMENT.getDefaultAttributes());
    public static TextAttributesKey DOC_COMMENT_CONTENT = TextAttributesKey.createTextAttributesKey((String)"Groovydoc comment", (TextAttributes)SyntaxHighlighterColors.DOC_COMMENT.getDefaultAttributes());
    public static TextAttributesKey DOC_COMMENT_TAG = TextAttributesKey.createTextAttributesKey((String)"Groovydoc tag", (TextAttributes)SyntaxHighlighterColors.DOC_COMMENT_TAG.getDefaultAttributes());
    public static final TextAttributes KEYWORD_ATTRIBUTES = SyntaxHighlighterColors.KEYWORD.getDefaultAttributes().clone();
    public static TextAttributesKey KEYWORD;
    public static TextAttributesKey NUMBER;
    public static TextAttributesKey GSTRING;
    public static TextAttributesKey STRING;
    public static TextAttributesKey REGEXP;
    public static TextAttributesKey BRACES;
    public static TextAttributesKey OPERATION_SIGN;
    public static TextAttributesKey BAD_CHARACTER;
    public static TextAttributesKey WRONG_STRING;
    public static final TextAttributes UNRESOLVED_ACCESS_ATTRIBUTES;
    public static TextAttributesKey UNRESOLVED_ACCESS;

    private DefaultHighlighter() {
    }

    static {
        KEYWORD_ATTRIBUTES.setForegroundColor(new Color(0, 0, 67));
        KEYWORD_ATTRIBUTES.setFontType(1);
        KEYWORD = TextAttributesKey.createTextAttributesKey((String)KEYWORD_ID, (TextAttributes)KEYWORD_ATTRIBUTES);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)NUMBER_ID, (TextAttributes)SyntaxHighlighterColors.NUMBER.getDefaultAttributes());
        GSTRING = TextAttributesKey.createTextAttributesKey((String)GSTRING_ID, (TextAttributes)SyntaxHighlighterColors.STRING.getDefaultAttributes());
        STRING = TextAttributesKey.createTextAttributesKey((String)STRING_ID, (TextAttributes)SyntaxHighlighterColors.STRING.getDefaultAttributes());
        REGEXP = TextAttributesKey.createTextAttributesKey((String)REGEXP_ID, (TextAttributes)SyntaxHighlighterColors.VALID_STRING_ESCAPE.getDefaultAttributes());
        BRACES = TextAttributesKey.createTextAttributesKey((String)BRACES_ID, (TextAttributes)SyntaxHighlighterColors.BRACKETS.getDefaultAttributes());
        OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)OPERATION_SIGN_ID, (TextAttributes)SyntaxHighlighterColors.OPERATION_SIGN.getDefaultAttributes());
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)BAD_CHARACTER_ID, (TextAttributes)CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES.getDefaultAttributes());
        WRONG_STRING = TextAttributesKey.createTextAttributesKey((String)WRONG_STRING_ID, (TextAttributes)SyntaxHighlighterColors.STRING.getDefaultAttributes());
        UNRESOLVED_ACCESS_ATTRIBUTES = HighlighterColors.TEXT.getDefaultAttributes().clone();
        UNRESOLVED_ACCESS_ATTRIBUTES.setForegroundColor(Color.BLACK);
        UNRESOLVED_ACCESS_ATTRIBUTES.setEffectColor(Color.GRAY);
        UNRESOLVED_ACCESS_ATTRIBUTES.setEffectType(EffectType.LINE_UNDERSCORE);
        UNRESOLVED_ACCESS = TextAttributesKey.createTextAttributesKey((String)UNRESOLVED_ACCESS_ID, (TextAttributes)UNRESOLVED_ACCESS_ATTRIBUTES);
    }
}

