/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gradle.openapi.external.ui.AlternateUIInteractionVersion1;
import org.gradle.openapi.external.ui.BasicGradleUIVersion1;
import org.gradle.openapi.external.ui.GradleTabVersion1;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;
import org.gradle.openapi.external.ui.SinglePaneUIInteractionVersion1;
import org.gradle.openapi.external.ui.SinglePaneUIVersion1;
import org.gradle.openapi.external.ui.UIFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.gradle.GradleLibraryManager;
import org.jetbrains.plugins.groovy.gradle.ui.GradleSetupPanel;
import org.jetbrains.plugins.groovy.gradle.ui.GradleUIAvailabilityObserver;
import org.jetbrains.plugins.groovy.gradle.ui.GradleUISettings;
import org.jetbrains.plugins.groovy.gradle.ui.ObserverLord;

public class GradlePanelWrapper {
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private Project myProject;
    private GradleUISettings settings;
    private SinglePaneUIVersion1 singlePaneUIVersion1;
    private GradleSetupPanel gradleSetupPanel;
    private List<GradleTabVersion1> additionalTabs = new ArrayList<GradleTabVersion1>();
    private ObserverLord<GradleUIAvailabilityObserver> observerLord = new ObserverLord();

    public void initalize(@Nullable Module module, Project myProject) {
        this.myProject = myProject;
        this.settings = GradleUISettings.getInstance(myProject);
        File gradleHomeDirectory = new File(GradleLibraryManager.getSdkHome(module, myProject).getPath());
        this.setupUI(gradleHomeDirectory);
    }

    public Project getProject() {
        return this.myProject;
    }

    private boolean setupUI(final File gradleHomeDirectory) {
        try {
            if (gradleHomeDirectory == null) {
                this.addGradleSetupPanel("Gradle not configured", (String)null);
                return false;
            }
            if (!gradleHomeDirectory.exists()) {
                this.addGradleSetupPanel("Gradle directory does not exist.", gradleHomeDirectory.getAbsolutePath());
                return false;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.loadUIFromGradle(gradleHomeDirectory);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GradlePanelWrapper.this.loadUIFromGradle(gradleHomeDirectory);
                    }
                });
            }
            if (this.singlePaneUIVersion1 != null) {
                this.singlePaneUIVersion1.setCurrentDirectory(new File(this.myProject.getBaseDir().getPath()));
                this.addAdditionalTabs();
                this.setMainPanelContents(this.singlePaneUIVersion1.getComponent());
                this.singlePaneUIVersion1.aboutToShow();
                return true;
            }
        }
        catch (Exception e) {
            this.singlePaneUIVersion1 = null;
            this.notifyGradleUIUnloaded();
            this.addGradleSetupPanel("Failed to load the gradle library.", e);
        }
        return false;
    }

    private void loadUIFromGradle(File gradleHomeDirectory) {
        try {
            this.singlePaneUIVersion1 = UIFactory.createUI((ClassLoader)GradlePanelWrapper.class.getClassLoader(), (File)gradleHomeDirectory, (SinglePaneUIInteractionVersion1)new IdeaUIInteraction(), (boolean)false);
            final SinglePaneUIVersion1 singlePaneUIVersion1 = this.getSinglePaneUIVersion1();
            final Project project = this.getProject();
            this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<GradleUIAvailabilityObserver>(){

                @Override
                public void notify(GradleUIAvailabilityObserver observer) {
                    observer.gradleUILoaded(singlePaneUIVersion1, project);
                }
            });
        }
        catch (Throwable e) {
            this.singlePaneUIVersion1 = null;
            this.notifyGradleUIUnloaded();
            e.printStackTrace();
            this.addGradleSetupPanel("Failed to load the gradle library.", e);
        }
    }

    void notifyGradleUIUnloaded() {
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<GradleUIAvailabilityObserver>(){

            @Override
            public void notify(GradleUIAvailabilityObserver observer) {
                observer.gradleUIUnloaded();
            }
        });
    }

    public JPanel getComponent() {
        return this.mainPanel;
    }

    private void addGradleSetupPanel(String message, String messageDetails) {
        if (this.gradleSetupPanel == null) {
            this.gradleSetupPanel = new GradleSetupPanel();
        }
        this.gradleSetupPanel.setMessage(message, messageDetails);
        this.setMainPanelContents(this.gradleSetupPanel.getComponent());
    }

    private void addGradleSetupPanel(String message, Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        this.addGradleSetupPanel(message, throwable.getMessage() + "\n" + sw.toString());
    }

    private void setMainPanelContents(Component newComponent) {
        this.mainPanel.removeAll();
        this.mainPanel.invalidate();
        this.mainPanel.add(newComponent, "Center");
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void editFile(File file) {
        VirtualFile virtualFile;
        if (file != null && file.exists() && (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file)) != null) {
            FileEditorManager.getInstance((Project)this.myProject).openFile(virtualFile, true);
        }
    }

    public void close() {
        if (this.singlePaneUIVersion1 != null) {
            this.singlePaneUIVersion1.close();
            this.setMainPanelContents(new JLabel("Closing"));
            this.singlePaneUIVersion1 = null;
            this.notifyGradleUIUnloaded();
        }
    }

    public boolean canClose() {
        if (this.singlePaneUIVersion1 != null) {
            return this.singlePaneUIVersion1.canClose(new BasicGradleUIVersion1.CloseInteraction(){

                public boolean promptUserToConfirmClosingWhileBusy() {
                    int result = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(GradlePanelWrapper.this.mainPanel), "Gradle tasks are being currently being executed. Exit anyway?", "Exit While Busy?", 0, 3);
                    return result == 0;
                }
            });
        }
        return true;
    }

    public void addTab(GradleTabVersion1 tab) {
        this.additionalTabs.add(tab);
        if (this.singlePaneUIVersion1 != null) {
            this.singlePaneUIVersion1.addTab(this.singlePaneUIVersion1.getGradleTabCount() + 1, tab);
        }
    }

    public void removeTab(GradleTabVersion1 tab) {
        this.additionalTabs.remove(tab);
        if (this.singlePaneUIVersion1 != null) {
            this.singlePaneUIVersion1.removeTab(tab);
        }
    }

    private void addAdditionalTabs() {
        for (GradleTabVersion1 gradleTab : this.additionalTabs) {
            this.singlePaneUIVersion1.addTab(this.singlePaneUIVersion1.getGradleTabCount() + 1, gradleTab);
        }
    }

    public SinglePaneUIVersion1 getSinglePaneUIVersion1() {
        return this.singlePaneUIVersion1;
    }

    private class IdeaAlternateUIInteraction
    implements AlternateUIInteractionVersion1 {
        private IdeaAlternateUIInteraction() {
        }

        public void editFiles(List<File> files) {
            for (File file : files) {
                GradlePanelWrapper.this.editFile(file);
            }
        }

        public boolean doesSupportEditingFiles() {
            return true;
        }
    }

    private class IdeaUIInteraction
    implements SinglePaneUIInteractionVersion1 {
        private IdeaUIInteraction() {
        }

        public AlternateUIInteractionVersion1 instantiateAlternateUIInteraction() {
            return new IdeaAlternateUIInteraction();
        }

        public SettingsNodeVersion1 instantiateSettings() {
            return GradlePanelWrapper.this.settings.getRootNode();
        }
    }
}

