/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;

public class GroovycOSProcessHandler
extends OSProcessHandler {
    private final List<TranslatingCompiler.OutputItem> myCompiledItems = new ArrayList<TranslatingCompiler.OutputItem>();
    private final Set<File> toRecompileFiles = new HashSet<File>();
    private final List<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
    private final StringBuffer unparsedOutput = new StringBuffer();
    private final CompileContext myContext;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.compiler.GroovycOSProcessHandler");
    public static final String GROOVY_COMPILER_IN_OPERATION = "Groovy compiler in operation...";
    private final StringBuffer outputBuffer = new StringBuffer();

    public GroovycOSProcessHandler(CompileContext context, Process process, String s) {
        super(process, s);
        this.myContext = context;
    }

    public void notifyTextAvailable(String text, Key outputType) {
        super.notifyTextAvailable(text, outputType);
        this.parseOutput(text, outputType == ProcessOutputTypes.STDERR);
    }

    private void parseOutput(String text, boolean error) {
        String trimmed;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received from groovyc: " + text);
        }
        if ((trimmed = text.trim()).startsWith("@#$%@# Presentable:")) {
            this.myContext.getProgressIndicator().setText(trimmed.substring("@#$%@# Presentable:".length()));
            return;
        }
        if ("$@#$%^ CLEAR_PRESENTABLE".equals(trimmed)) {
            this.myContext.getProgressIndicator().setText(GROOVY_COMPILER_IN_OPERATION);
            return;
        }
        if (StringUtil.isNotEmpty((String)text)) {
            this.outputBuffer.append(text);
            if (this.outputBuffer.indexOf("%%c") != -1) {
                String token;
                this.unparsedOutput.setLength(0);
                if (this.outputBuffer.indexOf("/%c") == -1) {
                    return;
                }
                text = this.handleOutputBuffer("%%c", "/%c");
                StringTokenizer tokenizer = new StringTokenizer(text, "#%%#%%%#%%%%%%%%%#", false);
                String outputPath = "";
                String sourceFile = "";
                String outputRootDirectory = "";
                if (tokenizer.hasMoreTokens()) {
                    outputPath = token = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    sourceFile = token = tokenizer.nextToken();
                }
                LocalFileSystem.getInstance().refreshAndFindFileByPath(outputPath);
                TranslatingCompiler.OutputItem item = this.getOutputItem(outputPath, sourceFile);
                if (item != null) {
                    this.myCompiledItems.add(item);
                }
            } else if (this.outputBuffer.indexOf("%%rc") != -1) {
                this.unparsedOutput.setLength(0);
                if (this.outputBuffer.indexOf("/%rc") == -1) {
                    return;
                }
                if (this.outputBuffer.indexOf("/%rc") != -1) {
                    text = this.handleOutputBuffer("%%rc", "/%rc");
                    this.myContext.getProgressIndicator().setText(text);
                    this.toRecompileFiles.add(new File(text));
                }
            } else if (this.outputBuffer.indexOf("%%m") != -1) {
                int colomnnumInt;
                int linenumInt;
                this.unparsedOutput.setLength(0);
                if (this.outputBuffer.indexOf("/%m") == -1) {
                    return;
                }
                text = this.handleOutputBuffer("%%m", "/%m");
                List tokens = StringUtil.split((String)text, (String)"#%%#%%%#%%%%%%%%%#");
                LOG.assertTrue(tokens.size() > 4, (Object)"Wrong number of output params");
                String category = (String)tokens.get(0);
                String message = (String)tokens.get(1);
                String url = (String)tokens.get(2);
                String linenum = (String)tokens.get(3);
                String colomnnum = (String)tokens.get(4);
                try {
                    linenumInt = Integer.parseInt(linenum);
                    colomnnumInt = Integer.parseInt(colomnnum);
                }
                catch (NumberFormatException e) {
                    LOG.error((Throwable)e);
                    linenumInt = 0;
                    colomnnumInt = 0;
                }
                this.myContext.getProgressIndicator().setText(url);
                this.compilerMessages.add(new CompilerMessage(category, message, url, linenumInt, colomnnumInt));
            } else {
                if (error) {
                    this.unparsedOutput.append(this.outputBuffer).append("\n");
                }
                this.outputBuffer.setLength(0);
            }
        }
    }

    private String handleOutputBuffer(String START_MARKER, String END_MARKER) {
        String text = this.outputBuffer.substring(this.outputBuffer.indexOf(START_MARKER) + START_MARKER.length(), this.outputBuffer.indexOf(END_MARKER));
        this.outputBuffer.delete(this.outputBuffer.indexOf(START_MARKER), this.outputBuffer.indexOf(END_MARKER) + END_MARKER.length());
        return text.trim();
    }

    @Nullable
    private TranslatingCompiler.OutputItem getOutputItem(final String outputPath, String sourceFile) {
        final VirtualFile sourceVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(sourceFile));
        if (sourceVirtualFile == null) {
            return null;
        }
        return new TranslatingCompiler.OutputItem(){

            public String getOutputPath() {
                return outputPath;
            }

            public VirtualFile getSourceFile() {
                return sourceVirtualFile;
            }
        };
    }

    public List<TranslatingCompiler.OutputItem> getSuccessfullyCompiled() {
        return this.myCompiledItems;
    }

    public Set<File> getToRecompileFiles() {
        return this.toRecompileFiles;
    }

    public List<CompilerMessage> getCompilerMessages() {
        return this.compilerMessages;
    }

    public StringBuffer getUnparsedOutput() {
        return this.unparsedOutput;
    }
}

