/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.constructors;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateConstructorHandler;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.constructors.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConstructorGenerateHandler
extends GenerateConstructorHandler {
    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] classMembers = super.chooseOriginalMembers(aClass, project);
        if (classMembers == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        for (ClassMember classMember : classMembers) {
            if (classMember instanceof PsiMethodMember) {
                PsiMethod method = (PsiMethod)((PsiMethodMember)classMember).getElement();
                String text = method.getText();
                try {
                    PsiMethod constructorImpl = factory.createMethodFromText(text, (PsiElement)aClass);
                    res.add(new PsiMethodMember(constructorImpl));
                }
                catch (IncorrectOperationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(classMember instanceof PsiFieldMember)) continue;
            PsiFieldMember fieldMember = (PsiFieldMember)classMember;
            PsiField field = (PsiField)fieldMember.getElement();
            try {
                PsiField fieldImpl = factory.createFieldFromText(field.getType().getCanonicalText() + " " + field.getName(), (PsiElement)aClass);
                res.add(new PsiFieldMember(fieldImpl));
            }
            catch (IncorrectOperationException e) {
                e.printStackTrace();
            }
        }
        return res.toArray(new ClassMember[res.size()]);
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List list = super.generateMemberPrototypes(aClass, members);
        ArrayList<GroovyGenerationInfo<GrMethod>> grConstructors = new ArrayList<GroovyGenerationInfo<GrMethod>>();
        for (GenerationInfo generationInfo : list) {
            PsiMember constructorMember = generationInfo.getPsiMember();
            assert (constructorMember instanceof PsiMethod);
            PsiMethod constructor = (PsiMethod)constructorMember;
            PsiCodeBlock block = constructor.getBody();
            assert (block != null);
            String constructorName = aClass.getName();
            String body = block.getText();
            PsiParameterList list1 = constructor.getParameterList();
            ArrayList<String> parametersNames = new ArrayList<String>();
            for (PsiParameter parameter : list1.getParameters()) {
                parametersNames.add(parameter.getName());
            }
            String[] paramNames = ArrayUtil.toStringArray(parametersNames);
            assert (constructorName != null);
            GrMethod grConstructor = GroovyPsiElementFactory.getInstance(aClass.getProject()).createConstructorFromText(constructorName, null, paramNames, body);
            PsiUtil.shortenReferences(grConstructor);
            GroovyGenerationInfo<GrMethod> psiGenerationInfo = new GroovyGenerationInfo<GrMethod>(grConstructor);
            grConstructors.add(psiGenerationInfo);
        }
        ArrayList<GroovyGenerationInfo<GrMethod>> arrayList = grConstructors;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/actions/generate/constructors/ConstructorGenerateHandler.generateMemberPrototypes must not return null");
        }
        return arrayList;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

