/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditorListener;
import com.intellij.uiDesigner.radComponents.RadComponent;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyEditor<V> {
    private final EventListenerList myListenerList = new EventListenerList();

    protected PropertyEditor() {
    }

    @Nullable
    public abstract V getValue() throws Exception;

    public abstract JComponent getComponent(RadComponent var1, V var2, InplaceContext var3);

    public JComponent getPreferredFocusedComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/propertyInspector/PropertyEditor.getPreferredFocusedComponent must not be null");
        }
        return null;
    }

    public abstract void updateUI();

    public final void addPropertyEditorListener(PropertyEditorListener l) {
        this.myListenerList.add(PropertyEditorListener.class, l);
    }

    public final void removePropertyEditorListener(PropertyEditorListener l) {
        this.myListenerList.remove(PropertyEditorListener.class, l);
    }

    protected final void fireEditingCancelled() {
        PropertyEditorListener[] listeners;
        for (PropertyEditorListener listener : listeners = (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener.editingCanceled(this);
        }
    }

    protected final void fireValueCommitted(boolean continueEditing, boolean closeEditorOnError) {
        PropertyEditorListener[] listeners;
        for (PropertyEditorListener listener : listeners = (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener.valueCommitted(this, continueEditing, closeEditorOnError);
        }
    }

    protected final void preferredSizeChanged() {
        PropertyEditorListener[] listeners;
        for (PropertyEditorListener listener : listeners = (PropertyEditorListener[])this.myListenerList.getListeners(PropertyEditorListener.class)) {
            listener.preferredSizeChanged(this);
        }
    }
}

