/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    @Nullable
    private final WatchNode myOldNode;

    public WatchInplaceEditor(WatchesRootNode rootNode, WatchNode node, @NonNls String historyId, @Nullable WatchNode oldNode) {
        super((XDebuggerTreeNode)((Object)node), historyId);
        this.myRootNode = rootNode;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setText(oldNode != null ? oldNode.getExpression() : "");
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myExpressionEditor.getComponent();
    }

    @Override
    public void cancelEditing() {
        super.cancelEditing();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (this.myOldNode != null) {
            this.getWatchesView().addWatchExpression(this.myOldNode.getExpression(), index);
        }
    }

    @Override
    public void doOKAction() {
        String expression = this.myExpressionEditor.getText();
        this.myExpressionEditor.saveTextInHistory();
        super.doOKAction();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (!StringUtil.isEmpty((String)expression)) {
            this.getWatchesView().addWatchExpression(expression, index);
        }
    }

    private XWatchesView getWatchesView() {
        XDebugSessionTab tab = ((XDebugSessionImpl)this.myRootNode.getTree().getSession()).getSessionTab();
        return tab.getWatchesView();
    }
}

