/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointUtil {
    private XBreakpointUtil() {
    }

    public static <B extends XBreakpoint<?>> String getDisplayText(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil.getDisplayText must not be null");
        }
        return XBreakpointUtil.getType(breakpoint).getDisplayText(breakpoint);
    }

    public static <B extends XBreakpoint<?>> XBreakpointType<B, ?> getType(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil.getType must not be null");
        }
        return breakpoint.getType();
    }

    @Nullable
    public static XBreakpointType<?, ?> findType(@NotNull @NonNls String id) {
        XBreakpointType<?, ?>[] breakpointTypes;
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/XBreakpointUtil.findType must not be null");
        }
        for (XBreakpointType<?, ?> breakpointType : breakpointTypes = XBreakpointUtil.getBreakpointTypes()) {
            if (!id.equals(breakpointType.getId())) continue;
            return breakpointType;
        }
        return null;
    }

    public static XBreakpointType<?, ?>[] getBreakpointTypes() {
        return (XBreakpointType[])Extensions.getExtensions((ExtensionPointName)XBreakpointType.EXTENSION_POINT_NAME);
    }
}

