/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntegerKeyProvider
implements ByteBufferMap.KeyProvider<Integer> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.StringKeyProvider");
    public static final IntegerKeyProvider INSTANCE = new IntegerKeyProvider();

    private IntegerKeyProvider() {
    }

    @Override
    public int hashCode(Integer key) {
        return key.hashCode();
    }

    @Override
    public void write(DataOutput out, Integer key) throws IOException {
        out.writeInt(key);
    }

    @Override
    public int length(Integer key) {
        return 4;
    }

    @Override
    public Integer get(DataInput in) throws IOException {
        return new Integer(in.readInt());
    }

    @Override
    public boolean equals(DataInput in, Integer key) throws IOException {
        return key.intValue() == in.readInt();
    }
}

