/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolProcessAdapter;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class Tool
implements SchemeElement {
    @NonNls
    public static final String ACTION_ID_PREFIX = "Tool_";
    private String myName;
    private String myDescription;
    private String myGroup;
    private boolean myShownInMainMenu;
    private boolean myShownInEditor;
    private boolean myShownInProjectViews;
    private boolean myShownInSearchResultsPopup;
    private boolean myEnabled;
    private boolean myUseConsole;
    private boolean mySynchronizeAfterExecution;
    private String myWorkingDirectory;
    private String myProgram;
    private String myParameters;
    private ArrayList<FilterInfo> myOutputFilters = new ArrayList();

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public boolean isShownInMainMenu() {
        return this.myShownInMainMenu;
    }

    public boolean isShownInEditor() {
        return this.myShownInEditor;
    }

    public boolean isShownInProjectViews() {
        return this.myShownInProjectViews;
    }

    public boolean isShownInSearchResultsPopup() {
        return this.myShownInSearchResultsPopup;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isUseConsole() {
        return this.myUseConsole;
    }

    public boolean synchronizeAfterExecution() {
        return this.mySynchronizeAfterExecution;
    }

    void setName(String name) {
        this.myName = name;
    }

    void setDescription(String description) {
        this.myDescription = description;
    }

    void setGroup(String group) {
        this.myGroup = group;
    }

    void setShownInMainMenu(boolean shownInMainMenu) {
        this.myShownInMainMenu = shownInMainMenu;
    }

    void setShownInEditor(boolean shownInEditor) {
        this.myShownInEditor = shownInEditor;
    }

    void setShownInProjectViews(boolean shownInProjectViews) {
        this.myShownInProjectViews = shownInProjectViews;
    }

    public void setShownInSearchResultsPopup(boolean shownInSearchResultsPopup) {
        this.myShownInSearchResultsPopup = shownInSearchResultsPopup;
    }

    void setUseConsole(boolean useConsole) {
        this.myUseConsole = useConsole;
    }

    public void setFilesSynchronizedAfterRun(boolean synchronizeAfterRun) {
        this.mySynchronizeAfterExecution = synchronizeAfterRun;
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = program;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(String parameters) {
        this.myParameters = parameters;
    }

    public void addOutputFilter(FilterInfo filter) {
        this.myOutputFilters.add(filter);
    }

    public void setOutputFilters(FilterInfo[] filters) {
        this.myOutputFilters = new ArrayList();
        for (int i = 0; i < filters.length; ++i) {
            this.myOutputFilters.add(filters[i]);
        }
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters.toArray(new FilterInfo[this.myOutputFilters.size()]);
    }

    public void copyFrom(Tool source) {
        this.myName = source.myName;
        this.myDescription = source.myDescription;
        this.myGroup = source.myGroup;
        this.myShownInMainMenu = source.myShownInMainMenu;
        this.myShownInEditor = source.myShownInEditor;
        this.myShownInProjectViews = source.myShownInProjectViews;
        this.myShownInSearchResultsPopup = source.myShownInSearchResultsPopup;
        this.myEnabled = source.myEnabled;
        this.myUseConsole = source.myUseConsole;
        this.mySynchronizeAfterExecution = source.mySynchronizeAfterExecution;
        this.myWorkingDirectory = source.myWorkingDirectory;
        this.myProgram = source.myProgram;
        this.myParameters = source.myParameters;
        this.myOutputFilters = (ArrayList)source.myOutputFilters.clone();
    }

    public boolean equals(Object obj) {
        Tool secondTool;
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool source = secondTool = (Tool)obj;
        return Comparing.equal((String)this.myName, (String)source.myName) && Comparing.equal((String)this.myDescription, (String)source.myDescription) && Comparing.equal((String)this.myGroup, (String)source.myGroup) && this.myShownInMainMenu == source.myShownInMainMenu && this.myShownInEditor == source.myShownInEditor && this.myShownInProjectViews == source.myShownInProjectViews && this.myShownInSearchResultsPopup == source.myShownInSearchResultsPopup && this.myEnabled == source.myEnabled && this.myUseConsole == source.myUseConsole && this.mySynchronizeAfterExecution == source.mySynchronizeAfterExecution && Comparing.equal((String)this.myWorkingDirectory, (String)source.myWorkingDirectory) && Comparing.equal((String)this.myProgram, (String)source.myProgram) && Comparing.equal((String)this.myParameters, (String)source.myParameters) && Comparing.equal(this.myOutputFilters, source.myOutputFilters);
    }

    public String getActionId() {
        StringBuffer name = new StringBuffer(ACTION_ID_PREFIX);
        if (this.myGroup != null) {
            name.append(this.myGroup);
            name.append('_');
        }
        if (this.myName != null) {
            name.append(this.myName);
        }
        return name.toString();
    }

    public void execute(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            if (this.isUseConsole()) {
                ToolRunProfile profile = new ToolRunProfile(this, dataContext);
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)profile);
                assert (runner != null);
                runner.execute((Executor)new DefaultRunExecutor(), new ExecutionEnvironment((RunProfile)profile, dataContext));
            } else {
                GeneralCommandLine commandLine = this.createCommandLine(dataContext);
                if (commandLine == null) {
                    return;
                }
                OSProcessHandler handler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString());
                handler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, this.synchronizeAfterExecution(), this.getName()));
                handler.startNotify();
            }
        }
        catch (ExecutionException ex) {
            ExecutionErrorDialog.show((ExecutionException)ex, (String)ToolsBundle.message("tools.process.start.error", new Object[0]), (Project)project);
        }
    }

    GeneralCommandLine createCommandLine(DataContext dataContext) {
        if (this.getWorkingDirectory() != null && this.getWorkingDirectory().trim().length() == 0) {
            this.setWorkingDirectory(null);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        try {
            String paramString = MacroManager.getInstance().expandMacrosInString(this.getParameters(), true, dataContext);
            String workingDir = MacroManager.getInstance().expandMacrosInString(this.getWorkingDirectory(), true, dataContext);
            String exePath = MacroManager.getInstance().expandMacrosInString(this.getProgram(), true, dataContext);
            commandLine.getParametersList().addParametersString(MacroManager.getInstance().expandMacrosInString(paramString, false, dataContext));
            commandLine.setWorkDirectory(MacroManager.getInstance().expandMacrosInString(workingDir, false, dataContext));
            exePath = MacroManager.getInstance().expandMacrosInString(exePath, false, dataContext);
            if (exePath == null) {
                return null;
            }
            commandLine.setExePath(exePath);
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
        return commandLine;
    }

    public void setGroupName(String name) {
        this.setGroup(name);
    }

    public String getKey() {
        return this.getName();
    }

    public SchemeElement copy() {
        Tool copy = new Tool();
        copy.copyFrom(this);
        return copy;
    }
}

