/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Function;
import java.util.Collection;
import junit.framework.Assert;

public class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode kid, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        VirtualFile[] result;
        if (kid instanceof BasePsiNode) {
            Object value = kid.getValue();
            VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)value));
            return new VirtualFile[]{virtualFile};
        }
        if (converterFunction != null && (result = (VirtualFile[])converterFunction.fun((Object)kid)) != null) {
            return result;
        }
        return new VirtualFile[0];
    }

    public static void collect(AbstractTreeNode node, MultiValuesMap<VirtualFile, AbstractTreeNode> map, AbstractTreeStructure structure, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements((Object)node)) {
            VirtualFile[] files;
            ProjectViewNode kid = (ProjectViewNode)kid1;
            for (VirtualFile vFile : files = ProjectViewTestUtil.getFiles((AbstractTreeNode)kid, converterFunction)) {
                map.put((Object)vFile, (Object)kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map.put((Object)vFile, (Object)eachParent);
                }
            }
            ProjectViewTestUtil.collect((AbstractTreeNode)kid, map, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<AbstractTreeNode, VirtualFile[]> converterFunction) {
        MultiValuesMap map = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, (MultiValuesMap<VirtualFile, AbstractTreeNode>)map, structure, converterFunction);
        for (VirtualFile eachFile : map.keySet()) {
            Collection nodes = map.values();
            for (AbstractTreeNode node : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map.get((Object)eachFile).contains(eachNode))) continue;
                Assert.assertTrue((String)("file=" + eachFile + " node=" + eachNode.getTestPresentation() + " expected:" + expected), (boolean)false);
            }
        }
    }
}

