/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.RefactoringUtil");
    public static final int EXPR_COPY_SAFE = 0;
    public static final int EXPR_COPY_UNSAFE = 1;
    public static final int EXPR_COPY_PROHIBITED = 2;

    private RefactoringUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory directory) {
        if (directory.getManager() == null) {
            return false;
        }
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        return Comparing.equal((Object)virtualFile, (Object)sourceRootForFile);
    }

    public static boolean isInStaticContext(PsiElement element, PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    public static boolean isResolvableType(PsiType type) {
        return (Boolean)type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return Boolean.TRUE;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitClassType(PsiClassType classType) {
                PsiType[] parameters;
                if (classType.resolve() == null) {
                    return Boolean.FALSE;
                }
                for (PsiType parameter : parameters = classType.getParameters()) {
                    if (parameter == null || ((Boolean)parameter.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                if (wildcardType.getBound() != null) {
                    return (Boolean)wildcardType.getBound().accept((PsiTypeVisitor)this);
                }
                return Boolean.TRUE;
            }
        });
    }

    public static PsiElement replaceOccurenceWithFieldRef(PsiExpression occurrence, PsiField newField, PsiClass destinationClass) throws IncorrectOperationException {
        PsiManager manager = destinationClass.getManager();
        String fieldName = newField.getName();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElement element = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
        PsiVariable psiVariable = facade.getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)(element != null ? element : occurrence));
        PsiElementFactory factory = facade.getElementFactory();
        if (psiVariable != null && psiVariable.equals(newField)) {
            return IntroduceVariableBase.replace(occurrence, factory.createExpressionFromText(fieldName, null), manager.getProject());
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText("this." + fieldName, null);
        if (!occurrence.isValid()) {
            return null;
        }
        if (newField.hasModifierProperty("static")) {
            ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(destinationClass));
        }
        return IntroduceVariableBase.replace(occurrence, (PsiExpression)ref, manager.getProject());
    }

    public static String suggestUniqueVariableName(String baseName, PsiElement place, PsiField fieldToReplace) {
        String name;
        int index = 0;
        while (true) {
            class CancelException
            extends RuntimeException {
                CancelException() {
                }
            }
            name = index > 0 ? baseName + index : baseName;
            ++index;
            PsiManager manager = place.getManager();
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper();
            PsiVariable refVar = helper.resolveReferencedVariable(name, place);
            if (refVar != null && !manager.areElementsEquivalent((PsiElement)refVar, (PsiElement)fieldToReplace)) continue;
            try {
                place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name.equals(variable.getName())) {
                            throw new CancelException();
                        }
                    }
                });
            }
            catch (CancelException e) {
                continue;
            }
            break;
        }
        return name;
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, new Comparator<UsageInfo>(){

            @Override
            public int compare(UsageInfo usage1, UsageInfo usage2) {
                PsiElement element1 = usage1.getElement();
                PsiElement element2 = usage2.getElement();
                if (element1 == null || element2 == null) {
                    return 0;
                }
                return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
            }
        });
    }

    @Nullable
    public static String suggestNewOverriderName(String oldOverriderName, String oldBaseName, String newBaseName) {
        if (oldOverriderName.equals(oldBaseName)) {
            return newBaseName;
        }
        int i = oldOverriderName.startsWith(oldBaseName) ? 0 : StringUtil.indexOfIgnoreCase((String)oldOverriderName, (String)oldBaseName, (int)0);
        if (i >= 0) {
            String newOverriderName = oldOverriderName.substring(0, i);
            newOverriderName = Character.isUpperCase(oldOverriderName.charAt(i)) ? newOverriderName + StringUtil.capitalize((String)newBaseName) : newOverriderName + newBaseName;
            int j = i + oldBaseName.length();
            if (j < oldOverriderName.length()) {
                newOverriderName = newOverriderName + oldOverriderName.substring(j);
            }
            return newOverriderName;
        }
        return null;
    }

    public static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        PsiImportList importList;
        if (element.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)element.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                if (!stmt.isOnDemand() || stmt.resolveTargetClass() != aClass) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                if (stmt.isOnDemand() || stmt.resolveTargetClass() != member.getContainingClass() || !Comparing.strEqual((String)stmt.getReferenceName(), (String)member.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiElement replaceElementsWithMap(PsiElement replaceIn, Map<PsiElement, PsiElement> elementsToReplace) throws IncorrectOperationException {
        for (Map.Entry<PsiElement, PsiElement> e : elementsToReplace.entrySet()) {
            if (e.getKey() == replaceIn) {
                return e.getKey().replace(e.getValue());
            }
            e.getKey().replace(e.getValue());
        }
        return replaceIn;
    }

    public static PsiElement getVariableScope(PsiLocalVariable localVar) {
        if (!(localVar instanceof ImplicitVariable)) {
            return localVar.getParent().getParent();
        }
        return ((ImplicitVariable)localVar).getDeclarationScope();
    }

    public static PsiReturnStatement[] findReturnStatements(PsiMethod method) {
        ArrayList<PsiReturnStatement> vector = new ArrayList<PsiReturnStatement>();
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            RefactoringUtil.addReturnStatements(vector, (PsiElement)body);
        }
        return vector.toArray(new PsiReturnStatement[vector.size()]);
    }

    private static void addReturnStatements(ArrayList<PsiReturnStatement> vector, PsiElement element) {
        if (element instanceof PsiReturnStatement) {
            vector.add((PsiReturnStatement)element);
        } else if (!(element instanceof PsiClass)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                RefactoringUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static PsiElement getParentStatement(PsiElement place, boolean skipScopingStatements) {
        PsiElement parent = place;
        while (!(parent instanceof PsiStatement)) {
            if ((parent = parent.getParent()) != null) continue;
            return null;
        }
        PsiElement parentStatement = parent;
        PsiElement psiElement = parent = parentStatement instanceof PsiStatement ? parentStatement : parentStatement.getParent();
        while (parent instanceof PsiStatement) {
            if (!skipScopingStatements && (parent instanceof PsiForStatement && parentStatement == ((PsiForStatement)parent).getBody() || parent instanceof PsiForeachStatement && parentStatement == ((PsiForeachStatement)parent).getBody() || parent instanceof PsiWhileStatement && parentStatement == ((PsiWhileStatement)parent).getBody() || parent instanceof PsiIfStatement && (parentStatement == ((PsiIfStatement)parent).getThenBranch() || parentStatement == ((PsiIfStatement)parent).getElseBranch()))) {
                return parentStatement;
            }
            parentStatement = parent;
            parent = parent.getParent();
        }
        return parentStatement;
    }

    public static PsiElement getParentExpressionAnchorElement(PsiElement place) {
        PsiElement parent = (PsiElement)place.getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = place;
        }
        do {
            if (!RefactoringUtil.isExpressionAnchorElement(parent)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static boolean isExpressionAnchorElement(PsiElement element) {
        return element instanceof PsiStatement || element instanceof PsiClassInitializer || element instanceof PsiField || element instanceof PsiMethod;
    }

    public static PsiElement getLoopForLoopCondition(PsiExpression expression) {
        PsiExpression outermost = expression;
        while (outermost.getParent() instanceof PsiExpression) {
            outermost = (PsiExpression)outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent();
            if (forStatement.getCondition() == outermost) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiExpressionStatement && outermost.getParent().getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent().getParent();
            if (forStatement.getUpdate() == outermost.getParent()) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiWhileStatement) {
            return outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiDoWhileStatement) {
            return outermost.getParent();
        }
        return null;
    }

    public static PsiClass getThisClass(PsiElement place) {
        PsiElement parent = place.getContext();
        if (parent == null) {
            return null;
        }
        PsiElement prev = null;
        do {
            if (parent instanceof PsiClass && (!(parent instanceof PsiAnonymousClass) || ((PsiAnonymousClass)parent).getArgumentList() != prev)) {
                return (PsiClass)parent;
            }
            prev = parent;
        } while ((parent = parent.getContext()) != null);
        return null;
    }

    public static PsiClass getThisResolveClass(PsiReferenceExpression place) {
        JavaResolveResult resolveResult = place.advancedResolve(false);
        PsiElement scope = resolveResult.getCurrentFileResolveScope();
        if (scope instanceof PsiClass) {
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiCall getEnclosingConstructorCall(PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        if (ref instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
            return (PsiCall)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        return parent instanceof PsiNewExpression ? (PsiNewExpression)parent : null;
    }

    public static PsiMethod getEnclosingMethod(PsiElement element) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        return container instanceof PsiMethod ? (PsiMethod)container : null;
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope) throws IncorrectOperationException {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope)) {
            reference.handleElementRename(newName);
        }
    }

    public static boolean canBeDeclaredFinal(PsiVariable variable) {
        LOG.assertTrue(variable instanceof PsiLocalVariable || variable instanceof PsiParameter);
        boolean isReassigned = HighlightControlFlowUtil.isReassigned(variable, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)new THashMap(), (Map<PsiParameter, Boolean>)new THashMap());
        return !isReassigned;
    }

    public static PsiThisExpression createThisExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (qualifierClass != null) {
            PsiThisExpression qualifiedThis = (PsiThisExpression)factory.createExpressionFromText("q.this", null);
            qualifiedThis = (PsiThisExpression)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)qualifiedThis);
            PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
            LOG.assertTrue(thisQualifier != null);
            thisQualifier.bindToElement((PsiElement)qualifierClass);
            return qualifiedThis;
        }
        return (PsiThisExpression)factory.createExpressionFromText("this", null);
    }

    public static PsiJavaCodeReferenceElement removeFromReferenceList(PsiReferenceList refList, PsiClass aClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            PsiJavaCodeReferenceElement refCopy = (PsiJavaCodeReferenceElement)ref.copy();
            ref.delete();
            return refCopy;
        }
        return null;
    }

    public static PsiJavaCodeReferenceElement findReferenceToClass(PsiReferenceList refList, PsiClass aClass) {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            return ref;
        }
        return null;
    }

    public static PsiType getTypeByExpressionWithExpectedType(PsiExpression expr) {
        PsiType type = RefactoringUtil.getTypeByExpression(expr);
        if (type != null) {
            return type;
        }
        ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getInstance(expr.getProject()).getExpectedTypes(expr, false);
        if (expectedTypes.length == 1 && !(type = expectedTypes[0].getType()).equalsToText("java.lang.Object")) {
            return type;
        }
        return null;
    }

    public static PsiType getTypeByExpression(PsiExpression expr) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        return RefactoringUtil.getTypeByExpression(expr, factory);
    }

    private static PsiType getTypeByExpression(PsiExpression expr, PsiElementFactory factory) {
        Object type = expr.getType();
        if (type == null) {
            PsiExpression[] initializers;
            if (expr instanceof PsiArrayInitializerExpression && (initializers = ((PsiArrayInitializerExpression)expr).getInitializers()).length > 0) {
                PsiType initType = RefactoringUtil.getTypeByExpression(initializers[0]);
                if (initType == null) {
                    return null;
                }
                return initType.createArrayType();
            }
            return null;
        }
        PsiClass refClass = PsiUtil.resolveClassInType((PsiType)type);
        if (refClass instanceof PsiAnonymousClass) {
            type = ((PsiAnonymousClass)refClass).getBaseClassType();
        }
        if (PsiType.NULL.equals(type)) {
            ExpectedTypeInfo[] infos = ExpectedTypesProvider.getInstance(expr.getProject()).getExpectedTypes(expr, false);
            type = infos.length == 1 ? infos[0].getType() : factory.createTypeByFQClassName("java.lang.Object", expr.getResolveScope());
        }
        return GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
    }

    public static boolean isAssignmentLHS(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof PsiAssignmentExpression && element.equals(((PsiAssignmentExpression)parent).getLExpression()) || RefactoringUtil.isPlusPlusOrMinusMinus(parent);
    }

    public static boolean isPlusPlusOrMinusMinus(PsiElement element) {
        if (element instanceof PsiPrefixExpression) {
            PsiJavaToken operandSign = ((PsiPrefixExpression)element).getOperationSign();
            return operandSign.getTokenType() == JavaTokenType.PLUSPLUS || operandSign.getTokenType() == JavaTokenType.MINUSMINUS;
        }
        if (element instanceof PsiPostfixExpression) {
            IElementType operandTokenType = ((PsiPostfixExpression)element).getOperationTokenType();
            return operandTokenType == JavaTokenType.PLUSPLUS || operandTokenType == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    private static void removeFinalParameters(PsiMethod method) throws IncorrectOperationException {
        PsiParameter[] params;
        PsiParameterList paramList = method.getParameterList();
        for (PsiParameter param : params = paramList.getParameters()) {
            if (!param.hasModifierProperty("final")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
        }
    }

    public static PsiElement getAnchorElementForMultipleExpressions(PsiExpression[] occurrences, PsiElement scope) {
        PsiSwitchStatement switchStatement;
        PsiElement anchor = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement firstAnchor;
            if (scope != null && !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)occurrence, (boolean)false)) continue;
            PsiElement anchor1 = RefactoringUtil.getParentExpressionAnchorElement((PsiElement)occurrence);
            if (anchor1 == null) {
                return null;
            }
            if (anchor == null) {
                anchor = anchor1;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)anchor, (PsiElement)anchor1);
            if (commonParent == null || anchor.getTextRange() == null || anchor1.getTextRange() == null) {
                return null;
            }
            PsiElement psiElement = firstAnchor = anchor.getTextRange().getStartOffset() < anchor1.getTextRange().getStartOffset() ? anchor : anchor1;
            if (commonParent.equals(firstAnchor)) {
                anchor = firstAnchor;
                continue;
            }
            if (commonParent instanceof PsiStatement) {
                anchor = commonParent;
                continue;
            }
            PsiElement parent = firstAnchor;
            while (!parent.getParent().equals(commonParent)) {
                parent = parent.getParent();
            }
            PsiElement newAnchor = RefactoringUtil.getParentExpressionAnchorElement(parent);
            anchor = newAnchor != null ? newAnchor : parent;
        }
        if (occurrences.length > 1 && anchor.getParent().getParent() instanceof PsiSwitchStatement && (switchStatement = (PsiSwitchStatement)anchor.getParent().getParent()).getBody().equals(anchor.getParent())) {
            int startOffset = occurrences[0].getTextRange().getStartOffset();
            int endOffset = occurrences[occurrences.length - 1].getTextRange().getEndOffset();
            PsiStatement[] statements = switchStatement.getBody().getStatements();
            boolean isInDifferentCases = false;
            for (PsiStatement statement : statements) {
                int caseOffset;
                if (!(statement instanceof PsiSwitchLabelStatement) || startOffset >= (caseOffset = statement.getTextRange().getStartOffset()) || caseOffset >= endOffset) continue;
                isInDifferentCases = true;
                break;
            }
            if (isInDifferentCases) {
                anchor = switchStatement;
            }
        }
        return anchor;
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof PsiEnumConstant) {
            return true;
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCall) {
            return true;
        }
        if (parent instanceof PsiAnonymousClass) {
            return element.equals(((PsiAnonymousClass)parent).getBaseClassReference());
        }
        return false;
    }

    public static PsiExpressionList getArgumentListByMethodReference(PsiElement ref) {
        if (ref instanceof PsiEnumConstant) {
            return ((PsiEnumConstant)ref).getArgumentList();
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiNewExpression)parent.getParent()).getArgumentList();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static PsiCall getCallExpressionByMethodReference(PsiElement ref) {
        if (ref instanceof PsiEnumConstant) {
            return (PsiCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        if (parent instanceof PsiNewExpression) {
            return (PsiNewExpression)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            return (PsiNewExpression)parent.getParent();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static List<RangeHighlighter> highlightAllOccurences(Project project, PsiElement[] occurences, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (occurences.length > 1) {
            for (PsiElement occurrence : occurences) {
                RangeMarker rangeMarker = (RangeMarker)occurrence.getUserData(ElementToWorkOn.TEXT_RANGE);
                if (rangeMarker != null) {
                    highlightManager.addRangeHighlight(editor, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), attributes, true, highlighters);
                    continue;
                }
                TextRange textRange = occurrence.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, highlighters);
            }
        }
        return highlighters;
    }

    public static String createTempVar(PsiExpression expr, PsiElement context, boolean declareFinal) throws IncorrectOperationException {
        PsiExpression expr1;
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(context, true);
        LOG.assertTrue(anchorStatement != null && anchorStatement.getParent() != null);
        Project project = expr.getProject();
        String[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, (PsiExpression)expr, null).names;
        String prefix = suggestedNames[0];
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, context, true);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        if (expr instanceof PsiParenthesizedExpression && (expr1 = ((PsiParenthesizedExpression)expr).getExpression()) != null) {
            expr = expr1;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(id, expr.getType(), expr);
        if (declareFinal) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)decl.getDeclaredElements()[0]), (String)"final", (boolean)true);
        }
        anchorStatement.getParent().addBefore((PsiElement)decl, anchorStatement);
        return id;
    }

    public static int verifySafeCopyExpression(PsiElement expr) {
        return RefactoringUtil.verifySafeCopyExpressionSubElement(expr);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiIdentifier) {
            return 0;
        }
        if (element instanceof PsiMethodCallExpression) {
            result = 1;
        }
        if (element instanceof PsiNewExpression) {
            return 2;
        }
        if (element instanceof PsiAssignmentExpression) {
            return 2;
        }
        if (RefactoringUtil.isPlusPlusOrMinusMinus(element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = RefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    public static PsiExpression convertInitializerToNormalExpression(PsiExpression expression, PsiType forcedReturnType) throws IncorrectOperationException {
        if (expression instanceof PsiArrayInitializerExpression) {
            return RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)expression, forcedReturnType);
        }
        return expression;
    }

    private static PsiExpression createNewExpressionFromArrayInitializer(PsiArrayInitializerExpression initializer, PsiType forcedType) throws IncorrectOperationException {
        PsiType initializerType = null;
        if (initializer != null) {
            initializerType = forcedType != null ? forcedType : RefactoringUtil.getTypeByExpression((PsiExpression)initializer);
        }
        if (initializerType == null) {
            return initializer;
        }
        LOG.assertTrue(initializerType instanceof PsiArrayType);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)initializer.getProject()).getElementFactory();
        PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + initializerType.getPresentableText() + "{}", null);
        result = (PsiNewExpression)CodeStyleManager.getInstance((Project)initializer.getProject()).reformat((PsiElement)result);
        PsiArrayInitializerExpression arrayInitializer = result.getArrayInitializer();
        LOG.assertTrue(arrayInitializer != null);
        arrayInitializer.replace((PsiElement)initializer);
        return result;
    }

    public static void abstractizeMethod(PsiClass targetClass, PsiMethod method) throws IncorrectOperationException {
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            body.delete();
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"final", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"synchronized", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"native", (boolean)false);
        if (!targetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)targetClass, (String)"abstract", (boolean)true);
        }
        RefactoringUtil.removeFinalParameters(method);
    }

    public static boolean isInsideAnonymous(PsiElement element, PsiElement upTo) {
        for (PsiElement current = element; current != null && current != upTo; current = current.getParent()) {
            if (!(current instanceof PsiAnonymousClass)) continue;
            return true;
        }
        return false;
    }

    public static PsiExpression unparenthesizeExpression(PsiExpression expression) {
        while (expression instanceof PsiParenthesizedExpression) {
            PsiExpression innerExpression = ((PsiParenthesizedExpression)expression).getExpression();
            if (innerExpression == null) {
                return expression;
            }
            expression = innerExpression;
        }
        return expression;
    }

    public static PsiExpression outermostParenthesizedExpression(PsiExpression expression) {
        while (expression.getParent() instanceof PsiParenthesizedExpression) {
            expression = (PsiParenthesizedExpression)expression.getParent();
        }
        return expression;
    }

    public static String getNewInnerClassName(PsiClass aClass, String oldInnerClassName, String newName) {
        if (!oldInnerClassName.endsWith(aClass.getName())) {
            return newName;
        }
        StringBuilder buffer = new StringBuilder(oldInnerClassName);
        buffer.replace(buffer.length() - aClass.getName().length(), buffer.length(), newName);
        return buffer.toString();
    }

    public static boolean isSuperOrThisCall(PsiStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression();
        if (testForSuper && "super".equals(methodExpression.getText())) {
            return true;
        }
        return testForThis && "this".equals(methodExpression.getText());
    }

    public static void visitImplicitSuperConstructorUsages(PsiClass subClass, ImplicitConstructorUsageVisitor implicitConstructorUsageVistor, PsiClass superClass) {
        PsiMethod baseDefaultConstructor = RefactoringUtil.findDefaultConstructor(superClass);
        PsiMethod[] constructors = subClass.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                PsiStatement[] statements = constructor.getBody().getStatements();
                if (statements.length >= 1 && RefactoringUtil.isSuperOrThisCall(statements[0], true, true)) continue;
                implicitConstructorUsageVistor.visitConstructor(constructor, baseDefaultConstructor);
            }
        } else {
            implicitConstructorUsageVistor.visitClassWithoutConstructors(subClass);
        }
    }

    private static PsiMethod findDefaultConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Set<T> transitiveClosure(Graph<T> graph, Condition<T> initialRelation) {
        boolean anyChanged;
        HashSet result = new HashSet();
        Set<T> vertices = graph.getVertices();
        do {
            anyChanged = false;
            block1: for (T currentVertex : vertices) {
                if (result.contains(currentVertex)) continue;
                if (!initialRelation.value(currentVertex)) {
                    Set<T> targets = graph.getTargets(currentVertex);
                    for (T currentTarget : targets) {
                        if (!result.contains(currentTarget) && !initialRelation.value(currentTarget)) continue;
                        result.add(currentVertex);
                        anyChanged = true;
                        continue block1;
                    }
                    continue;
                }
                result.add(currentVertex);
            }
        } while (anyChanged);
        return result;
    }

    public static boolean equivalentTypes(PsiType t1, PsiType t2, PsiManager manager) {
        while (t1 instanceof PsiArrayType) {
            if (!(t2 instanceof PsiArrayType)) {
                return false;
            }
            t1 = ((PsiArrayType)t1).getComponentType();
            t2 = ((PsiArrayType)t2).getComponentType();
        }
        if (t1 instanceof PsiPrimitiveType) {
            return t2 instanceof PsiPrimitiveType && t1.equals(t2);
        }
        return manager.areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)t1), (PsiElement)PsiUtil.resolveClassInType((PsiType)t2));
    }

    public static List<PsiVariable> collectReferencedVariables(PsiElement scope) {
        final ArrayList<PsiVariable> result = new ArrayList<PsiVariable>();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiExpression qualifier;
                PsiElement element = expression.resolve();
                if (element instanceof PsiVariable) {
                    result.add((PsiVariable)element);
                }
                if ((qualifier = expression.getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
            }
        });
        return result;
    }

    public static boolean isModifiedInScope(PsiVariable variable, PsiElement scope) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope), (boolean)false)) {
            if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
            return true;
        }
        return false;
    }

    private static String getNameOfReferencedParameter(PsiDocTag tag) {
        LOG.assertTrue("param".equals(tag.getName()));
        PsiElement[] dataElements = tag.getDataElements();
        if (dataElements.length < 1) {
            return null;
        }
        return dataElements[0].getText();
    }

    public static void fixJavadocsForParams(PsiMethod method, Set<PsiParameter> newParameters) throws IncorrectOperationException {
        PsiDocComment docComment = method.getDocComment();
        if (docComment == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiDocTag[] paramTags = docComment.findTagsByName("param");
        if (parameters.length > 0 && newParameters.size() < parameters.length && paramTags.length == 0) {
            return;
        }
        HashMap tagForParam = new HashMap();
        for (PsiParameter parameter : parameters) {
            boolean found = false;
            for (PsiDocTag paramTag : paramTags) {
                if (!parameter.getName().equals(RefactoringUtil.getNameOfReferencedParameter(paramTag))) continue;
                tagForParam.put(parameter, paramTag);
                found = true;
                break;
            }
            if (found || newParameters.contains(parameter)) continue;
            tagForParam.put(parameter, null);
        }
        ArrayList<PsiDocTag> newTags = new ArrayList<PsiDocTag>();
        for (PsiParameter parameter : parameters) {
            if (tagForParam.containsKey(parameter)) {
                PsiDocTag psiDocTag = (PsiDocTag)tagForParam.get(parameter);
                if (psiDocTag == null) continue;
                newTags.add((PsiDocTag)psiDocTag.copy());
                continue;
            }
            newTags.add(JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createParamTag(parameter.getName(), ""));
        }
        PsiDocTag anchor = paramTags.length > 0 ? paramTags[paramTags.length - 1] : null;
        for (PsiDocTag psiDocTag : newTags) {
            anchor = (PsiDocTag)docComment.addAfter((PsiElement)psiDocTag, (PsiElement)anchor);
        }
        for (PsiDocTag paramTag : paramTags) {
            paramTag.delete();
        }
    }

    public static PsiDirectory createPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) throws IncorrectOperationException {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        String qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                subdirectory = current.createSubdirectory(shortName);
            }
            current = subdirectory;
        }
        return current;
    }

    public static String qNameToCreateInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) throws IncorrectOperationException {
        String targetQName = aPackage.getQualifiedName();
        String sourceRootPackage = ProjectRootManager.getInstance((Project)aPackage.getManager().getProject()).getFileIndex().getPackageNameByDirectory(sourceRoot);
        if (!RefactoringUtil.canCreateInSourceRoot(sourceRootPackage, targetQName)) {
            throw new IncorrectOperationException("Cannot create package '" + targetQName + "' in source folder " + sourceRoot.getPresentableUrl());
        }
        String result = targetQName.substring(sourceRootPackage.length());
        if (StringUtil.startsWithChar((CharSequence)result, (char)'.')) {
            result = result.substring(1);
        }
        return result;
    }

    public static boolean canCreateInSourceRoot(String sourceRootPackage, String targetQName) {
        if (sourceRootPackage == null || !targetQName.startsWith(sourceRootPackage)) {
            return false;
        }
        if (sourceRootPackage.length() == 0 || targetQName.length() == sourceRootPackage.length()) {
            return true;
        }
        return targetQName.charAt(sourceRootPackage.length()) == '.';
    }

    @Nullable
    public static PsiDirectory findPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) {
        String qNameToCreate;
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        try {
            qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                return null;
            }
            current = subdirectory;
        }
        return current;
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/RefactoringUtil.createTypeParameterListWithUsedTypeParameters must not be null");
        }
        return RefactoringUtil.createTypeParameterListWithUsedTypeParameters(null, elements);
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(PsiTypeParameterList fromList, PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/RefactoringUtil.createTypeParameterListWithUsedTypeParameters must not be null");
        }
        if (elements.length == 0) {
            return null;
        }
        HashSet used = new HashSet();
        for (final PsiElement element : elements) {
            if (element == null) continue;
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)used){
                final /* synthetic */ Set val$used;
                {
                    this.val$used = set;
                }

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiTypeParameter typeParameter;
                    PsiElement resolved;
                    super.visitReferenceElement(reference);
                    if (!reference.isQualified() && (resolved = reference.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)(typeParameter = (PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)true)) {
                        this.val$used.add(typeParameter);
                    }
                }

                public void visitExpression(PsiExpression expression) {
                    super.visitExpression(expression);
                    PsiType type = expression.getType();
                    PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type);
                    if (resolved instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)((PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)true)) {
                        this.val$used.add((PsiTypeParameter)resolved);
                    }
                }
            });
        }
        if (fromList != null) {
            used.retainAll(Arrays.asList(fromList.getTypeParameters()));
        }
        PsiTypeParameter[] typeParameters = used.toArray(new PsiTypeParameter[used.size()]);
        Arrays.sort(typeParameters, new Comparator<PsiTypeParameter>(){

            @Override
            public int compare(PsiTypeParameter tp1, PsiTypeParameter tp2) {
                return tp1.getTextRange().getStartOffset() - tp2.getTextRange().getStartOffset();
            }
        });
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)elements[0].getProject()).getElementFactory();
        try {
            PsiClass aClass = elementFactory.createClassFromText("class A {}", null);
            PsiTypeParameterList list = aClass.getTypeParameterList();
            assert (list != null);
            for (PsiTypeParameter typeParameter : typeParameters) {
                list.add((PsiElement)typeParameter);
            }
            return list;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            assert (false);
            return null;
        }
    }

    public static class IsDescendantOf
    implements Condition<PsiClass> {
        private final PsiClass myClass;
        private final ConditionCache<PsiClass> myConditionCache;

        public IsDescendantOf(PsiClass aClass) {
            this.myClass = aClass;
            this.myConditionCache = new ConditionCache<PsiClass>(new Condition<PsiClass>(){

                public boolean value(PsiClass aClass) {
                    return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)IsDescendantOf.this.myClass, (boolean)true);
                }
            });
        }

        public boolean value(PsiClass aClass) {
            return this.myConditionCache.value(aClass);
        }
    }

    public static class ConditionCache<T>
    implements Condition<T> {
        private final Condition<T> myCondition;
        private final HashSet<T> myProcessedSet = new HashSet();
        private final HashSet<T> myTrueSet = new HashSet();

        public ConditionCache(Condition<T> condition) {
            this.myCondition = condition;
        }

        public boolean value(T object) {
            if (!this.myProcessedSet.contains(object)) {
                this.myProcessedSet.add(object);
                boolean value = this.myCondition.value(object);
                if (value) {
                    this.myTrueSet.add(object);
                    return true;
                }
                return false;
            }
            return this.myTrueSet.contains(object);
        }
    }

    public static interface Graph<T> {
        public Set<T> getVertices();

        public Set<T> getTargets(T var1);
    }

    public static interface ImplicitConstructorUsageVisitor {
        public void visitConstructor(PsiMethod var1, PsiMethod var2);

        public void visitClassWithoutConstructors(PsiClass var1);
    }
}

