/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.ui.RowEditableTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ParameterTableModel
extends AbstractTableModel
implements RowEditableTableModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.changeSignature.ParameterTableModel");
    private List<ParameterInfoImpl> myParameterInfos;
    private List<PsiTypeCodeFragment> myTypeCodeFraments;
    private List<JavaCodeFragment> myDefaultValuesCodeFragments;
    private final PsiParameterList myParameterList;
    private final PsiReferenceExpression myReferenceExpression;
    private final ChangeSignatureDialog myDialog;
    static final String ANY_VAR_COLUMN_NAME = RefactoringBundle.message((String)"column.name.any.var");

    public ParameterTableModel(PsiParameterList parameterList, PsiReferenceExpression ref, ChangeSignatureDialog dialog) {
        this.myParameterList = parameterList;
        this.myReferenceExpression = ref;
        this.myDialog = dialog;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 3) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public List<PsiTypeCodeFragment> getCodeFraments() {
        return Collections.unmodifiableList(this.myTypeCodeFraments);
    }

    public List<JavaCodeFragment> getDefaultValueFraments() {
        return Collections.unmodifiableList(this.myDefaultValuesCodeFragments);
    }

    public ParameterInfoImpl[] getParameters() {
        return this.myParameterInfos.toArray(new ParameterInfoImpl[this.myParameterInfos.size()]);
    }

    public void addRow() {
        ParameterInfoImpl info = new ParameterInfoImpl(-1);
        this.myParameterInfos.add(info);
        this.myTypeCodeFraments.add(this.createParameterTypeCodeFragment("", (PsiElement)this.myParameterList));
        this.myDefaultValuesCodeFragments.add(this.createDefaultValueCodeFragment("", null));
        this.fireTableRowsInserted(this.myParameterInfos.size() - 1, this.myParameterInfos.size() - 1);
    }

    public void removeRow(int index) {
        this.myParameterInfos.remove(index);
        this.myTypeCodeFraments.remove(index);
        this.myDefaultValuesCodeFragments.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void exchangeRows(int index1, int index2) {
        Collections.swap(this.myParameterInfos, index1, index2);
        Collections.swap(this.myTypeCodeFraments, index1, index2);
        Collections.swap(this.myDefaultValuesCodeFragments, index1, index2);
        if (index1 < index2) {
            this.fireTableRowsUpdated(index1, index2);
        } else {
            this.fireTableRowsUpdated(index2, index1);
        }
    }

    @Override
    public int getRowCount() {
        return this.myParameterInfos.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ParameterInfoImpl info = this.myParameterInfos.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.myTypeCodeFraments.get(rowIndex);
            }
            case 1: {
                return info.getName();
            }
            case 2: {
                return this.myDefaultValuesCodeFragments.get(rowIndex);
            }
            case 3: {
                return info.useAnySingleVariable;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String s;
        if (rowIndex < 0 || rowIndex >= this.myParameterInfos.size()) {
            return;
        }
        String string = s = aValue instanceof String ? (String)aValue : null;
        if (s == null) {
            s = "";
        }
        s = s.trim();
        ParameterInfoImpl info = this.myParameterInfos.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                info.setName(s);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                info.setUseAnySingleVariable((Boolean)aValue);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return RefactoringBundle.message((String)"column.name.type");
            }
            case 1: {
                return RefactoringBundle.message((String)"column.name.name");
            }
            case 2: {
                return RefactoringBundle.message((String)"column.name.default.value");
            }
            case 3: {
                return ANY_VAR_COLUMN_NAME;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                PsiType typeByRow = this.getTypeByRow(rowIndex);
                boolean isEllipsis = typeByRow instanceof PsiEllipsisType;
                ParameterInfoImpl info = this.myParameterInfos.get(rowIndex);
                return !isEllipsis && info.oldParameterIndex < 0;
            }
            case 3: {
                if (this.myDialog.isGenerateDelegate()) {
                    return false;
                }
                PsiType typeByRow = this.getTypeByRow(rowIndex);
                boolean isEllipsis = typeByRow instanceof PsiEllipsisType;
                return !isEllipsis && this.myParameterInfos.get((int)rowIndex).oldParameterIndex < 0;
            }
        }
        throw new IllegalArgumentException();
    }

    private JavaCodeFragment createDefaultValueCodeFragment(String expressionText, PsiType expectedType) {
        PsiExpressionCodeFragment codeFragment = JavaPsiFacade.getInstance((Project)this.myParameterList.getProject()).getElementFactory().createExpressionCodeFragment(expressionText, (PsiElement)this.myReferenceExpression, expectedType, true);
        codeFragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return codeFragment;
    }

    PsiType getTypeByRow(int row) {
        PsiType type;
        Object typeValueAt = this.getValueAt(row, 0);
        LOG.assertTrue(typeValueAt instanceof PsiTypeCodeFragment);
        try {
            type = ((PsiTypeCodeFragment)typeValueAt).getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e1) {
            type = null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e1) {
            type = null;
        }
        return type;
    }

    public void setParameterInfos(List<ParameterInfoImpl> parameterInfos, PsiElement context) {
        this.myParameterInfos = parameterInfos;
        this.myTypeCodeFraments = new ArrayList<PsiTypeCodeFragment>(parameterInfos.size());
        this.myDefaultValuesCodeFragments = new ArrayList<JavaCodeFragment>(parameterInfos.size());
        for (ParameterInfoImpl parameterInfo : parameterInfos) {
            PsiTypeCodeFragment typeCodeFragment = this.createParameterTypeCodeFragment(parameterInfo.getTypeText(), context);
            parameterInfo.getTypeWrapper().addImportsTo((JavaCodeFragment)typeCodeFragment);
            this.myTypeCodeFraments.add(typeCodeFragment);
            this.myDefaultValuesCodeFragments.add(this.createDefaultValueCodeFragment(parameterInfo.defaultValue, null));
        }
    }

    private PsiTypeCodeFragment createParameterTypeCodeFragment(String typeText, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)this.myParameterList.getProject()).getElementFactory().createTypeCodeFragment(typeText, context, false, true, true);
    }
}

