/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.impl.events.XmlAttributeSetImpl;
import com.intellij.pom.xml.impl.events.XmlTagNameChangedImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagImpl
extends XmlElementImpl
implements XmlTag {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlTagImpl");
    private volatile String myName = null;
    private volatile XmlAttribute[] myAttributes = null;
    private volatile Map<String, String> myAttributeValueMap = null;
    private volatile XmlTag[] myTags = null;
    private volatile XmlTagValue myValue = null;
    private volatile Map<String, CachedValue<XmlNSDescriptor>> myNSDescriptorsMap = null;
    private volatile String myCachedNamespace;
    private volatile long myModCount;
    private volatile XmlElementDescriptor myCachedDescriptor;
    private volatile long myDescriptorModCount = -1L;
    private volatile boolean myHaveNamespaceDeclarations = false;
    private volatile BidirectionalMap<String, String> myNamespaceMap = null;
    @NonNls
    private static final String XML_NS_PREFIX = "xml";
    private final int myHC = ourHC++;
    private static final ThreadLocal<Boolean> ourGetNsByPrefixRecursionLock = new ThreadLocal();

    public final int hashCode() {
        return this.myHC;
    }

    public XmlTagImpl() {
        this(XmlElementType.XML_TAG);
    }

    protected XmlTagImpl(IElementType type) {
        super(type);
    }

    @Override
    public void clearCaches() {
        this.myName = null;
        this.myNamespaceMap = null;
        this.myCachedNamespace = null;
        this.myCachedDescriptor = null;
        this.myDescriptorModCount = -1L;
        this.myAttributes = null;
        this.myAttributeValueMap = null;
        this.myHaveNamespaceDeclarations = false;
        this.myValue = null;
        this.myTags = null;
        this.myNSDescriptorsMap = null;
        super.clearCaches();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        ProgressManager.checkCanceled();
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(this);
        if (startTagName == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        ArrayList<Object> refs = new ArrayList<Object>();
        String prefix = this.getNamespacePrefix();
        if (endTagName != null) {
            if (prefix.length() > 0) {
                refs.add((Object)new SchemaPrefixReference(this, TextRange.from((int)(startTagName.getStartOffset() - this.getStartOffset()), (int)prefix.length()), prefix));
                refs.add((Object)new SchemaPrefixReference(this, TextRange.from((int)(endTagName.getStartOffset() - this.getStartOffset()), (int)prefix.length()), prefix));
            }
            refs.add(TagNameReference.create(this, startTagName, true));
            refs.add(TagNameReference.create(this, endTagName, false));
        } else {
            if (prefix.length() > 0) {
                refs.add((Object)new SchemaPrefixReference(this, TextRange.from((int)(startTagName.getStartOffset() - this.getStartOffset()), (int)prefix.length()), prefix));
            }
            refs.add(TagNameReference.create(this, startTagName, true));
        }
        for (PsiReference ref : ReferenceProvidersRegistry.getReferencesFromProviders(this, XmlTag.class)) {
            refs.add(ref);
        }
        psiReferenceArray = (PsiReference[])ContainerUtil.toArray(refs, (Object[])new PsiReference[refs.size()]);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getReferences must not return null");
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        XmlNSDescriptor value;
        XmlNSDescriptor descriptor;
        XmlTag parentTag = this.getParentTag();
        if (parentTag == null && namespace.equals("http://www.w3.org/1999/xhtml") && (descriptor = XmlTagImpl.getDtdDescriptor(XmlUtil.getContainingFile(this))) != null) {
            return descriptor;
        }
        Map<String, CachedValue<XmlNSDescriptor>> map = this.initNSDescriptorsMap();
        CachedValue<XmlNSDescriptor> descriptor2 = map.get(namespace);
        if (descriptor2 != null && (value = (XmlNSDescriptor)descriptor2.getValue()) != null) {
            return value;
        }
        if (parentTag == null) {
            XmlDocument parentOfType = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this, XmlDocument.class);
            if (parentOfType == null) {
                return null;
            }
            return parentOfType.getDefaultNSDescriptor(namespace, strict);
        }
        return parentTag.getNSDescriptor(namespace, strict);
    }

    @Nullable
    private static XmlNSDescriptor getDtdDescriptor(@NotNull XmlFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagImpl.getDtdDescriptor must not be null");
        }
        XmlDocument document = containingFile.getDocument();
        if (document == null) {
            return null;
        }
        String url = XmlUtil.getDtdUri(document);
        if (url == null) {
            return null;
        }
        return document.getDefaultNSDescriptor(url, true);
    }

    public boolean isEmpty() {
        return XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this) == null;
    }

    public void collapseIfEmpty() {
        XmlTag[] tags = this.getSubTags();
        if (tags.length > 0) {
            return;
        }
        final ASTNode closingName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this);
        final ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this);
        if (closingName == null || startTagEnd == null) {
            return;
        }
        PomModel pomModel = PomManager.getModel((Project)this.getProject());
        PomTransactionBase transaction = new PomTransactionBase(this, pomModel.getModelAspect(XmlAspect.class)){

            @Nullable
            public PomModelEvent runInner() {
                ASTNode closingBracket = closingName.getTreeNext();
                XmlTagImpl.this.removeRange(startTagEnd, closingBracket);
                LeafElement emptyTagEnd = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, null, XmlTagImpl.this.getManager());
                XmlTagImpl.this.replaceChild(closingBracket, emptyTagEnd);
                return null;
            }
        };
        try {
            pomModel.runTransaction((PomTransaction)transaction);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    @NonNls
    public String getSubTagText(@NonNls String qname) {
        XmlTag tag = this.findFirstSubTag(qname);
        if (tag == null) {
            return null;
        }
        return tag.getValue().getText();
    }

    protected final Map<String, CachedValue<XmlNSDescriptor>> initNSDescriptorsMap() {
        Map<String, Object> map = this.myNSDescriptorsMap;
        if (map == null) {
            boolean exceptionOccurred = false;
            try {
                String noNamespaceDeclaration = this.getAttributeValue("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
                String schemaLocationDeclaration = this.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
                if (noNamespaceDeclaration != null) {
                    map = this.initializeSchema("", null, noNamespaceDeclaration, map);
                }
                if (schemaLocationDeclaration != null) {
                    StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
                    while (tokenizer.hasMoreTokens()) {
                        String uri = tokenizer.nextToken();
                        if (!tokenizer.hasMoreTokens()) continue;
                        map = this.initializeSchema(uri, null, tokenizer.nextToken(), map);
                    }
                }
                if (this.hasNamespaceDeclarations()) {
                    for (XmlAttribute attribute : this.getAttributes()) {
                        if (!attribute.isNamespaceDeclaration()) continue;
                        String ns = attribute.getValue();
                        if (ns == null) {
                            ns = "";
                        }
                        ns = this.getRealNs(ns);
                        if (map != null && map.containsKey(ns)) continue;
                        map = this.initializeSchema(ns, XmlTagImpl.getNSVersion(ns, this), ns, map);
                    }
                }
            }
            catch (RuntimeException e) {
                this.myNSDescriptorsMap = null;
                exceptionOccurred = true;
                throw e;
            }
            finally {
                if (map == null && !exceptionOccurred) {
                    map = Collections.emptyMap();
                }
            }
            this.myNSDescriptorsMap = map;
        }
        return map;
    }

    @Nullable
    private static String getNSVersion(String ns, XmlTagImpl xmlTag) {
        String versionValue = xmlTag.getAttributeValue("version");
        if (versionValue != null && xmlTag.getNamespace().equals(ns)) {
            return versionValue;
        }
        return null;
    }

    private Map<String, CachedValue<XmlNSDescriptor>> initializeSchema(final String namespace, final String version, final String fileLocation, Map<String, CachedValue<XmlNSDescriptor>> map) {
        if (map == null) {
            map = new THashMap();
        }
        ExternalResourceManagerEx externalResourceManager = ExternalResourceManagerEx.getInstanceEx();
        map.put(namespace, CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlNSDescriptor>(){

            public CachedValueProvider.Result<XmlNSDescriptor> compute() {
                PsiMetaOwner currentOwner;
                XmlDocument document;
                XmlNSDescriptor descriptor = XmlTagImpl.this.getImplicitNamespaceDescriptor(fileLocation);
                if (descriptor != null) {
                    return new CachedValueProvider.Result((Object)descriptor, ArrayUtil.append((Object[])descriptor.getDependences(), (Object)XmlTagImpl.this));
                }
                XmlFile currentFile = XmlTagImpl.this.retrieveFile(fileLocation, version);
                if (currentFile == null && (document = XmlUtil.getContainingFile(XmlTagImpl.this).getDocument()) != null) {
                    String defaultValue;
                    XmlAttributeDescriptor attributeDescriptor;
                    XmlElementDescriptor elementDescriptor;
                    String uri = XmlUtil.getDtdUri(document);
                    if (uri != null) {
                        XmlFile containingFile = XmlUtil.getContainingFile((PsiElement)document);
                        XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, uri);
                        XmlNSDescriptor xmlNSDescriptor = descriptor = xmlFile == null ? null : (XmlNSDescriptor)xmlFile.getDocument().getMetaData();
                    }
                    if (descriptor != null && (elementDescriptor = descriptor.getElementDescriptor((XmlTag)XmlTagImpl.this)) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor("xmlns", (XmlTag)XmlTagImpl.this)) != null && attributeDescriptor.isFixed() && (defaultValue = attributeDescriptor.getDefaultValue()) != null && defaultValue.equals(namespace)) {
                        return new CachedValueProvider.Result((Object)descriptor, new Object[]{descriptor.getDependences(), XmlTagImpl.this, ExternalResourceManager.getInstance()});
                    }
                }
                if ((currentOwner = XmlTagImpl.this.retrieveOwner(currentFile, namespace)) != null && (descriptor = (XmlNSDescriptor)currentOwner.getMetaData()) != null) {
                    return new CachedValueProvider.Result((Object)descriptor, new Object[]{descriptor.getDependences(), XmlTagImpl.this, ExternalResourceManager.getInstance()});
                }
                return new CachedValueProvider.Result(null, new Object[]{XmlTagImpl.this, currentFile, ExternalResourceManager.getInstance()});
            }
        }, false));
        return map;
    }

    @Nullable
    private XmlNSDescriptor getImplicitNamespaceDescriptor(String ns) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this);
        if (module != null) {
            for (ImplicitNamespaceDescriptorProvider provider : (ImplicitNamespaceDescriptorProvider[])Extensions.getExtensions(ImplicitNamespaceDescriptorProvider.EP_NAME)) {
                XmlNSDescriptor nsDescriptor = provider.getNamespaceDescriptor(module, ns);
                if (nsDescriptor == null) continue;
                return nsDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private XmlFile retrieveFile(String fileLocation, String version) {
        String targetNs = XmlUtil.getTargetSchemaNsFromTag(this);
        if (fileLocation.equals(targetNs)) {
            return null;
        }
        XmlFile file = XmlUtil.getContainingFile(this);
        PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(fileLocation, (PsiFile)file, version);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    private PsiMetaOwner retrieveOwner(XmlFile file, String namespace) {
        if (file == null) {
            return namespace.equals(XmlUtil.getTargetSchemaNsFromTag(this)) ? this : null;
        }
        return file.getDocument();
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length > 0 ? references[0] : null;
    }

    public XmlElementDescriptor getDescriptor() {
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (this.myDescriptorModCount != curModCount) {
            this.myCachedDescriptor = this.computeElementDescriptor();
            this.myDescriptorModCount = curModCount;
        }
        return this.myCachedDescriptor;
    }

    @Nullable
    protected XmlElementDescriptor computeElementDescriptor() {
        XmlElementDescriptor fromParent;
        XmlElementDescriptor descriptor;
        XmlTag parent;
        for (XmlElementDescriptorProvider provider : (XmlElementDescriptorProvider[])Extensions.getExtensions(XmlElementDescriptorProvider.EP_NAME)) {
            XmlElementDescriptor elementDescriptor = provider.getDescriptor(this);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        String namespace = this.getNamespace();
        if ("".equals(namespace) && (parent = this.getParentTag()) != null && (descriptor = parent.getDescriptor()) != null && (fromParent = descriptor.getElementDescriptor((XmlTag)this, parent)) != null && !(fromParent instanceof AnyXmlElementDescriptor)) {
            return fromParent;
        }
        XmlElementDescriptor elementDescriptor = null;
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(namespace, false);
        if (nsDescriptor != null && (!DumbService.getInstance((Project)this.getProject()).isDumb() || nsDescriptor instanceof DumbAware)) {
            elementDescriptor = nsDescriptor.getElementDescriptor((XmlTag)this);
        }
        if (elementDescriptor == null) {
            return XmlUtil.findXmlDescriptorByType(this);
        }
        return elementDescriptor;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == XmlTokenType.XML_NAME || i == XmlTokenType.XML_TAG_NAME) {
            return 224;
        }
        if (i == XmlElementType.XML_ATTRIBUTE) {
            return 240;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.myName;
        if (name == null) {
            ASTNode nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(this);
            name = nameElement != null ? nameElement.getText() : "";
            this.myName = name;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(final @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagImpl.setName must not be null");
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

            public PomModelEvent runInner() throws IncorrectOperationException {
                String oldName = XmlTagImpl.this.getName();
                XmlTagImpl dummyTag = (XmlTagImpl)XmlElementFactory.getInstance((Project)XmlTagImpl.this.getProject()).createTagFromText(XmlTagUtil.composeTagText((String)name, (String)"aa"));
                XmlTagImpl tag = XmlTagImpl.this;
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(tag);
                tag.replaceChild(XmlChildRole.START_TAG_NAME_FINDER.findChild(tag), ChangeUtil.copyElement((TreeElement)XmlChildRole.START_TAG_NAME_FINDER.findChild(dummyTag), charTableByTree));
                ASTNode childByRole = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag);
                if (childByRole != null) {
                    tag.replaceChild(childByRole, ChangeUtil.copyElement((TreeElement)XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(dummyTag), charTableByTree));
                }
                return XmlTagNameChangedImpl.createXmlTagNameChanged(model, tag, oldName);
            }
        });
        return this;
    }

    public XmlAttribute[] getAttributes() {
        XmlAttribute[] attributes = this.myAttributes;
        if (attributes == null) {
            THashMap attributesValueMap = new THashMap();
            attributes = this.calculateAttributes((Map<String, String>)attributesValueMap);
            this.myAttributeValueMap = attributesValueMap;
            this.myAttributes = attributes;
        }
        return attributes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected XmlAttribute[] calculateAttributes(final Map<String, String> attributesValueMap) {
        XmlAttribute[] xmlAttributeArray;
        final ArrayList result = new ArrayList(10);
        this.processChildren(new PsiElementProcessor(){

            public boolean execute(PsiElement element) {
                if (element instanceof XmlAttribute) {
                    XmlAttribute attribute = (XmlAttribute)element;
                    result.add(attribute);
                    XmlTagImpl.this.cacheOneAttributeValue(attribute.getName(), attribute.getValue(), attributesValueMap);
                    XmlTagImpl.this.myHaveNamespaceDeclarations = XmlTagImpl.this.myHaveNamespaceDeclarations || attribute.isNamespaceDeclaration();
                } else if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    return false;
                }
                return true;
            }
        });
        if (result.isEmpty()) {
            xmlAttributeArray = XmlAttribute.EMPTY_ARRAY;
            if (XmlAttribute.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.calculateAttributes must not return null");
            return xmlAttributeArray;
        }
        xmlAttributeArray = (XmlAttribute[])ContainerUtil.toArray(result, (Object[])new XmlAttribute[result.size()]);
        if (xmlAttributeArray != null) return xmlAttributeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.calculateAttributes must not return null");
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        attributesValueMap.put(name, value);
    }

    public String getAttributeValue(String qname) {
        Map<String, String> map = this.myAttributeValueMap;
        while (map == null) {
            XmlAttribute[] xmlAttributes = this.getAttributes();
            map = this.myAttributeValueMap;
            if (map != null || xmlAttributes == null) continue;
            this.myAttributes = null;
        }
        return map.get(qname);
    }

    public String getAttributeValue(String _name, String namespace) {
        if (namespace == null) {
            return this.getAttributeValue(_name);
        }
        XmlTagImpl current = this;
        PsiElement parent = this.getParent();
        while (current != null) {
            List keysByValue;
            BidirectionalMap<String, String> map = current.initNamespaceMaps(parent);
            if (map != null && (keysByValue = map.getKeysByValue((Object)namespace)) != null && !keysByValue.isEmpty()) {
                for (String prefix : keysByValue) {
                    String value;
                    if (prefix == null || prefix.length() <= 0 || (value = this.getAttributeValue(prefix + ":" + _name)) == null) continue;
                    return value;
                }
            }
            current = parent instanceof XmlTag ? (XmlTagImpl)parent : null;
            parent = parent.getParent();
        }
        if (namespace.length() == 0 || this.getNamespace().equals(namespace)) {
            return this.getAttributeValue(_name);
        }
        return null;
    }

    @NotNull
    public XmlTag[] getSubTags() {
        XmlTag[] tags = this.myTags;
        if (tags == null) {
            ArrayList<XmlTag> result = new ArrayList<XmlTag>();
            this.fillSubTags(result);
            int s = result.size();
            tags = s > 0 ? (XmlTag[])ContainerUtil.toArray(result, (Object[])new XmlTag[s]) : EMPTY;
            this.myTags = tags;
        }
        if (tags == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getSubTags must not return null");
        }
        return tags;
    }

    protected void fillSubTags(final List<XmlTag> result) {
        this.processElements(new PsiElementProcessor(){

            public boolean execute(PsiElement element) {
                if (element instanceof XmlTag) {
                    result.add((XmlTag)element);
                }
                return true;
            }
        }, this);
    }

    @NotNull
    public XmlTag[] findSubTags(String name) {
        XmlTag[] xmlTagArray = this.findSubTags(name, null);
        if (xmlTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.findSubTags must not return null");
        }
        return xmlTagArray;
    }

    @NotNull
    public XmlTag[] findSubTags(String name, String namespace) {
        XmlTag[] subTags = this.getSubTags();
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                if (!name.equals(subTag.getName())) continue;
                result.add(subTag);
                continue;
            }
            if (!name.equals(subTag.getLocalName()) || !namespace.equals(subTag.getNamespace())) continue;
            result.add(subTag);
        }
        XmlTag[] xmlTagArray = (XmlTag[])ContainerUtil.toArray(result, (Object[])new XmlTag[result.size()]);
        if (xmlTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.findSubTags must not return null");
        }
        return xmlTagArray;
    }

    public XmlTag findFirstSubTag(String name) {
        XmlTag[] subTags = this.findSubTags(name);
        if (subTags.length > 0) {
            return subTags[0];
        }
        return null;
    }

    public XmlAttribute getAttribute(String name, String namespace) {
        if (name != null && name.indexOf(58) != -1 || namespace == null || "".equals(namespace) || "http://www.intellij.net/ns/any".equals(namespace)) {
            return this.getAttribute(name);
        }
        String prefix = this.getPrefixByNamespace(namespace);
        if (prefix == null || prefix.length() == 0) {
            return null;
        }
        return this.getAttribute(prefix + ":" + name);
    }

    @Nullable
    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree(this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            LeafElement attrNameElement = (LeafElement)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            if (attrNameElement == null || (!caseSensitive || !attrNameElement.getChars().equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    protected boolean isCaseSensitive() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getNamespace() {
        String string;
        LOG.assertTrue(this.isValid());
        String cachedNamespace = this.myCachedNamespace;
        long curModCount = this.getManager().getModificationTracker().getModificationCount();
        if (cachedNamespace != null && this.myModCount == curModCount) {
            string = cachedNamespace;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespace must not return null");
            return string;
        }
        String prefix = this.getNamespacePrefix();
        this.myCachedNamespace = cachedNamespace = this.getNamespaceByPrefix(prefix);
        this.myModCount = curModCount;
        string = cachedNamespace;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespace must not return null");
    }

    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespacePrefix must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        String string;
        String ns;
        PsiElement parent = this.getParent();
        LOG.assertTrue(parent.isValid());
        BidirectionalMap<String, String> map = this.initNamespaceMaps(parent);
        if (map != null && (ns = (String)map.get((Object)prefix)) != null) {
            String string2 = ns;
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespaceByPrefix must not return null");
        }
        if (parent instanceof XmlTag) {
            String string3 = ((XmlTag)parent).getNamespaceByPrefix(prefix);
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespaceByPrefix must not return null");
            return string;
        }
        if (XML_NS_PREFIX.equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.length() <= 0) return "";
        if (this.hasNamespaceDeclarations()) return "";
        if (!this.getNamespacePrefix().equals(prefix)) return "";
        if (ourGetNsByPrefixRecursionLock.get() != null) return "";
        ourGetNsByPrefixRecursionLock.set(Boolean.TRUE);
        String nsFromEmptyPrefix = this.getNamespaceByPrefix("");
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor(nsFromEmptyPrefix, false);
        XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor((XmlTag)this) : null;
        String nameFromRealDescriptor = descriptor != null && descriptor.getDeclaration() != null && descriptor.getDeclaration().isPhysical() ? descriptor.getName() : "";
        if (!nameFromRealDescriptor.equals(this.getName())) return "";
        String string4 = nsFromEmptyPrefix;
        String string5 = string4;
        string = string5;
        if (string5 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getNamespaceByPrefix must not return null");
        return string;
        finally {
            ourGetNsByPrefixRecursionLock.set(null);
        }
    }

    public String getPrefixByNamespace(String namespace) {
        PsiElement parent = this.getParent();
        BidirectionalMap<String, String> map = this.initNamespaceMaps(parent);
        if (map != null) {
            String ns;
            List keysByValue = map.getKeysByValue((Object)namespace);
            String string = ns = keysByValue == null || keysByValue.isEmpty() ? null : (String)keysByValue.get(0);
            if (ns != null) {
                return ns;
            }
        }
        if (parent instanceof XmlTag) {
            return ((XmlTag)parent).getPrefixByNamespace(namespace);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return XML_NS_PREFIX;
        }
        return null;
    }

    public String[] knownNamespaces() {
        PsiElement parentElement = this.getParent();
        BidirectionalMap<String, String> map = this.initNamespaceMaps(parentElement);
        Set known = Collections.emptySet();
        if (map != null) {
            known = new HashSet(map.values());
        }
        if (parentElement instanceof XmlTag) {
            if (known.isEmpty()) {
                return ((XmlTag)parentElement).knownNamespaces();
            }
            known.addAll(Arrays.asList(((XmlTag)parentElement).knownNamespaces()));
        } else {
            XmlFile xmlFile = XmlExtension.getExtensionByElement(this).getContainingFile(this);
            XmlTag rootTag = xmlFile.getDocument().getRootTag();
            if (rootTag != null && rootTag != this) {
                if (known.isEmpty()) {
                    return rootTag.knownNamespaces();
                }
                known.addAll(Arrays.asList(rootTag.knownNamespaces()));
            }
        }
        return ArrayUtil.toStringArray(known);
    }

    @Nullable
    private BidirectionalMap<String, String> initNamespaceMaps(PsiElement parent) {
        String[][] defaultNamespace;
        XmlExtension extension;
        BidirectionalMap map = this.myNamespaceMap;
        if (map == null && this.hasNamespaceDeclarations()) {
            XmlAttribute[] attributes;
            BidirectionalMap namespaceMap = new BidirectionalMap();
            for (XmlAttribute attribute : attributes = this.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String name = attribute.getName();
                int splitIndex = name.indexOf(58);
                String value = this.getRealNs(attribute.getValue());
                if (value == null) continue;
                if (splitIndex < 0) {
                    namespaceMap.put((Object)"", (Object)value);
                    continue;
                }
                namespaceMap.put((Object)XmlUtil.findLocalNameByQualifiedName(name), (Object)value);
            }
            this.myNamespaceMap = map = namespaceMap;
        }
        if (parent instanceof XmlDocument && (extension = XmlExtension.getExtensionByElement(parent)) != null && (defaultNamespace = extension.getNamespacesFromDocument((XmlDocument)parent, map != null)) != null) {
            BidirectionalMap namespaceMap = new BidirectionalMap();
            if (map != null) {
                namespaceMap.putAll((Map)map);
            }
            for (String[] prefix2ns : defaultNamespace) {
                namespaceMap.put((Object)prefix2ns[0], (Object)this.getRealNs(prefix2ns[1]));
            }
            this.myNamespaceMap = map = namespaceMap;
        }
        return map;
    }

    protected String getRealNs(String value) {
        return value;
    }

    @NotNull
    public String getLocalName() {
        String name = this.getName();
        String string = name.substring(name.indexOf(58) + 1);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getLocalName must not return null");
        }
        return string;
    }

    public boolean hasNamespaceDeclarations() {
        this.getAttributes();
        return this.myHaveNamespaceDeclarations;
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        THashMap namespaces = new THashMap();
        for (XmlAttribute attribute : this.getAttributes()) {
            if (!attribute.isNamespaceDeclaration() || attribute.getValue() == null) continue;
            String localName = attribute.getLocalName();
            namespaces.put(localName.equals(attribute.getName()) ? "" : localName, attribute.getValue());
        }
        THashMap tHashMap = namespaces;
        if (tHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getLocalNamespaceDeclarations must not return null");
        }
        return tHashMap;
    }

    public XmlAttribute setAttribute(String qname, String value) throws IncorrectOperationException {
        XmlAttribute attribute = this.getAttribute(qname);
        if (attribute != null) {
            if (value == null) {
                this.deleteChildInternal(attribute.getNode());
                return null;
            }
            attribute.setValue(value);
            return attribute;
        }
        if (value == null) {
            return null;
        }
        PsiElement xmlAttribute = this.add((PsiElement)XmlElementFactory.getInstance((Project)this.getProject()).createXmlAttribute(qname, value));
        while (!(xmlAttribute instanceof XmlAttribute)) {
            xmlAttribute = xmlAttribute.getNextSibling();
        }
        return (XmlAttribute)xmlAttribute;
    }

    public XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        String prefix;
        if (!Comparing.equal((String)namespace, (String)"") && (prefix = this.getPrefixByNamespace(namespace)) != null && prefix.length() > 0) {
            name = prefix + ":" + name;
        }
        return this.setAttribute(name, value);
    }

    public XmlTag createChildTag(String localName, String namespace, String bodyText, boolean enforceNamespacesDeep) {
        return XmlUtil.createChildTag(this, localName, namespace, bodyText, enforceNamespacesDeep);
    }

    @NotNull
    public XmlTagValue getValue() {
        XmlTagValue tagValue = this.myValue;
        if (tagValue == null) {
            PsiElement[] elements = this.getElements();
            ArrayList<XmlTagChild> bodyElements = new ArrayList<XmlTagChild>(elements.length);
            boolean insideBody = false;
            for (PsiElement element : elements) {
                ASTNode treeElement = element.getNode();
                if (insideBody) {
                    if (treeElement.getElementType() == XmlTokenType.XML_END_TAG_START) break;
                    if (!(element instanceof XmlTagChild)) continue;
                    bodyElements.add((XmlTagChild)element);
                    continue;
                }
                if (treeElement.getElementType() != XmlTokenType.XML_TAG_END) continue;
                insideBody = true;
            }
            XmlTagChild[] tagChildren = (XmlTagChild[])ContainerUtil.toArray(bodyElements, (Object[])new XmlTagChild[bodyElements.size()]);
            this.myValue = tagValue = new XmlTagValueImpl(tagChildren, this);
        }
        XmlTagValue xmlTagValue = tagValue;
        if (xmlTagValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlTagImpl.getValue must not return null");
        }
        return xmlTagValue;
    }

    private PsiElement[] getElements() {
        final ArrayList elements = new ArrayList();
        this.processElements(new PsiElementProcessor(){

            public boolean execute(PsiElement psiElement) {
                elements.add(psiElement);
                return true;
            }
        }, this);
        return (PsiElement[])ContainerUtil.toArray(elements, (Object[])new PsiElement[elements.size()]);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlTag((XmlTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "XmlTag:" + this.getName();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean beforeB) {
        TreeElement firstAppended = null;
        boolean before = beforeB == null || beforeB != false;
        try {
            TreeElement next;
            do {
                next = first.getTreeNext();
                if (firstAppended == null) {
                    firstAppended = this.addInternal(first, anchor, before);
                    anchor = firstAppended;
                    continue;
                }
                anchor = this.addInternal(first, anchor, false);
            } while (first != last && (first = next) != null);
        }
        catch (IncorrectOperationException ignored) {
        }
        finally {
            this.clearCaches();
        }
        return firstAppended;
    }

    private TreeElement addInternal(TreeElement child, ASTNode anchor, boolean before) throws IncorrectOperationException {
        PomModel model = PomManager.getModel((Project)this.getProject());
        if (anchor != null && child.getElementType() == XmlElementType.XML_TEXT) {
            XmlText psi = null;
            if (anchor.getPsi() instanceof XmlText) {
                psi = (XmlText)anchor.getPsi();
            } else {
                ASTNode other;
                ASTNode aSTNode = other = before ? anchor.getTreePrev() : anchor.getTreeNext();
                if (other != null && other.getPsi() instanceof XmlText) {
                    before = !before;
                    psi = (XmlText)other.getPsi();
                }
            }
            if (psi != null) {
                if (before) {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), 0);
                } else {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), psi.getValue().length());
                }
                return (TreeElement)psi.getNode();
            }
        }
        LOG.assertTrue(child.getPsi() instanceof XmlAttribute || child.getPsi() instanceof XmlTagChild);
        InsertTransaction transaction = child.getElementType() == XmlElementType.XML_ATTRIBUTE ? new InsertAttributeTransaction(child, anchor, before, model) : (anchor == null ? this.getBodyInsertTransaction(child) : new GenericInsertTransaction(child, anchor, before));
        model.runTransaction((PomTransaction)transaction);
        return transaction.getFirstInserted();
    }

    protected InsertTransaction getBodyInsertTransaction(TreeElement child) {
        return new BodyInsertTransaction(child);
    }

    @Override
    public void deleteChildInternal(final @NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlTagImpl.deleteChildInternal must not be null");
        }
        final PomModel model = PomManager.getModel((Project)this.getProject());
        XmlAspect aspect = (XmlAspect)model.getModelAspect(XmlAspect.class);
        if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
            try {
                model.runTransaction((PomTransaction)new PomTransactionBase(this, (PomModelAspect)aspect){

                    public PomModelEvent runInner() {
                        String name = ((XmlAttribute)child).getName();
                        XmlTagImpl.super.deleteChildInternal(child);
                        return XmlAttributeSetImpl.createXmlAttributeSet(model, XmlTagImpl.this, name, null);
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else {
            ASTNode treePrev = child.getTreePrev();
            ASTNode treeNext = child.getTreeNext();
            XmlTagImpl.super.deleteChildInternal(child);
            if (treePrev != null && treeNext != null && treePrev.getElementType() == XmlElementType.XML_TEXT && treeNext.getElementType() == XmlElementType.XML_TEXT) {
                XmlText prevText = (XmlText)treePrev.getPsi();
                XmlText nextText = (XmlText)treeNext.getPsi();
                try {
                    prevText.setValue(prevText.getValue() + nextText.getValue());
                    nextText.delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private ASTNode expandTag() throws IncorrectOperationException {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this);
        if (endTagStart == null) {
            XmlTagImpl tagFromText = (XmlTagImpl)XmlElementFactory.getInstance((Project)this.getProject()).createTagFromText("<" + this.getName() + "></" + this.getName() + ">");
            ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(tagFromText);
            endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagFromText);
            LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(this);
            if (emptyTagEnd != null) {
                this.removeChild(emptyTagEnd);
            }
            this.addChildren(startTagStart, null, null);
        }
        return endTagStart;
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public Icon getElementIcon(int flags) {
        return Icons.XML_TAG_ICON;
    }

    protected abstract class InsertTransaction
    extends PomTransactionBase {
        public InsertTransaction(PsiElement scope) {
            super(scope, PomManager.getModel((Project)XmlTagImpl.this.getProject()).getModelAspect(XmlAspect.class));
        }

        public abstract TreeElement getFirstInserted();
    }

    protected class GenericInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private TreeElement myRetHolder;

        public GenericInsertTransaction(TreeElement child, ASTNode anchor, boolean before) {
            super(XmlTagImpl.this);
            this.myChild = child;
            this.myAnchor = anchor;
            this.myBefore = before;
        }

        public PomModelEvent runInner() {
            this.myRetHolder = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myRetHolder;
        }
    }

    protected class InsertAttributeTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private final ASTNode myAnchor;
        private final boolean myBefore;
        private final PomModel myModel;
        private TreeElement myFirstInserted;

        public InsertAttributeTransaction(TreeElement child, ASTNode anchor, boolean before, PomModel model) {
            super(XmlTagImpl.this);
            this.myFirstInserted = null;
            this.myChild = child;
            this.myAnchor = anchor;
            this.myBefore = before;
            this.myModel = model;
        }

        public PomModelEvent runInner() {
            String value = ((XmlAttribute)this.myChild).getValue();
            String name = ((XmlAttribute)this.myChild).getName();
            if (this.myAnchor == null) {
                TreeElement anchor;
                ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                if (startTagEnd == null) {
                    startTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(XmlTagImpl.this);
                }
                if (startTagEnd == null) {
                    anchor = XmlTagImpl.this.getLastChildNode();
                    while (anchor instanceof PsiWhiteSpace) {
                        anchor = anchor.getTreePrev();
                    }
                    if (anchor instanceof PsiErrorElement) {
                        LeafElement token = Factory.createSingleLeafElement(XmlTokenType.XML_EMPTY_ELEMENT_END, "/>", 0, 2, SharedImplUtil.findCharTableByTree(anchor), XmlTagImpl.this.getManager());
                        XmlTagImpl.this.replaceChild(anchor, token);
                        startTagEnd = token;
                    }
                }
                if (startTagEnd == null) {
                    anchor = XmlChildRole.START_TAG_NAME_FINDER.findChild(XmlTagImpl.this);
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor, Boolean.FALSE);
                } else {
                    this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, startTagEnd, Boolean.TRUE);
                }
            } else {
                this.myFirstInserted = XmlTagImpl.super.addInternal(this.myChild, this.myChild, this.myAnchor, this.myBefore);
            }
            return XmlAttributeSetImpl.createXmlAttributeSet(this.myModel, XmlTagImpl.this, name, value);
        }

        @Override
        public TreeElement getFirstInserted() {
            return this.myFirstInserted;
        }
    }

    protected class BodyInsertTransaction
    extends InsertTransaction {
        private final TreeElement myChild;
        private ASTNode myNewElement;

        public BodyInsertTransaction(TreeElement child) {
            super(XmlTagImpl.this);
            this.myChild = child;
        }

        public PomModelEvent runInner() throws IncorrectOperationException {
            ASTNode anchor = XmlTagImpl.this.expandTag();
            if (this.myChild.getElementType() == XmlElementType.XML_TAG) {
                PsiElement declaration;
                XmlElementDescriptor parentDescriptor = XmlTagImpl.this.getDescriptor();
                XmlTag[] subTags = XmlTagImpl.this.getSubTags();
                PsiElement psiElement = declaration = parentDescriptor != null ? parentDescriptor.getDeclaration() : null;
                if (declaration != null && declaration.getContainingFile() != null && declaration.getContainingFile().isPhysical() && subTags.length > 0) {
                    XmlElementDescriptor[] childElementDescriptors = parentDescriptor.getElementsDescriptors((XmlTag)XmlTagImpl.this);
                    int subTagNum = -1;
                    for (XmlElementDescriptor childElementDescriptor : childElementDescriptors) {
                        String childElementName = childElementDescriptor.getName();
                        while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                            ++subTagNum;
                        }
                        if (!childElementName.equals(XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myChild).getText())) continue;
                        if (subTagNum >= 0) {
                            ASTNode subTag = (ASTNode)subTags[subTagNum];
                            if (subTag.getTreeParent() != XmlTagImpl.this) {
                                XmlEntityRef entityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)subTags[subTagNum], XmlEntityRef.class);
                                throw new IncorrectOperationException("Can't insert subtag to entity! Entity reference text: " + entityRef != null ? entityRef.getText() : "");
                            }
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, subTag, Boolean.FALSE);
                        } else {
                            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(XmlTagImpl.this);
                            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.FALSE);
                        }
                        return null;
                    }
                } else {
                    ASTNode child = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(XmlTagImpl.this);
                    this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, child, Boolean.TRUE);
                    return null;
                }
            }
            this.myNewElement = XmlTagImpl.super.addInternal(this.myChild, this.myChild, anchor, Boolean.TRUE);
            return null;
        }

        @Override
        public TreeElement getFirstInserted() {
            return (TreeElement)this.myNewElement;
        }
    }
}

