/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlTagImpl
extends XmlTagImpl
implements HtmlTag {
    public HtmlTagImpl() {
        super(XmlElementType.HTML_TAG);
    }

    @Override
    @NotNull
    public XmlTag[] findSubTags(String name, String namespace) {
        XmlTag[] subTags = this.getSubTags();
        ArrayList<XmlTag> result = null;
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                String tagName = subTag.getName();
                tagName = tagName.toLowerCase();
                if (name != null && !name.equals(tagName)) continue;
                if (result == null) {
                    result = new ArrayList(3);
                }
                result.add(subTag);
                continue;
            }
            if (!namespace.equals(subTag.getNamespace()) || name != null && !name.equals(subTag.getLocalName())) continue;
            if (result == null) {
                result = new ArrayList<XmlTag>(3);
            }
            result.add(subTag);
        }
        XmlTag[] xmlTagArray = result == null ? EMPTY : result.toArray(new XmlTag[result.size()]);
        if (xmlTagArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/html/HtmlTagImpl.findSubTags must not return null");
        }
        return xmlTagArray;
    }

    @Override
    protected boolean isCaseSensitive() {
        return false;
    }

    @Override
    public String getAttributeValue(String qname) {
        qname = qname.toLowerCase();
        return super.getAttributeValue(qname);
    }

    @Override
    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        name = name.toLowerCase();
        super.cacheOneAttributeValue(name, value, attributesValueMap);
    }

    @Override
    public String getAttributeValue(String name, String namespace) {
        name = name.toLowerCase();
        return super.getAttributeValue(name, namespace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getNamespace() {
        if (this.getNamespacePrefix().length() == 0) {
            return "http://www.w3.org/1999/html";
        }
        String string = super.getNamespace();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/html/HtmlTagImpl.getNamespace must not return null");
        return string2;
    }

    @Override
    protected String getRealNs(String value) {
        if ("http://www.w3.org/1999/xhtml".equals(value)) {
            return "http://www.w3.org/1999/html";
        }
        return value;
    }

    @Override
    public String toString() {
        return "HtmlTag:" + this.getName();
    }

    @Override
    public String getPrefixByNamespace(String namespace) {
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            namespace = "http://www.w3.org/1999/xhtml";
        }
        return super.getPrefixByNamespace(namespace);
    }
}

