/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DupOutputStream;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFS
extends ManagingFS
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    static final FileAttribute FILE_CONTENT = new FileAttribute("PersistentFS.File.Contents", 1);
    private static final int CHILDREN_CACHED_FLAG = 1;
    static final int IS_DIRECTORY_FLAG = 2;
    private static final int IS_READ_ONLY = 4;
    private static final int MUST_RELOAD_CONTENT = 8;
    static final int ALL_VALID_FLAGS = 15;
    public static final long FILE_LENGTH_TO_CACHE_THRESHOLD = 0x1400000L;
    private final FSRecords myRecords;
    private final MessageBus myEventsBus;
    private final Map<String, NewVirtualFile> myRoots = new HashMap<String, NewVirtualFile>();
    private final Object INPUT_LOCK = new Object();
    public static final int MAX_INTELLISENSE_FILESIZE = PersistentFS.maxIntellisenseFileSize();
    @NonNls
    private static final String MAX_INTELLISENSE_SIZE_PROPERTY = "idea.max.intellisense.filesize";
    private static final Comparator<VFileDeleteEvent> DEPTH_COMPARATOR = new Comparator<VFileDeleteEvent>(){

        @Override
        public int compare(VFileDeleteEvent o1, VFileDeleteEvent o2) {
            return o1.getFileDepth() - o2.getFileDepth();
        }
    };
    public static final Object LOCK = new Object();
    private final TIntObjectHashMap<NewVirtualFile> myIdToDirCache = new TIntObjectHashMap();
    private final JBLock dirCacheReadLock;
    private final JBLock dirCacheWriteLock;

    public PersistentFS(MessageBus bus) {
        JBReentrantReadWriteLock lock = LockFactory.createReadWriteLock();
        this.dirCacheReadLock = lock.readLock();
        this.dirCacheWriteLock = lock.writeLock();
        this.myEventsBus = bus;
        this.myRecords = new FSRecords();
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                LOG.info("VFS dispose started");
                PersistentFS.this.myRecords.dispose();
                LOG.info("VFS dispose completed");
            }
        });
    }

    public void disposeComponent() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("app.component.PersistentFS" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.getComponentName must not return null");
        }
        return "app.component.PersistentFS";
    }

    public void initComponent() {
        this.myRecords.connect();
    }

    private static NewVirtualFileSystem getDelegate(VirtualFile file) {
        return (NewVirtualFileSystem)file.getFileSystem();
    }

    public boolean areChildrenLoaded(VirtualFile dir) {
        return PersistentFS.areChildrenLoaded(PersistentFS.getFileId(dir));
    }

    public boolean wereChildrenAccessed(VirtualFile dir) {
        return this.myRecords.wereChildrenAccessed(PersistentFS.getFileId(dir));
    }

    public String[] list(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        if (PersistentFS.areChildrenLoaded(id)) {
            return this.listPersisted(file);
        }
        return this.persistAllChildren(file);
    }

    public String[] listPersisted(VirtualFile file) {
        return this.listPersisted(PersistentFS.getFileId(file));
    }

    private String[] listPersisted(int id) {
        int[] childrenIds = this.myRecords.list(id);
        String[] names = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names[i] = FSRecords.getName(childrenIds[i]);
        }
        return names;
    }

    private String[] persistAllChildren(VirtualFile file) {
        String[] names;
        int id = PersistentFS.getFileId(file);
        Object[] currentNames = this.listPersisted(file);
        int[] currentIds = this.myRecords.list(id);
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(file);
        String[] delegateNames = VfsUtil.filterNames((String[])delegate.list(file));
        if (delegateNames.length == 0 && currentNames.length > 0) {
            return currentNames;
        }
        if (currentNames.length == 0) {
            names = delegateNames;
        } else {
            LinkedHashSet<String> allNamesSet = new LinkedHashSet<String>((currentNames.length + delegateNames.length) * 2);
            allNamesSet.addAll(Arrays.asList(currentNames));
            allNamesSet.addAll(Arrays.asList(delegateNames));
            names = ArrayUtil.toStringArray(allNamesSet);
        }
        int[] childrenIds = ArrayUtil.newIntArray((int)names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int idx = ArrayUtil.indexOf((Object[])currentNames, (Object)name);
            if (idx >= 0) {
                childrenIds[i] = currentIds[idx];
                continue;
            }
            int childId = FSRecords.createRecord();
            this.copyRecordFromDelegateFS(childId, id, (VirtualFile)new FakeVirtualFile(file, name), delegate);
            childrenIds[i] = childId;
        }
        this.myRecords.updateList(id, childrenIds);
        int flags = FSRecords.getFlags(id);
        this.myRecords.setFlags(id, flags | 1, true);
        return names;
    }

    public int[] listIds(VirtualFile parent) {
        int parentId = PersistentFS.getFileId(parent);
        if (!PersistentFS.areChildrenLoaded(parentId)) {
            this.list(parent);
        }
        return this.myRecords.list(parentId);
    }

    private static boolean areChildrenLoaded(int parentId) {
        boolean mask = true;
        return (FSRecords.getFlags(parentId) & 1) != 0;
    }

    @Nullable
    public DataInputStream readAttribute(VirtualFile file, FileAttribute att) {
        return this.myRecords.readAttribute(PersistentFS.getFileId(file), att.getId());
    }

    public DataOutputStream writeAttribute(VirtualFile file, FileAttribute att) {
        return this.myRecords.writeAttribute(PersistentFS.getFileId(file), att.getId());
    }

    public int getModificationCount(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        return FSRecords.getModCount(id);
    }

    public int getCheapFileSystemModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private void copyRecordFromDelegateFS(int id, int parentId, VirtualFile file, NewVirtualFileSystem delegate) {
        if (id == parentId) {
            LOG.error("Cyclic parent-child relations for file: " + file);
            return;
        }
        String name = file.getName();
        if (name.length() > 0 && PersistentFS.namesEqual((VirtualFileSystem)delegate, name, FSRecords.getName(id))) {
            return;
        }
        if (name.length() == 0 && PersistentFS.areChildrenLoaded(id)) {
            return;
        }
        this.myRecords.setParent(id, parentId);
        this.myRecords.setName(id, name);
        this.myRecords.setTimestamp(id, delegate.getTimeStamp(file));
        this.myRecords.setFlags(id, (delegate.isDirectory(file) ? 2 : 0) | (delegate.isWritable(file) ? 0 : 4), true);
        this.myRecords.setLength(id, -1L);
    }

    public boolean isDirectory(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        return this.isDirectory(id);
    }

    public boolean isDirectory(int id) {
        assert (id > 0);
        return (FSRecords.getFlags(id) & 2) != 0;
    }

    public int getParent(int id) {
        assert (id > 0);
        return FSRecords.getParent(id);
    }

    private static boolean namesEqual(VirtualFileSystem fs, String n1, String n2) {
        return ((NewVirtualFileSystem)fs).isCaseSensitive() ? n1.equals(n2) : n1.equalsIgnoreCase(n2);
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        return ((VirtualFileWithId)fileOrDirectory).getId() > 0;
    }

    public long getTimeStamp(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        return FSRecords.getTimestamp(id);
    }

    public void setTimeStamp(VirtualFile file, long modstamp) throws IOException {
        int id = PersistentFS.getFileId(file);
        this.myRecords.setTimestamp(id, modstamp);
        PersistentFS.getDelegate(file).setTimeStamp(file, modstamp);
    }

    private static int getFileId(VirtualFile file) {
        int id = ((VirtualFileWithId)file).getId();
        if (id <= 0) {
            throw new InvalidVirtualFileAccessException(file);
        }
        return id;
    }

    public boolean isWritable(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        return (FSRecords.getFlags(id) & 4) == 0;
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        PersistentFS.getDelegate(file).setWritable(file, writableFlag);
        this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file, "writable", (Object)this.isWritable(file), (Object)writableFlag, false));
    }

    public int getId(VirtualFile parent, String childName) {
        int[] children;
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(parent);
        int parentId = PersistentFS.getFileId(parent);
        for (int childId : children = this.myRecords.list(parentId)) {
            if (!PersistentFS.namesEqual((VirtualFileSystem)delegate, childName, FSRecords.getName(childId))) continue;
            return childId;
        }
        FakeVirtualFile fake = new FakeVirtualFile(parent, childName);
        if (delegate.exists((VirtualFile)fake)) {
            int child = FSRecords.createRecord();
            this.copyRecordFromDelegateFS(child, parentId, (VirtualFile)fake, delegate);
            this.myRecords.updateList(parentId, ArrayUtil.append((int[])children, (int)child));
            return child;
        }
        return 0;
    }

    public long getLength(VirtualFile file) {
        int id = PersistentFS.getFileId(file);
        long len = FSRecords.getLength(id);
        if (len == -1L) {
            len = (int)PersistentFS.getDelegate(file).getLength(file);
            this.myRecords.setLength(id, len);
        }
        return len;
    }

    public VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile newParent, String copyName) throws IOException {
        PersistentFS.getDelegate(file).copyFile(requestor, file, newParent, copyName);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file, newParent, copyName));
        VirtualFile child = newParent.findChild(copyName);
        if (child == null) {
            throw new IOException("Cannot create child");
        }
        return child;
    }

    public VirtualFile createChildDirectory(Object requestor, VirtualFile parent, String dir) throws IOException {
        PersistentFS.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, false));
        VirtualFile child = parent.findChild(dir);
        if (child == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        return child;
    }

    public VirtualFile createChildFile(Object requestor, VirtualFile parent, String file) throws IOException {
        PersistentFS.getDelegate(parent).createChildFile(requestor, parent, file);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file, false, false));
        VirtualFile child = parent.findChild(file);
        if (child == null) {
            throw new IOException("Cannot create child file '" + file + "' at " + parent.getPath());
        }
        return child;
    }

    public void deleteFile(Object requestor, VirtualFile file) throws IOException {
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(file);
        delegate.deleteFile(requestor, file);
        if (!delegate.exists(file)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file, false));
        }
    }

    public void renameFile(Object requestor, VirtualFile file, String newName) throws IOException {
        PersistentFS.getDelegate(file).renameFile(requestor, file, newName);
        this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file, "name", (Object)file.getName(), (Object)newName, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        byte[] byArray;
        DataInputStream contentStream = null;
        Object object = this.INPUT_LOCK;
        // MONITORENTER : object
        boolean reloadFromDelegate = PersistentFS.mustReloadContent(file) || (contentStream = FILE_CONTENT.readAttribute(file)) == null;
        // MONITOREXIT : object
        if (!reloadFromDelegate) {
            byte[] byArray2 = FileUtil.loadBytes((InputStream)contentStream, (int)((int)file.getLength()));
            byArray = byArray2;
            if (byArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.contentsToByteArray must not return null");
            return byArray;
        }
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(file);
        byte[] content = delegate.contentsToByteArray(file);
        if ((long)content.length <= 0x1400000L) {
            Object object2 = this.INPUT_LOCK;
            // MONITORENTER : object2
            DataOutputStream sink = FILE_CONTENT.writeAttribute(file);
            try {
                FileUtil.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)sink);
            }
            finally {
                sink.close();
            }
            this.myRecords.setLength(PersistentFS.getFileId(file), content.length);
            this.setFlag(file, 8, false);
            // MONITOREXIT : object2
        }
        byArray = content;
        if (content != null) return byArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.contentsToByteArray must not return null");
    }

    private ReplicatorInputStream createReplicator(final VirtualFile file, InputStream nativeStream, final long len) {
        final ByteArrayOutputStream cache = new ByteArrayOutputStream((int)len);
        return new ReplicatorInputStream(nativeStream, cache){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                Object object = PersistentFS.this.INPUT_LOCK;
                synchronized (object) {
                    if ((long)this.getBytesRead() == len) {
                        DataOutputStream sink = FILE_CONTENT.writeAttribute(file);
                        try {
                            FileUtil.copy((InputStream)new ByteArrayInputStream(cache.toByteArray()), (OutputStream)sink);
                        }
                        finally {
                            sink.close();
                        }
                        PersistentFS.this.myRecords.setLength(PersistentFS.getFileId(file), len);
                        PersistentFS.this.setFlag(file, 8, false);
                    } else {
                        PersistentFS.this.setFlag(file, 8, true);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InputStream getInputStream(VirtualFile file) throws IOException {
        DataInputStream dataInputStream;
        InputStream inputStream;
        Object object = this.INPUT_LOCK;
        synchronized (object) {
            DataInputStream contentStream;
            if (PersistentFS.mustReloadContent(file) || (contentStream = FILE_CONTENT.readAttribute(file)) == null) {
                NewVirtualFileSystem delegate = PersistentFS.getDelegate(file);
                long len = delegate.getLength(file);
                InputStream nativeStream = delegate.getInputStream(file);
                if (len > 0x1400000L) {
                    InputStream inputStream = nativeStream;
                    // MONITOREXIT @DISABLED, blocks:[3, 9, 11] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    inputStream = inputStream;
                    if (inputStream2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.getInputStream must not return null");
                    return inputStream;
                } else {
                    ReplicatorInputStream replicatorInputStream = this.createReplicator(file, nativeStream, len);
                    // MONITOREXIT @DISABLED, blocks:[3, 8, 11] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                    inputStream = replicatorInputStream;
                    if (replicatorInputStream == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.getInputStream must not return null");
                    return inputStream;
                }
            }
            dataInputStream = contentStream;
        }
        inputStream = dataInputStream;
        if (dataInputStream != null) return inputStream;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.getInputStream must not return null");
    }

    private static boolean mustReloadContent(VirtualFile file) {
        return PersistentFS.checkFlag(file, 8) || FSRecords.getLength(PersistentFS.getFileId(file)) == -1L;
    }

    @NotNull
    public OutputStream getOutputStream(final VirtualFile file, final Object requestor, final long modStamp, final long timeStamp) throws IOException {
        final VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file, file.getModificationStamp(), modStamp, false);
        final List<VFileContentChangeEvent> events = Collections.singletonList(event);
        final BulkFileListener publisher = (BulkFileListener)this.myEventsBus.syncPublisher(VirtualFileManager.VFS_CHANGES);
        publisher.before(events);
        ByteArrayOutputStream stream = new ByteArrayOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                super.close();
                OutputStream delegate = PersistentFS.getDelegate(file).getOutputStream(file, requestor, modStamp, timeStamp);
                DupOutputStream sink = new DupOutputStream(new BufferedOutputStream(FILE_CONTENT.writeAttribute(file)), delegate){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            PersistentFS.this.executeTouch(file, false, event.getModificationStamp());
                            publisher.after(events);
                        }
                    }
                };
                try {
                    sink.write(this.buf, 0, this.count);
                }
                finally {
                    sink.close();
                }
            }
        };
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        ByteArrayOutputStream byteArrayOutputStream = stream;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS.getOutputStream must not return null");
        }
        return byteArrayOutputStream;
    }

    public void moveFile(Object requestor, VirtualFile file, VirtualFile newParent) throws IOException {
        PersistentFS.getDelegate(file).moveFile(requestor, file, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file, newParent));
    }

    private void processEvent(VFileEvent event) {
        this.processEvents(Collections.singletonList(event));
    }

    private static List<? extends VFileEvent> validateEvents(List<? extends VFileEvent> events) {
        ArrayList<Object> filtered = new ArrayList<Object>(events.size());
        ArrayList<VFileDeleteEvent> deletionList = new ArrayList<VFileDeleteEvent>();
        for (VFileEvent vFileEvent : events) {
            if (!vFileEvent.isValid()) continue;
            if (vFileEvent instanceof VFileDeleteEvent) {
                deletionList.add((VFileDeleteEvent)vFileEvent);
                continue;
            }
            filtered.add(vFileEvent);
        }
        ContainerUtil.quickSort(deletionList, DEPTH_COMPARATOR);
        ArrayList<VirtualFile> filesToBeDeleted = new ArrayList<VirtualFile>();
        for (VFileDeleteEvent event : deletionList) {
            boolean ok = true;
            VirtualFile candidate = event.getFile();
            for (VirtualFile file : filesToBeDeleted) {
                if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)candidate, (boolean)false)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            filtered.add(event);
            if (!candidate.isDirectory()) continue;
            filesToBeDeleted.add(candidate);
        }
        return filtered;
    }

    public void processEvents(List<? extends VFileEvent> events) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        events = PersistentFS.validateEvents(events);
        ((BulkFileListener)this.myEventsBus.syncPublisher(VirtualFileManager.VFS_CHANGES)).before(events);
        for (VFileEvent vFileEvent : events) {
            this.applyEvent(vFileEvent);
        }
        ((BulkFileListener)this.myEventsBus.syncPublisher(VirtualFileManager.VFS_CHANGES)).after(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NewVirtualFile findRoot(String basePath, final NewVirtualFileSystem fs) {
        Object object = LOCK;
        synchronized (object) {
            String rootUrl = fs.getProtocol() + "://" + basePath;
            NewVirtualFile root = this.myRoots.get(rootUrl);
            if (root == null) {
                try {
                    int rootId = this.myRecords.findRootRecord(rootUrl);
                    root = basePath.length() > 0 ? new VirtualDirectoryImpl(basePath, null, fs, rootId) : new VirtualDirectoryImpl(basePath, null, fs, rootId){

                        @Override
                        @NotNull
                        public VirtualFile[] getChildren() {
                            VirtualFile[] virtualFileArray = PersistentFS.this.getRoots(fs);
                            if (virtualFileArray == null) {
                                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/newvfs/persistent/PersistentFS$5.getChildren must not return null");
                            }
                            return virtualFileArray;
                        }
                    };
                    if (!fs.exists((VirtualFile)root)) {
                        return null;
                    }
                    this.copyRecordFromDelegateFS(rootId, 0, (VirtualFile)root, fs);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (basePath.length() > 0) {
                    this.myRoots.put(rootUrl, root);
                }
            }
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean asynchronous) {
        NewVirtualFile[] roots;
        Object object = LOCK;
        synchronized (object) {
            Collection<NewVirtualFile> values = this.myRoots.values();
            roots = values.toArray(new NewVirtualFile[values.size()]);
        }
        RefreshQueue.getInstance().refresh(asynchronous, true, null, (VirtualFile[])roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile[] getLocalRoots() {
        ArrayList<NewVirtualFile> roots;
        Object object = LOCK;
        synchronized (object) {
            roots = new ArrayList<NewVirtualFile>(this.myRoots.values());
            Iterator it = roots.iterator();
            while (it.hasNext()) {
                NewVirtualFile file = (NewVirtualFile)it.next();
                if (file.isInLocalFileSystem()) continue;
                it.remove();
            }
        }
        return VfsUtil.toVirtualFileArray(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIdCache() {
        try {
            this.dirCacheWriteLock.lock();
            this.myIdToDirCache.clear();
        }
        finally {
            this.dirCacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NewVirtualFile findFileById(int id) {
        try {
            this.dirCacheReadLock.lock();
            NewVirtualFile cached = (NewVirtualFile)this.myIdToDirCache.get(id);
            if (cached != null) {
                NewVirtualFile newVirtualFile = cached;
                return newVirtualFile;
            }
        }
        finally {
            this.dirCacheReadLock.unlock();
        }
        NewVirtualFile result = this.doFindFile(id);
        if (result != null && result.isDirectory()) {
            try {
                this.dirCacheWriteLock.lock();
                this.myIdToDirCache.put(id, (Object)result);
            }
            finally {
                this.dirCacheWriteLock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NewVirtualFile doFindFile(int id) {
        int parentId = this.getParent(id);
        if (parentId == 0) {
            Object object = LOCK;
            synchronized (object) {
                for (NewVirtualFile root : this.myRoots.values()) {
                    if (root.getId() != id) continue;
                    return root;
                }
                return null;
            }
        }
        NewVirtualFile parentFile = this.findFileById(parentId);
        return parentFile != null ? parentFile.findChildById(id) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile[] getRoots() {
        Object object = LOCK;
        synchronized (object) {
            Collection<NewVirtualFile> roots = this.myRoots.values();
            return VfsUtil.toVirtualFileArray(roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile[] getRoots(NewVirtualFileSystem fs) {
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        Object object = LOCK;
        synchronized (object) {
            for (NewVirtualFile root : this.myRoots.values()) {
                if (root.getFileSystem() != fs) continue;
                roots.add(root);
            }
        }
        return VfsUtil.toVirtualFileArray(roots);
    }

    private void applyEvent(VFileEvent event) {
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                this.executeCreateChild(createEvent.getParent(), createEvent.getChildName());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                this.executeTouch(contentUpdateEvent.getFile(), contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp());
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                this.executeCopy(copyEvent.getFile(), copyEvent.getNewParent(), copyEvent.getNewChildName());
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    this.executeRename(propertyChangeEvent.getFile(), (String)propertyChangeEvent.getNewValue());
                } else if ("writable".equals(propertyChangeEvent.getPropertyName())) {
                    this.executeSetWritable(propertyChangeEvent.getFile(), (Boolean)propertyChangeEvent.getNewValue());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NonNls
    public String toString() {
        return "PersistentFS";
    }

    private void executeCreateChild(VirtualFile parent, String name) {
        FakeVirtualFile fakeFile;
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(parent);
        if (delegate.exists((VirtualFile)(fakeFile = new FakeVirtualFile(parent, name)))) {
            int parentId = PersistentFS.getFileId(parent);
            int childId = FSRecords.createRecord();
            this.copyRecordFromDelegateFS(childId, parentId, (VirtualFile)fakeFile, delegate);
            this.appendIdToParentList(parentId, childId);
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            dir.addChild((VirtualFile)dir.createChild(name, childId));
        }
    }

    private void appendIdToParentList(int parentId, int childId) {
        int[] childrenlist = this.myRecords.list(parentId);
        childrenlist = ArrayUtil.append((int[])childrenlist, (int)childId);
        this.myRecords.updateList(parentId, childrenlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(VirtualFile file) {
        if (!file.exists()) {
            LOG.error("Deleting a file, which does not exist: " + file.getPath());
        } else {
            this.clearIdCache();
            int id = PersistentFS.getFileId(file);
            VirtualFile parent = file.getParent();
            int parentId = parent != null ? PersistentFS.getFileId(parent) : 0;
            this.myRecords.deleteRecordRecursively(id);
            if (parentId != 0) {
                this.removeIdFromParentList(parentId, id);
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file.getParent();
                assert (directory != null);
                directory.removeChild(file);
            } else {
                Object object = LOCK;
                synchronized (object) {
                    this.myRoots.remove(file.getUrl());
                    try {
                        this.myRecords.deleteRootRecord(id);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            PersistentFS.invalidateSubtree(file);
        }
    }

    private static void invalidateSubtree(VirtualFile file) {
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file;
        impl.invalidate();
        for (VirtualFile child : impl.getCachedChildren()) {
            PersistentFS.invalidateSubtree(child);
        }
    }

    private void removeIdFromParentList(int parentId, int id) {
        int[] childList = this.myRecords.list(parentId);
        childList = ArrayUtil.remove((int[])childList, (int)ArrayUtil.indexOf((int[])childList, (int)id));
        this.myRecords.updateList(parentId, childList);
    }

    private void executeRename(VirtualFile file, String newName) {
        ((VirtualFileSystemEntry)file).setName(newName);
        int id = PersistentFS.getFileId(file);
        this.myRecords.setName(id, newName);
    }

    private void executeSetWritable(VirtualFile file, boolean writableFlag) {
        this.setFlag(file, 4, !writableFlag);
    }

    private void setFlag(VirtualFile file, int mask, boolean value) {
        this.setFlag(PersistentFS.getFileId(file), mask, value);
    }

    private void setFlag(int id, int mask, boolean value) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            this.myRecords.setFlags(id, flags, true);
        }
    }

    private static boolean checkFlag(VirtualFile file, int mask) {
        return (FSRecords.getFlags(PersistentFS.getFileId(file)) & mask) != 0;
    }

    private void executeTouch(VirtualFile file, boolean reloadContentFromDelegate, long newModificationStamp) {
        if (reloadContentFromDelegate) {
            this.setFlag(file, 8, true);
        }
        NewVirtualFileSystem delegate = PersistentFS.getDelegate(file);
        this.myRecords.setLength(PersistentFS.getFileId(file), delegate.getLength(file));
        this.myRecords.setTimestamp(PersistentFS.getFileId(file), delegate.getTimeStamp(file));
        ((NewVirtualFile)file).setModificationStamp(newModificationStamp);
    }

    private void executeCopy(VirtualFile from, VirtualFile newParent, String copyName) {
        this.executeCreateChild(newParent, copyName);
    }

    private void executeMove(VirtualFile what, VirtualFile newParent) {
        int whatId = PersistentFS.getFileId(what);
        int newParentId = PersistentFS.getFileId(newParent);
        int oldParentId = PersistentFS.getFileId(what.getParent());
        this.removeIdFromParentList(oldParentId, whatId);
        this.appendIdToParentList(newParentId, whatId);
        ((VirtualFileSystemEntry)what).setParent(newParent);
        this.myRecords.setParent(whatId, newParentId);
    }

    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContents() {
        try {
            int[] roots;
            for (int root : roots = this.myRecords.listRoots()) {
                this.cleanPersistedContentsRecursively(root);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanPersistedContentsRecursively(int id) {
        if (this.isDirectory(id)) {
            for (int child : this.myRecords.list(id)) {
                this.cleanPersistedContentsRecursively(child);
            }
        } else {
            this.setFlag(id, 8, true);
        }
    }

    private static int maxIntellisenseFileSize() {
        int maxLimitBytes = 0x1400000;
        String userLimitKb = System.getProperty(MAX_INTELLISENSE_SIZE_PROPERTY);
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, 0x1400000) : 0x1400000;
        }
        catch (NumberFormatException ignored) {
            return 0x1400000;
        }
    }
}

