/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.pending;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Collection;
import java.util.List;

public class MockChangeListManagerGate
implements ChangeListManagerGate {
    private final ChangeListManager myManager;

    public MockChangeListManagerGate(ChangeListManager manager) {
        this.myManager = manager;
    }

    public List<LocalChangeList> getListsCopy() {
        return this.myManager.getChangeListsCopy();
    }

    public LocalChangeList findChangeList(String name) {
        return this.myManager.findChangeList(name);
    }

    public LocalChangeList addChangeList(String name, String comment) {
        return this.myManager.addChangeList(name, comment);
    }

    public LocalChangeList findOrCreateList(String name, String comment) {
        LocalChangeList changeList = this.myManager.findChangeList(name);
        if (changeList == null) {
            changeList = this.myManager.addChangeList(name, comment);
        }
        return changeList;
    }

    public void editComment(String name, String comment) {
        this.myManager.editComment(name, comment);
    }

    public void editName(String oldName, String newName) {
        this.myManager.editName(oldName, newName);
    }

    public void moveChanges(String toList, Collection<Change> changes) {
        LocalChangeList changeList = this.myManager.findChangeList(toList);
        if (changeList != null) {
            this.myManager.moveChangesTo(changeList, changes.toArray(new Change[changes.size()]));
        }
    }

    public void setListsToDisappear(Collection<String> names) {
    }
}

