/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.packaging;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.packaging.PackagingEditorUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Icons;
import java.util.List;
import javax.swing.Icon;

public class ChooseLibrariesDialog
extends ChooseElementsDialog<Library> {
    public ChooseLibrariesDialog(Project project, List<? extends Library> items, String title, String description) {
        super(project, items, title, description, true);
    }

    @Override
    protected String getItemText(Library item) {
        return item != null ? PackagingEditorUtil.getLibraryItemText(item, true) : "";
    }

    @Override
    protected Icon getItemIcon(Library item) {
        if (item.getName() != null) {
            return Icons.LIBRARY_ICON;
        }
        VirtualFile[] files = item.getFiles(OrderRootType.CLASSES);
        if (files.length == 1) {
            return files[0].getFileType().getIcon();
        }
        return Icons.LIBRARY_ICON;
    }
}

