/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.ui.ArtifactProblemsHolderBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactProblemsHolderImpl
extends ArtifactProblemsHolderBase {
    private ProjectStructureProblemsHolder myProblemsHolder;

    public ArtifactProblemsHolderImpl(ArtifactEditorContext context, ProjectStructureProblemsHolder problemsHolder) {
        super(context);
        this.myProblemsHolder = problemsHolder;
    }

    public void registerError(@NotNull String message, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerError must not be null");
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerError must not be null");
        }
        this.registerProblem(message, pathToPlace, ProjectStructureProblemDescription.Severity.ERROR, quickFixes);
    }

    private void registerProblem(@NotNull String message, @Nullable List<PackagingElement<?>> pathToPlace, ProjectStructureProblemDescription.Severity severity, ArtifactProblemQuickFix ... quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerProblem must not be null");
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerProblem must not be null");
        }
        this.myProblemsHolder.registerProblem(new ArtifactProblemDescription(message, severity, pathToPlace, Arrays.asList(quickFixes)));
    }

    public void registerWarning(@NotNull String message, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerWarning must not be null");
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl.registerWarning must not be null");
        }
        this.registerProblem(message, pathToPlace, ProjectStructureProblemDescription.Severity.WARNING, quickFixes);
    }
}

