/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.scopes.ModuleRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ModuleImpl
extends ComponentManagerImpl
implements Module {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleImpl");
    @NotNull
    private final Project myProject;
    private ModuleType myModuleType = null;
    private boolean isModuleAdded;
    private GlobalSearchScope myModuleScope = null;
    @NonNls
    private static final String MODULE_LAYER = "module-components";
    @NonNls
    private static final String OPTION_WORKSPACE = "workspace";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    private ModuleWithDependenciesScope myModuleWithLibrariesScope;
    private ModuleWithDependenciesScope myModuleWithDependenciesScope;
    private ModuleWithDependenciesScope myModuleWithDependenciesAndLibrariesScope;
    private ModuleWithDependenciesScope myModuleWithDependenciesAndLibrariesNoTestsScope;
    private ModuleWithDependentsScope myModuleWithDependentsScope;
    private ModuleWithDependentsScope myModuleTestsWithDependentsScope;
    private ModuleRuntimeClasspathScope myModuleTestsRuntimeClasspathScope;
    private ModuleRuntimeClasspathScope myModuleRuntimeClasspathScope;
    public static final Object MODULE_RENAMING_REQUESTOR = new Object();
    private String myName;

    public ModuleImpl(String filePath, Project project) {
        super((ComponentManager)project);
        this.getPicoContainer().registerComponentInstance(Module.class, (Object)this);
        this.myProject = project;
        this.init(filePath);
    }

    @Override
    protected void boostrapPicoContainer() {
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, (AreaInstance)((AreaInstance)this.getParentComponentManager()));
        super.boostrapPicoContainer();
        this.getPicoContainer().registerComponentImplementation(IComponentStore.class, ModuleStoreImpl.class);
        this.getPicoContainer().registerComponentImplementation(ModulePathMacroManager.class);
    }

    @Override
    @NotNull
    public IModuleStore getStateStore() {
        IModuleStore iModuleStore = (IModuleStore)super.getStateStore();
        if (iModuleStore == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleImpl.getStateStore must not return null");
        }
        return iModuleStore;
    }

    private void init(String filePath) {
        this.getStateStore().setModuleFilePath(filePath);
        this.myName = ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath));
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this);
    }

    public void loadModuleComponents() {
        IdeaPluginDescriptor[] plugins;
        for (IdeaPluginDescriptor plugin : plugins = PluginManager.getPlugins()) {
            if (PluginManager.shouldSkipPlugin((IdeaPluginDescriptor)plugin)) continue;
            this.loadComponentsConfiguration(plugin.getModuleComponents(), plugin, false);
        }
    }

    @Override
    protected boolean isComponentSuitable(Map<String, String> options) {
        if (!super.isComponentSuitable(options)) {
            return false;
        }
        if (options == null) {
            return true;
        }
        Set<String> optionNames = options.keySet();
        for (String optionName : optionNames) {
            if (Comparing.equal((String)OPTION_WORKSPACE, (String)optionName) || ModuleImpl.parseOptionValue(options.get(optionName)).contains(this.getOptionValue(optionName))) continue;
            return false;
        }
        return true;
    }

    private static List<String> parseOptionValue(String optionValue) {
        if (optionValue == null) {
            return new ArrayList<String>(0);
        }
        return Arrays.asList(optionValue.split(";"));
    }

    @Nullable
    public VirtualFile getModuleFile() {
        return this.getStateStore().getModuleFile();
    }

    void rename(String newName) {
        this.myName = newName;
        VirtualFile file = this.getStateStore().getModuleFile();
        try {
            if (file != null) {
                ClasspathStorage.moduleRenamed(this, newName);
                file.rename(MODULE_RENAMING_REQUESTOR, newName + ".iml");
                this.getStateStore().setModuleFilePath(VfsUtil.virtualToIoFile((VirtualFile)file).getCanonicalPath());
                return;
            }
            File oldFile = new File(this.getModuleFilePath());
            File parentFile = oldFile.getParentFile();
            File newFile = new File(parentFile, newName + ".iml");
            this.getStateStore().setModuleFilePath(newFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @NotNull
    public String getModuleFilePath() {
        String string = this.getStateStore().getModuleFilePath();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleImpl.getModuleFilePath must not return null");
        }
        return string;
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
    }

    public void projectOpened() {
        for (ModuleComponent component : this.getComponents(ModuleComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void projectClosed() {
        ArrayList<ModuleComponent> components = new ArrayList<ModuleComponent>(Arrays.asList(this.getComponents(ModuleComponent.class)));
        Collections.reverse(components);
        for (ModuleComponent component : components) {
            try {
                component.projectClosed();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public ModuleType getModuleType() {
        LOG.assertTrue(this.myModuleType != null, (Object)"Module type not initialized yet");
        ModuleType moduleType = this.myModuleType;
        if (moduleType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleImpl.getModuleType must not return null");
        }
        return moduleType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleImpl.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleImpl.getName must not return null");
        }
        return string;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component : this.getComponents(ModuleComponent.class)) {
            component.moduleAdded();
        }
    }

    public void setModuleType(ModuleType type) {
        this.myModuleType = type;
        this.setOption(ELEMENT_TYPE, type.getId());
    }

    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleImpl.setOption must not be null");
        }
        if (optionValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleImpl.setOption must not be null");
        }
        this.getStateStore().setOption(optionName, optionValue);
    }

    public void clearOption(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleImpl.clearOption must not be null");
        }
        this.getStateStore().clearOption(optionName);
    }

    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleImpl.getOptionValue must not be null");
        }
        return this.getStateStore().getOptionValue(optionName);
    }

    public GlobalSearchScope getModuleScope() {
        if (this.myModuleScope == null) {
            this.myModuleScope = new ModuleWithDependenciesScope(this, false, false, true);
        }
        return this.myModuleScope;
    }

    public GlobalSearchScope getModuleWithLibrariesScope() {
        if (this.myModuleWithLibrariesScope == null) {
            this.myModuleWithLibrariesScope = new ModuleWithDependenciesScope(this, true, false, true);
        }
        return this.myModuleWithLibrariesScope;
    }

    public GlobalSearchScope getModuleWithDependenciesScope() {
        if (this.myModuleWithDependenciesScope == null) {
            this.myModuleWithDependenciesScope = new ModuleWithDependenciesScope(this, false, true, true);
        }
        return this.myModuleWithDependenciesScope;
    }

    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        if (includeTests) {
            if (this.myModuleWithDependenciesAndLibrariesScope == null) {
                this.myModuleWithDependenciesAndLibrariesScope = new ModuleWithDependenciesScope(this, true, true, true);
            }
            return this.myModuleWithDependenciesAndLibrariesScope;
        }
        if (this.myModuleWithDependenciesAndLibrariesNoTestsScope == null) {
            this.myModuleWithDependenciesAndLibrariesNoTestsScope = new ModuleWithDependenciesScope(this, true, true, false);
        }
        return this.myModuleWithDependenciesAndLibrariesNoTestsScope;
    }

    public GlobalSearchScope getModuleWithDependentsScope() {
        if (this.myModuleWithDependentsScope == null) {
            this.myModuleWithDependentsScope = new ModuleWithDependentsScope(this, false);
        }
        return this.myModuleWithDependentsScope;
    }

    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        if (this.myModuleTestsWithDependentsScope == null) {
            this.myModuleTestsWithDependentsScope = new ModuleWithDependentsScope(this, true);
        }
        return this.myModuleTestsWithDependentsScope;
    }

    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        if (includeTests) {
            if (this.myModuleTestsRuntimeClasspathScope == null) {
                this.myModuleTestsRuntimeClasspathScope = new ModuleRuntimeClasspathScope(this, true);
            }
            return this.myModuleTestsRuntimeClasspathScope;
        }
        if (this.myModuleRuntimeClasspathScope == null) {
            this.myModuleRuntimeClasspathScope = new ModuleRuntimeClasspathScope(this, false);
        }
        return this.myModuleRuntimeClasspathScope;
    }

    public void clearScopesCache() {
        this.myModuleWithLibrariesScope = null;
        this.myModuleWithDependenciesScope = null;
        this.myModuleWithDependenciesAndLibrariesScope = null;
        this.myModuleWithDependenciesAndLibrariesNoTestsScope = null;
        this.myModuleWithDependentsScope = null;
        this.myModuleTestsWithDependentsScope = null;
        this.myModuleTestsRuntimeClasspathScope = null;
        this.myModuleRuntimeClasspathScope = null;
    }

    public String toString() {
        return "Module:" + this.getName() + " path:" + this.getModuleFilePath();
    }

    private static String moduleNameByFileName(String fileName) {
        if (fileName.endsWith(".iml")) {
            return fileName.substring(0, fileName.length() - ".iml".length());
        }
        return fileName;
    }

    public <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(VirtualFilePropertyEvent event) {
            if (!ModuleImpl.this.isModuleAdded) {
                return;
            }
            Object requestor = event.getRequestor();
            if (MODULE_RENAMING_REQUESTOR.equals(requestor)) {
                return;
            }
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile moduleFile = ModuleImpl.this.getModuleFile();
            if (moduleFile == null) {
                return;
            }
            if (moduleFile.equals(event.getFile())) {
                ModuleImpl.this.myName = ModuleImpl.moduleNameByFileName(moduleFile.getName());
                ModuleManagerImpl.getInstanceImpl(ModuleImpl.this.getProject()).fireModuleRenamedByVfsEvent(ModuleImpl.this);
            }
        }
    }
}

