/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeDiffTool
implements DiffTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.CompositeDiffTool");
    private final List<DiffTool> myTools;

    public CompositeDiffTool(List<DiffTool> tools) {
        this.myTools = new ArrayList<DiffTool>(tools);
    }

    public void show(DiffRequest data) {
        CompositeDiffTool.checkDiffData(data);
        DiffTool tool = this.chooseTool(data);
        if (tool != null) {
            tool.show(data);
        } else {
            LOG.error("No diff tool found which is able to handle request " + data);
        }
    }

    public boolean canShow(DiffRequest data) {
        CompositeDiffTool.checkDiffData(data);
        return this.chooseTool(data) != null;
    }

    @Nullable
    private DiffTool chooseTool(DiffRequest data) {
        for (DiffTool tool : this.myTools) {
            if (!tool.canShow(data)) continue;
            return tool;
        }
        return null;
    }

    private static void checkDiffData(@NotNull DiffRequest data) {
        DiffContent[] contents;
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/external/CompositeDiffTool.checkDiffData must not be null");
        }
        for (DiffContent content : contents = data.getContents()) {
            LOG.assertTrue(content != null);
        }
    }
}

