/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.actions.BaseDiffAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.Nullable;

public class CompareClipboardWithSelection
extends BaseDiffAction {
    @Override
    @Nullable
    protected DiffRequest getDiffData(DataContext dataContext) {
        Editor editor;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editorData = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        Editor editor2 = editor = editorData != null ? editorData : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        return new ClipboardSelectionContents(editor, project);
    }

    private static class ClipboardSelectionContents
    extends DiffRequest {
        private DiffContent[] myContents = null;
        private final Editor myEditor;

        public ClipboardSelectionContents(Editor editor, Project project) {
            super(project);
            this.myEditor = editor;
        }

        public String[] getContentTitles() {
            return new String[]{DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]), BaseDiffAction.isEditorContent(this.getDocument()) ? DiffBundle.message((String)"diff.content.selection.from.editor.content.title", (Object[])new Object[0]) : DiffBundle.message((String)"diff.content.selection.from.file.content.title", (Object[])new Object[]{BaseDiffAction.getDocumentFileUrl(this.getDocument())})};
        }

        public DiffContent[] getContents() {
            if (this.myContents != null) {
                return this.myContents;
            }
            DiffContent clipboardContent = ClipboardSelectionContents.createClipboardContent();
            if (clipboardContent == null) {
                return null;
            }
            this.myContents = new DiffContent[2];
            this.myContents[0] = clipboardContent;
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                TextRange range = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                this.myContents[1] = new FragmentContent((DiffContent)DocumentContent.fromDocument((Project)this.getProject(), (Document)this.getDocument()), range, this.getProject(), BaseDiffAction.getDocumentFile(this.getDocument()));
            } else {
                this.myContents[1] = DocumentContent.fromDocument((Project)this.getProject(), (Document)this.getDocument());
            }
            return this.myContents;
        }

        private Document getDocument() {
            return this.myEditor.getDocument();
        }

        public String getWindowTitle() {
            if (BaseDiffAction.isEditorContent(this.getDocument())) {
                return DiffBundle.message((String)"diff.clipboard.vs.editor.dialog.title", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.clipboard.vs.file.dialog.title", (Object[])new Object[]{BaseDiffAction.getDocumentFileUrl(this.getDocument())});
        }

        private static DiffContent createClipboardContent() {
            String text;
            Transferable content = CopyPasteManager.getInstance().getContents();
            try {
                text = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return null;
            }
            return text != null ? new SimpleContent(text) : null;
        }
    }
}

