/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PrattBuilderFacade;
import com.intellij.lang.pratt.PrattTokenType;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PrattBuilder {
    public abstract Lexer getLexer();

    public abstract void setTokenTypeRemapper(@Nullable ITokenTypeRemapper var1);

    public abstract MutableMarker mark();

    public PrattBuilderFacade createChildBuilder(int priority, @Nullable String expectedMessage) {
        return this.createChildBuilder(priority).expecting(expectedMessage);
    }

    public PrattBuilderFacade createChildBuilder(int priority) {
        return this.createChildBuilder().withLowestPriority(priority);
    }

    @Nullable
    public IElementType parseChildren(int priority, @Nullable String expectedMessage) {
        return this.createChildBuilder(priority, expectedMessage).parse();
    }

    protected abstract PrattBuilderFacade createChildBuilder();

    public boolean assertToken(PrattTokenType type) {
        if (this.checkToken(type)) {
            return true;
        }
        this.error(type.getExpectedText(this));
        return false;
    }

    public boolean assertToken(IElementType type, @NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/pratt/PrattBuilder.assertToken must not be null");
        }
        if (this.checkToken(type)) {
            return true;
        }
        this.error(errorMessage);
        return false;
    }

    public boolean checkToken(IElementType type) {
        if (this.isToken(type)) {
            this.advance();
            return true;
        }
        return false;
    }

    public abstract void advance();

    public abstract void error(String var1);

    public boolean isEof() {
        return this.isToken(null);
    }

    public boolean isToken(@Nullable IElementType type) {
        return this.getTokenType() == type;
    }

    @Nullable
    public abstract IElementType getTokenType();

    @Nullable
    public abstract String getTokenText();

    public abstract void reduce(@NotNull IElementType var1);

    public ListIterator<IElementType> getBackResultIterator() {
        LinkedList<IElementType> resultTypes = this.getResultTypes();
        return resultTypes.listIterator(resultTypes.size());
    }

    public abstract LinkedList<IElementType> getResultTypes();

    public abstract PrattBuilder getParent();

    public abstract int getPriority();

    public abstract int getCurrentOffset();
}

