/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    private boolean mySuggestSearchInLibs;
    private boolean myPrevSearchFiles;
    private NamedScopesHolder.ScopeListener myScopeListener;
    private NamedScopeManager myNamedScopeManager;
    private DependencyValidationManager myValidationManager;

    public ScopeChooserCombo() {
    }

    public ScopeChooserCombo(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project, String preselect) {
        this.init(project, false, true, preselect);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.mySuggestSearchInLibs = suggestSearchInLibs;
        this.myPrevSearchFiles = prevSearchWholeFiles;
        JComboBox combo = this.getComboBox();
        this.myProject = project;
        this.myScopeListener = new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                SearchScope selectedScope = ScopeChooserCombo.this.getSelectedScope();
                ScopeChooserCombo.this.rebuildModel();
                if (selectedScope != null) {
                    ScopeChooserCombo.this.selectScope(selectedScope.getDisplayName());
                }
            }
        };
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.addActionListener(this.createScopeChooserListener());
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ScopeDescriptor) {
                    this.setText(((ScopeDescriptor)value).getDisplay());
                }
                return this;
            }
        });
        this.rebuildModel();
        this.selectScope(preselect);
    }

    public void dispose() {
        super.dispose();
        if (this.myValidationManager != null) {
            this.myValidationManager.removeScopeListener(this.myScopeListener);
            this.myValidationManager = null;
        }
        if (this.myNamedScopeManager != null) {
            this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
            this.myNamedScopeManager = null;
        }
        this.myScopeListener = null;
    }

    private void selectScope(String preselect) {
        if (preselect != null) {
            JComboBox combo = this.getComboBox();
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ScopeDescriptor descriptor = (ScopeDescriptor)model.getElementAt(i);
                if (!preselect.equals(descriptor.getDisplay())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private ActionListener createScopeChooserListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String selection = ScopeChooserCombo.this.getSelectedScopeName();
                final ScopeChooserConfigurable chooserConfigurable = ScopeChooserConfigurable.getInstance(ScopeChooserCombo.this.myProject);
                EditScopesDialog dlg = EditScopesDialog.editConfigurable(ScopeChooserCombo.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        if (selection != null) {
                            chooserConfigurable.selectNodeInTree(selection);
                        }
                    }
                });
                if (dlg.isOK()) {
                    ScopeChooserCombo.this.rebuildModel();
                    NamedScope namedScope = dlg.getSelectedScope();
                    if (namedScope != null) {
                        ScopeChooserCombo.this.selectScope(namedScope.getName());
                    }
                }
            }
        };
    }

    private void rebuildModel() {
        this.getComboBox().setModel(this.createModel());
    }

    private DefaultComboBoxModel createModel() {
        NamedScopesHolder[] holders;
        DefaultComboBoxModel<ScopeDescriptor> model = new DefaultComboBoxModel<ScopeDescriptor>();
        this.createPredefinedScopeDescriptors(model);
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                model.addElement(new ScopeDescriptor((SearchScope)GlobalSearchScope.filterScope((Project)this.myProject, (NamedScope)scope)));
            }
        }
        return model;
    }

    private void createPredefinedScopeDescriptors(DefaultComboBoxModel model) {
        for (SearchScope scope : ScopeChooserCombo.getPredefinedScopes(this.myProject, DataManager.getInstance().getDataContext(), this.mySuggestSearchInLibs, this.myPrevSearchFiles, true, true)) {
            model.addElement(new ScopeDescriptor(scope));
        }
        for (ScopeDescriptorProvider provider : (ScopeDescriptorProvider[])Extensions.getExtensions(ScopeDescriptorProvider.EP_NAME)) {
            for (ScopeDescriptor scopeDescriptor : provider.getScopeDescriptors(this.myProject)) {
                model.addElement(scopeDescriptor);
            }
        }
    }

    public static List<SearchScope> getPredefinedScopes(final @NotNull Project project, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView) {
        FavoritesManager favoritesManager;
        String[] favoritesLists;
        UsageView selectedUsageView;
        PsiElement parent;
        PsiElement endElement;
        PsiElement startElement;
        PsiFile psiFile;
        FileEditorManager fileEditorManager;
        Editor selectedTextEditor;
        PsiElement dataContextElement;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/scopeChooser/ScopeChooserCombo.getPredefinedScopes must not be null");
        }
        ArrayList<SearchScope> result = new ArrayList<SearchScope>();
        result.add((SearchScope)GlobalSearchScope.projectScope((Project)project));
        if (suggestSearchInLibs) {
            result.add((SearchScope)GlobalSearchScope.allScope((Project)project));
        }
        result.add((SearchScope)GlobalSearchScope.projectProductionScope((Project)project));
        result.add((SearchScope)GlobalSearchScope.projectTestScope((Project)project));
        if (dataContext != null && (dataContextElement = ScopeChooserCombo.getDataContextElement(dataContext)) != null) {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)dataContextElement);
            if (module == null) {
                module = (Module)LangDataKeys.MODULE.getData(dataContext);
            }
            if (module != null) {
                result.add((SearchScope)module.getModuleScope());
            }
            if (dataContextElement.getContainingFile() != null) {
                result.add((SearchScope)new LocalSearchScope(dataContextElement, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
            }
        }
        if (currentSelection && (selectedTextEditor = (fileEditorManager = FileEditorManager.getInstance((Project)project)).getSelectedTextEditor()) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedTextEditor.getDocument())) != null && selectedTextEditor.getSelectionModel().hasSelection() && (startElement = psiFile.findElementAt(selectedTextEditor.getSelectionModel().getSelectionStart())) != null && (endElement = psiFile.findElementAt(selectedTextEditor.getSelectionModel().getSelectionEnd())) != null && (parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement)) != null) {
            PsiElement[] children;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (PsiElement child : children = parent.getChildren()) {
                if (child instanceof PsiWhiteSpace) continue;
                elements.add(child);
            }
            if (!elements.isEmpty()) {
                LocalSearchScope local = new LocalSearchScope(elements.toArray(new PsiElement[elements.size()]), IdeBundle.message((String)"scope.selection", (Object[])new Object[0]));
                result.add((SearchScope)local);
            }
        }
        if (!ChangeListManager.getInstance((Project)project).getAffectedFiles().isEmpty()) {
            GlobalSearchScope modified = new GlobalSearchScope(project){

                public String getDisplayName() {
                    return IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]);
                }

                public boolean contains(VirtualFile file) {
                    return ChangeListManager.getInstance((Project)project).getChange(file) != null;
                }

                public int compare(VirtualFile file1, VirtualFile file2) {
                    return 0;
                }

                public boolean isSearchInModuleContent(@NotNull Module aModule) {
                    if (aModule == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/scopeChooser/ScopeChooserCombo$4.isSearchInModuleContent must not be null");
                    }
                    return true;
                }

                public boolean isSearchInLibraries() {
                    return false;
                }
            };
            result.add((SearchScope)modified);
        }
        if (usageView && (selectedUsageView = UsageViewManager.getInstance((Project)project).getSelectedUsageView()) != null && !selectedUsageView.isSearchInProgress()) {
            Set usages = selectedUsageView.getUsages();
            ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
            if (prevSearchFiles) {
                final HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (Usage usage : usages) {
                    VirtualFile file;
                    PsiFile psiFile2;
                    PsiElement psiElement;
                    if (!(usage instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage).getElement()) == null || !psiElement.isValid() || (psiFile2 = psiElement.getContainingFile()) == null || (file = psiFile2.getVirtualFile()) == null) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    GlobalSearchScope prev = new GlobalSearchScope(project){

                        public String getDisplayName() {
                            return IdeBundle.message((String)"scope.files.in.previous.search.result", (Object[])new Object[0]);
                        }

                        public boolean contains(VirtualFile file) {
                            return files.contains(file);
                        }

                        public int compare(VirtualFile file1, VirtualFile file2) {
                            return 0;
                        }

                        public boolean isSearchInModuleContent(@NotNull Module aModule) {
                            if (aModule == null) {
                                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/scopeChooser/ScopeChooserCombo$5.isSearchInModuleContent must not be null");
                            }
                            return true;
                        }

                        public boolean isSearchInLibraries() {
                            return true;
                        }
                    };
                    result.add((SearchScope)prev);
                }
            } else {
                for (Usage usage : usages) {
                    PsiElement element;
                    if (!(usage instanceof PsiElementUsage) || (element = ((PsiElementUsage)usage).getElement()) == null || !element.isValid() || element.getContainingFile() == null) continue;
                    results.add(element);
                }
                if (!results.isEmpty()) {
                    result.add((SearchScope)new LocalSearchScope(results.toArray(new PsiElement[results.size()]), IdeBundle.message((String)"scope.previous.search.results", (Object[])new Object[0])));
                }
            }
        }
        for (final String favorite : favoritesLists = (favoritesManager = FavoritesManager.getInstance(project)) == null ? ArrayUtil.EMPTY_STRING_ARRAY : favoritesManager.getAvailableFavoritesLists()) {
            result.add((SearchScope)new GlobalSearchScope(project){

                public String getDisplayName() {
                    return "Favorite '" + favorite + "'";
                }

                public boolean contains(VirtualFile file) {
                    return favoritesManager.contains(favorite, file);
                }

                public int compare(VirtualFile file1, VirtualFile file2) {
                    return 0;
                }

                public boolean isSearchInModuleContent(@NotNull Module aModule) {
                    if (aModule == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/scopeChooser/ScopeChooserCombo$6.isSearchInModuleContent must not be null");
                    }
                    return true;
                }

                public boolean isSearchInLibraries() {
                    return true;
                }
            });
        }
        return result;
    }

    public static PsiElement getDataContextElement(DataContext dataContext) {
        PsiElement dataContextElement = (PsiElement)LangDataKeys.PSI_FILE.getData(dataContext);
        if (dataContextElement == null) {
            dataContextElement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        return dataContextElement;
    }

    @Nullable
    public SearchScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        if (idx < 0) {
            return null;
        }
        return ((ScopeDescriptor)combo.getSelectedItem()).getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        if (idx < 0) {
            return null;
        }
        return ((ScopeDescriptor)combo.getSelectedItem()).getDisplay();
    }
}

