/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.newProjectWizard.SupportForFrameworksStep;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NameLocationStep;
import com.intellij.ide.util.projectWizard.OutputPathsStep;
import com.intellij.ide.util.projectWizard.ProjectJdkForModuleStep;
import com.intellij.ide.util.projectWizard.ProjectJdkStep;
import com.intellij.ide.util.projectWizard.ProjectNameStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Computable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectWizardStepFactoryImpl
extends ProjectWizardStepFactory {
    public ModuleWizardStep createNameAndLocationStep(WizardContext wizardContext, JavaModuleBuilder builder, ModulesProvider modulesProvider, Icon icon, String helpId) {
        return new NameLocationStep(wizardContext, builder, modulesProvider, icon, helpId);
    }

    public ModuleWizardStep createNameAndLocationStep(WizardContext wizardContext) {
        return new ProjectNameStep(wizardContext);
    }

    public ModuleWizardStep createOutputPathPathsStep(ModuleWizardStep nameAndLocationStep, JavaModuleBuilder builder, Icon icon, String helpId) {
        return new OutputPathsStep((NameLocationStep)nameAndLocationStep, builder, icon, helpId);
    }

    public ModuleWizardStep createSourcePathsStep(ModuleWizardStep nameAndLocationStep, SourcePathsBuilder builder, Icon icon, String helpId) {
        return null;
    }

    public ModuleWizardStep createSourcePathsStep(WizardContext context, SourcePathsBuilder builder, Icon icon, @NonNls String helpId) {
        return new SourcePathsStep(builder, icon, helpId);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext context, JavaModuleBuilder builder, Computable<Boolean> isVisible, Icon icon, String helpId) {
        return this.createProjectJdkStep(context, null, builder, isVisible, icon, helpId);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext context, SdkType type, final JavaModuleBuilder builder, final Computable<Boolean> isVisible, final Icon icon, final @NonNls String helpId) {
        return new ProjectJdkForModuleStep(context, type){

            @Override
            public void updateDataModel() {
                super.updateDataModel();
                builder.setModuleJdk(this.getJdk());
            }

            public boolean isStepVisible() {
                return (Boolean)isVisible.compute();
            }

            @Override
            public Icon getIcon() {
                return icon;
            }

            @Override
            public String getHelpId() {
                return helpId;
            }
        };
    }

    public ModuleWizardStep createProjectJdkStep(final WizardContext wizardContext) {
        return new ProjectJdkStep(wizardContext){

            public boolean isStepVisible() {
                return AddModuleWizard.getNewProjectJdk(wizardContext) == null;
            }
        };
    }

    @Nullable
    public Sdk getNewProjectSdk(WizardContext wizardContext) {
        return AddModuleWizard.getNewProjectJdk(wizardContext);
    }

    public ModuleWizardStep createSupportForFrameworksStep(WizardContext wizardContext, ModuleBuilder moduleBuilder) {
        if (!FrameworkSupportUtil.getProviders(moduleBuilder).isEmpty()) {
            return new SupportForFrameworksStep(moduleBuilder, LibrariesContainerFactory.createContainer(wizardContext.getProject()));
        }
        return null;
    }
}

