/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesLayoutPanel;
import com.intellij.ide.util.newProjectWizard.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ModulesDetectionStep
extends AbstractStepWithProgress<List<ModuleDescriptor>> {
    private final ProjectFromSourcesBuilder myBuilder;
    private final ModuleInsight myInsight;
    private final Icon myIcon;
    private final String myHelpId;
    private ModulesLayoutPanel myModulesLayoutPanel;
    int myPreviousStateHashCode = -1;

    public ModulesDetectionStep(ProjectFromSourcesBuilder builder, ModuleInsight insight, Icon icon, @NonNls String helpId) {
        super("Stop module analysis?");
        this.myBuilder = builder;
        this.myInsight = insight;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    public void updateDataModel() {
        this.myBuilder.setModules(this.myModulesLayoutPanel.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.myModulesLayoutPanel = new ModulesLayoutPanel(this.myInsight, new ModulesLayoutPanel.LibraryFilter(){

            @Override
            public boolean isLibraryChosen(LibraryDescriptor libDescriptor) {
                return ModulesDetectionStep.this.myBuilder.isLibraryChosen(libDescriptor);
            }
        });
        return this.myModulesLayoutPanel;
    }

    @Override
    protected String getProgressText() {
        return "Searching for modules. Please wait.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shouldRunProgress() {
        int currentHash = this.calcStateHashCode();
        try {
            boolean bl = currentHash != this.myPreviousStateHashCode;
            return bl;
        }
        finally {
            this.myPreviousStateHashCode = currentHash;
        }
    }

    private int calcStateHashCode() {
        String contentEntryPath = this.myBuilder.getContentEntryPath();
        int hash = contentEntryPath != null ? contentEntryPath.hashCode() : 1;
        for (Pair<String, String> pair : this.myBuilder.getSourcePaths()) {
            hash = 31 * hash + ((String)pair.getFirst()).hashCode();
            hash = 31 * hash + ((String)pair.getSecond()).hashCode();
        }
        List<LibraryDescriptor> libs = this.myBuilder.getLibraries();
        for (LibraryDescriptor lib : libs) {
            Collection<File> files = lib.getJars();
            for (File file : files) {
                hash = 31 * hash + file.hashCode();
            }
        }
        return hash;
    }

    @Override
    protected List<ModuleDescriptor> calculate() {
        this.myInsight.scanModules();
        List<ModuleDescriptor> suggestedModules = this.myInsight.getSuggestedModules();
        return suggestedModules != null ? suggestedModules : Collections.emptyList();
    }

    @Override
    public boolean validate() {
        int answer;
        boolean validated = super.validate();
        if (!validated) {
            return false;
        }
        List modules = this.myModulesLayoutPanel.getChosenEntries();
        ArrayList<String> errors = new ArrayList<String>();
        for (ModuleDescriptor module : modules) {
            try {
                String moduleFilePath = module.computeModuleFilePath();
                if (!new File(moduleFilePath).exists()) continue;
                errors.add(IdeBundle.message((String)"warning.message.the.module.file.0.already.exist.and.will.be.overwritten", (Object[])new Object[]{moduleFilePath}));
            }
            catch (InvalidDataException e) {
                errors.add(e.getMessage());
            }
        }
        return errors.isEmpty() || (answer = Messages.showYesNoDialog((Component)this.getComponent(), (String)IdeBundle.message((String)"warning.text.0.do.you.want.to.continue", (Object[])new Object[]{StringUtil.join(errors, (String)"\n")}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0;
    }

    @Override
    protected void onFinished(List<ModuleDescriptor> moduleDescriptors, boolean canceled) {
        this.myModulesLayoutPanel.rebuild();
    }

    @NonNls
    public String getHelpId() {
        return this.myHelpId;
    }

    public Icon getIcon() {
        return this.myIcon;
    }
}

