/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.FixedHotfixGroupElement;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.HotfixGate;
import com.intellij.ide.errorTreeView.HotfixGroupElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.MutableErrorTreeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class ErrorViewStructure
extends AbstractTreeStructure {
    private final ErrorTreeElement myRoot = new MyRootElement();
    private final List<String> myGroupNames = new ArrayList<String>();
    private final Map<String, GroupingElement> myGroupNameToElementMap = new HashMap<String, GroupingElement>();
    private final Map<String, List<NavigatableMessageElement>> myGroupNameToMessagesMap = new HashMap<String, List<NavigatableMessageElement>>();
    private final Map<ErrorTreeElementKind, List<SimpleMessageElement>> mySimpleMessages = new HashMap<ErrorTreeElementKind, List<SimpleMessageElement>>();
    private static final ErrorTreeElementKind[] ourMessagesOrder = new ErrorTreeElementKind[]{ErrorTreeElementKind.INFO, ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.GENERIC};
    private final Project myProject;
    private final boolean myCanHideWarnings;

    public ErrorViewStructure(Project project, boolean canHideWarnings) {
        this.myProject = project;
        this.myCanHideWarnings = canHideWarnings;
    }

    public Object getRootElement() {
        return this.myRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildElements(Object element) {
        if (element == this.myRoot) {
            ArrayList<ErrorTreeElement> children = new ArrayList<ErrorTreeElement>();
            for (ErrorTreeElementKind kind : ourMessagesOrder) {
                List<SimpleMessageElement> elems;
                if (ErrorTreeElementKind.WARNING.equals((Object)kind) && this.myCanHideWarnings && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings() || (elems = this.mySimpleMessages.get(kind)) == null) continue;
                children.addAll(elems);
            }
            for (String myGroupName : this.myGroupNames) {
                GroupingElement groupingElement = this.myGroupNameToElementMap.get(myGroupName);
                if (!this.shouldShowFileElement(groupingElement)) continue;
                children.add(groupingElement);
            }
            return ArrayUtil.toObjectArray(children);
        }
        if (element instanceof GroupingElement) {
            Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
            synchronized (map) {
                List<NavigatableMessageElement> children = this.myGroupNameToMessagesMap.get(((GroupingElement)element).getName());
                if (children != null && children.size() > 0) {
                    if (this.myCanHideWarnings && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
                        ArrayList<NavigatableMessageElement> filtered = new ArrayList<NavigatableMessageElement>(children.size());
                        for (NavigatableMessageElement navigatableMessageElement : children) {
                            if (ErrorTreeElementKind.WARNING.equals((Object)navigatableMessageElement.getKind())) continue;
                            filtered.add(navigatableMessageElement);
                        }
                        return filtered.toArray();
                    }
                    return children.toArray();
                }
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShowFileElement(GroupingElement groupingElement) {
        if (!this.myCanHideWarnings || !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return this.getChildCount(groupingElement) > 0;
        }
        Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
        synchronized (map) {
            List<NavigatableMessageElement> children = this.myGroupNameToMessagesMap.get(groupingElement.getName());
            if (children != null) {
                for (NavigatableMessageElement child : children) {
                    if (ErrorTreeElementKind.WARNING.equals((Object)child.getKind())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getParentElement(Object element) {
        if (element instanceof GroupingElement || element instanceof SimpleMessageElement) {
            return this.myRoot;
        }
        if (element instanceof NavigatableMessageElement) {
            return ((NavigatableMessageElement)element).getParent();
        }
        return null;
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        ErrorTreeNodeDescriptor errorTreeNodeDescriptor = new ErrorTreeNodeDescriptor(this.myProject, parentDescriptor, (ErrorTreeElement)element);
        if (errorTreeNodeDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/errorTreeView/ErrorViewStructure.createDescriptor must not return null");
        }
        return errorTreeNodeDescriptor;
    }

    public final void commit() {
    }

    public final boolean hasSomethingToCommit() {
        return false;
    }

    public void addMessage(ErrorTreeElementKind kind, String[] text, VirtualFile file, int line, int column, Object data) {
        if (file != null) {
            int guiline = line < 0 ? -1 : line + 1;
            int guicolumn = column < 0 ? -1 : column + 1;
            this.addNavigatableMessage(file.getPresentableUrl(), (Navigatable)new OpenFileDescriptor(this.myProject, file, line, column), kind, text, data, NewErrorTreeViewPanel.createExportPrefix(guiline), NewErrorTreeViewPanel.createRendererPrefix(guiline, guicolumn), file);
        } else {
            this.addSimpleMessage(kind, text, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getGroupChildrenData(String groupName) {
        Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
        synchronized (map) {
            List<NavigatableMessageElement> children = this.myGroupNameToMessagesMap.get(groupName);
            if (children != null && !children.isEmpty()) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (NavigatableMessageElement child : children) {
                    Object data = child.getData();
                    if (data == null) continue;
                    result.add(data);
                }
                return result;
            }
            return Collections.emptyList();
        }
    }

    public void addFixedHotfixGroup(String text, List<SimpleErrorData> children) {
        FixedHotfixGroupElement group = new FixedHotfixGroupElement(text, null, null);
        this.addGroupPlusElements(text, group, children);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<SimpleErrorData> children, MutableErrorTreeView view) {
        String text = hotfixData.getErrorText();
        HotfixGroupElement group = new HotfixGroupElement(text, null, null, (Consumer<HotfixGate>)hotfixData.getFix(), hotfixData.getFixComment(), view);
        this.addGroupPlusElements(text, group, children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupPlusElements(String text, GroupingElement group, List<SimpleErrorData> children) {
        Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
        synchronized (map) {
            this.myGroupNames.add(text);
            this.myGroupNameToElementMap.put(text, group);
            ArrayList<MyNavigatableWithDataElement> elements = new ArrayList<MyNavigatableWithDataElement>();
            this.myGroupNameToMessagesMap.put(text, elements);
            for (SimpleErrorData child : children) {
                VirtualFile vf = child.getVf();
                elements.add(new MyNavigatableWithDataElement(this.myProject, child.getKind(), group, child.getMessages(), vf, NewErrorTreeViewPanel.createExportPrefix(-1), NewErrorTreeViewPanel.createRendererPrefix(-1, -1)));
            }
        }
    }

    public void addMessage(ErrorTreeElementKind kind, String[] text, Object data) {
        this.addSimpleMessage(kind, text, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNavigatableMessage(String groupName, Navigatable navigatable, ErrorTreeElementKind kind, String[] message, Object data, String exportText, String rendererTextPrefix, VirtualFile file) {
        Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
        synchronized (map) {
            List<NavigatableMessageElement> elements = this.myGroupNameToMessagesMap.get(groupName);
            if (elements == null) {
                elements = new ArrayList<NavigatableMessageElement>();
                this.myGroupNameToMessagesMap.put(groupName, elements);
            }
            elements.add(new NavigatableMessageElement(kind, this.getGroupingElement(groupName, data, file), message, navigatable, exportText, rendererTextPrefix));
        }
    }

    private void addSimpleMessage(ErrorTreeElementKind kind, String[] text, Object data) {
        List<SimpleMessageElement> elements = this.mySimpleMessages.get(kind);
        if (elements == null) {
            elements = new ArrayList<SimpleMessageElement>();
            this.mySimpleMessages.put(kind, elements);
        }
        elements.add(new SimpleMessageElement(kind, text, data));
    }

    public GroupingElement getGroupingElement(String groupName, Object data, VirtualFile file) {
        GroupingElement element = this.myGroupNameToElementMap.get(groupName);
        if (element == null) {
            element = new GroupingElement(groupName, data, file);
            this.myGroupNames.add(groupName);
            this.myGroupNameToElementMap.put(groupName, element);
        }
        return element;
    }

    public int getChildCount(GroupingElement groupingElement) {
        List<NavigatableMessageElement> children = this.myGroupNameToMessagesMap.get(groupingElement.getName());
        return children == null ? 0 : children.size();
    }

    public void clear() {
        this.myGroupNames.clear();
        this.myGroupNameToElementMap.clear();
        this.myGroupNameToMessagesMap.clear();
        this.mySimpleMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorTreeElement getFirstMessage(ErrorTreeElementKind kind) {
        if (this.myCanHideWarnings && ErrorTreeElementKind.WARNING.equals((Object)kind) && ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings()) {
            return null;
        }
        List<SimpleMessageElement> simpleMessages = this.mySimpleMessages.get(kind);
        if (simpleMessages != null && simpleMessages.size() > 0) {
            return simpleMessages.get(0);
        }
        for (String path : this.myGroupNames) {
            Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
            synchronized (map) {
                List<NavigatableMessageElement> messages = this.myGroupNameToMessagesMap.get(path);
                if (messages != null) {
                    for (NavigatableMessageElement navigatableMessageElement : messages) {
                        if (!kind.equals((Object)navigatableMessageElement.getKind())) continue;
                        return navigatableMessageElement;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Map<String, List<NavigatableMessageElement>> map = this.myGroupNameToMessagesMap;
        synchronized (map) {
            this.myGroupNames.remove(name);
            this.myGroupNameToElementMap.remove(name);
            this.myGroupNameToMessagesMap.remove(name);
        }
    }

    private static class MyNavigatableWithDataElement
    extends NavigatableMessageElement {
        private static final Icon ourFileIcon = IconLoader.getIcon((String)"/fileTypes/unknown.png");
        private final VirtualFile myVf;
        private final CustomizeColoredTreeCellRenderer myCustomizeColoredTreeCellRenderer;

        private MyNavigatableWithDataElement(Project project, ErrorTreeElementKind kind, GroupingElement parent, String[] message, final @NotNull VirtualFile vf, String exportText, String rendererTextPrefix) {
            if (vf == null) {
                throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/ide/errorTreeView/ErrorViewStructure$MyNavigatableWithDataElement.<init> must not be null");
            }
            super(kind, parent, message, (Navigatable)new OpenFileDescriptor(project, vf, -1, -1), exportText, rendererTextPrefix);
            this.myVf = vf;
            this.myCustomizeColoredTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    String[] messages;
                    if (MyNavigatableWithDataElement.this.myVf != null) {
                        Icon icon = MyNavigatableWithDataElement.this.myVf.getFileType().getIcon();
                        renderer.setIcon(icon);
                    }
                    String text = (messages = MyNavigatableWithDataElement.this.getText()) == null || messages.length == 0 ? vf.getPath() : messages[0];
                    renderer.append(text);
                }
            };
        }

        @Override
        public Object getData() {
            return this.myVf;
        }

        @Override
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myCustomizeColoredTreeCellRenderer;
        }
    }

    private static class MyRootElement
    extends ErrorTreeElement {
        private MyRootElement() {
        }

        @Override
        public String[] getText() {
            return null;
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public String getExportTextPrefix() {
            return "";
        }
    }
}

